;********************************************************
;*							*
;*	--  COLD START LOADER FOR CP/M V2.2  --		*
;*							*
;*	Russell Smith		7-October-80		*
;*							*
;********************************************************
;
;
MSIZE	EQU	60		;MEMORY CAPACITY IN KBYTES
MONITR	EQU	0F000H		;BASE ADDRESS OF MONITOR
BIAS	EQU	.RES.(MSIZE-20)*1024
CBIOS	EQU	.RES.4A00H+BIAS
	
;
;
;
	ORG	128
	
START:	JR	BOOT-$
	
	DEFM	'60K CP/M V2.2 '
	
BOOT:	LD	E,0		;LOAD E WITH TRACK#
	LD	HL,.RES.3400H+BIAS
	LD	BC,0D02H
	CALL	RDLOOP		;READ EVEN SECTORS ON TRK 0
	LD	HL,.RES.3480H+BIAS
	LD	BC,0C03H
	CALL	RDLOOP		;READ ODD SECTORS ON TRK 0
	LD	C,1		;LOAD C WITH TRACK#
	CALL	MONITR+33	;CALL MONITOR SEEK ROUTINE
	JR	NZ,ERROR-$
	LD	HL,.RES.4080H+BIAS
	LD	BC,0D01H	
	CALL	RDLOOP		;READ ODD SECTORS ON TRK 1
	LD	HL,.RES.4100H+BIAS
	LD	BC,0D02H
	CALL	RDLOOP		;READ EVEN SECTORS ON TRK 1
	
	JP	CBIOS		;JUMP TO CP/M COLD START ENTRY
;
;
RDLOOP:	PUSH	HL		;SAVE PARAMETERS
	PUSH	BC
	CALL	MONITR+36	;CALL MONITOR DISK READ ROUTINE
	POP	BC
	POP	HL
	JR	NZ,ERROR-$	;READ ERROR IF Z FLAG SET
	INC	H		;BUMP DATA POINTER BY 256
	INC	C
	INC	C		;BUMP SECTOR# BY 2
	DJNZ	RDLOOP-$
	RET
;
;
ERROR:	LD	HL,MSG		;POINT TO ERROR MESSAGE
PMSG:	LD	A,(HL)
	CALL	MONITR+9	;OUTPUT TO MONITOR CONSOLE
	LD	A,(HL)
	INC	HL
	OR	A		;CHECK FOR END OF STRING
	JR	NZ,PMSG-$	;PRINT ANOTHER BYTE OF NOT
	
	JP	MONITR+3	;JUMP BACK TO MONITOR
	
MSG:	DEFM	'   LOAD ABORTED'
	DEFB	0
;
	END
