/* The display routine assumes that the storage format for double numbers
is that of Mix-C (the same format is used by MBASIC).  If you re-compile
this with another C compiler, be sure that it has enough accuracy.  Aztec-C
is not adequate in this respect.*/

display(in)  /* displays a double number in IEEE binary form (displayed */
char *in;    /* in hexadecimal) */
{
char out[8];
unsigned exp;
int j;

for( j=0; j<6; j++ )
   out[j] = (in[j+1]<<5) | ((unsigned)in[j]>>3);
exp = ((0x37e + (unsigned)in[7])<<4)
      | ((0x7f & in[6])>>3) | ((0x80 & in[6])<<8);
out[6] = exp;
out[7] = exp>>8;
for( j=7; j>=0; j-- )
   printf("  %x",in[j]);
printf("\n");
for( j=7; j>=0; j-- )
   printf("  %x",out[j]);
printf("\n");
}

double x,y,z;
main(){
printf("This program displays (in hexadecimal) the binary form of double\n");
printf("precision numbers that are input at the keyboard.  The result of\n");
printf("(number * multiplier / divisor) is used for the display.  The\n");
printf("first line of output is for 8-bit exponent and 56-bit mantissa,\n");
printf("while the second line is for IEEE double precision.\n\n");
for(;;){
   printf("number multiplier divisor: ");
   scanf("%lf %lf %lf",&x,&y,&z);
   x = x * y / z;
   display(&x);
   }
}
