/************************************************************************/
/*				y4.c					*/
/*  YACC source file #4 (of 4). 					*/
/************************************************************************/    
     
/************************************************************************/    
/*				contents				*/
/*									*/
/*									*/
/*  * y4PutParser	Write out the parser: yyact, yypact, yypgo.	*/
/*  * y4PutArray	y4PutParser helper.				*/
/*    y4Optimize							*/
/*  * y4EnterGoto	Enter goto on nonterminal i into array a.	*/
/*  * y4GetNumber	Read and convert an integer from stdin. 	*/
/*  * y4NextI		Find the next i.				*/
/*  * y4OptSummary	Summarize optimizer performance.		*/
/*  * y4StoreState	Enter state i into the a array. 		*/
/*									*/
/* * Local to this file.						*/
/*									*/
/************************************************************************/
    
    
/************************************************************************/   
/*                              history                                 */    
/*                                                                      */    
/* 85Nov15 CrT  Global variable names decrypted.                        */
/* 85Nov13 CrT	Give plaintiff routine in error messages.		*/
/* 85Nov12 CrT	Function names decrypted. Still unique in first 6 chars.*/
/* 85Nov11 CrT	y4.c reconstructed from  8 subfiles.  Cosmetics.	*/
/* 80Dec18 RBD	ZAPFILE not used for decus compiler, fmkdl() used.	*/
/* 80Dec06 RBD	Broken out of y4.c, impure data in y4imp.c.		*/
/* 7?????? SCJ	Created.						*/
/*                                                                      */ 
/*                              credits                                 */ 
/*      CrT=CrT                                                         */ 
/*      RBD=Bob Denny                                                   */  
/*      SCJ=Steven C Johnson.                                           */  
/*      SG =Scott Guthery                                               */  
/************************************************************************/ 

   
#include <..\h\stdio.h>  
#include "system.h"
#include "dtxtrn.h"
                  
#define yypact y1Temp
#define y4Greed  y1StateType
                  
#define NOMORE -1000
                  
static int * y4GGreed = y1LookaheadSet[0].lset;
static int * y4pgo    = y1WorkingSet[0].ws.lset;
static int * yypgo  = &y2NonterminalState[0].tvalue;
                  
static int y4MaxSpread = 0;	    /* Maximum spread of any entry.		    */
static int y4MaxOffset = 0;	    /* Maximum offset into y1Action array.		   */
static int *y4FreePool	= y2Pool;
static int *y4LastAction;

/* Debug switch for nextI. Set to TRUE for debugging printouts. */
static int y4DebugNext	 = 0;

/* Debugging switch for action optimization. Set to: */
/*     0 for no debugging printouts.                 */
/*     1 for no debugging printouts.		     */
/*     2 for general narration.                      */
/*     3 for narration plus complete table dump.     */

static int y4DebugActions    = 0;

/************************************************************************/ 
/*    y4PutParser	Write out the parser: yyact, yypact, yypgo.	*/
/************************************************************************/
static y4PutParser() {		/* Called only by y4Optimize	*/

    fprintf( y2ytabcFD, "# define YYLAST %d\n", y4LastAction-y1Action+1 );
          
    y4PutArray( "yyact" ,   y1Action, (y4LastAction-y1Action)+1 );
    y4PutArray( "yypact",  y1GotoIndex, y1NextState	);
    y4PutArray( "yypgo" , y4pgo, y2LastNonterminal+1  );
}
 
/************************************************************************/
/*	y4PutArray	y4PutParser helper.				*/
/************************************************************************/
y4PutArray( s, v, n )		/* Called only by y4PutParser. */
char *s;
int  *v, n;
{
    register i;
          
    fprintf( y2ytabcFD, "short %s[]={\n", s );

    for (i = 0;   i < n;   ) {

	if (i % 10   ==   0)   fprintf( y2ytabcFD, "\n"    );

	fprintf( y2ytabcFD, "%4d", v[i] );

	if (++i == n)	       fprintf( y2ytabcFD, " };\n" );
	else		       fprintf( y2ytabcFD, ","	   );
    }
}

/************************************************************************/
/*    y4Optimize	Read the arrays from tempfile, set parameters.	*/
/************************************************************************/
y4Optimize() {		/* Called only from main. */
           
    register i, *p, j, k, *q; 
           
    /* Read the arrays from tempfile and set parameters: */ 
  
    if ((y2InputFD = fopen(TEMPNAME,"r"))   ==	 NULL) {
	y1Error( "y4Optimize: Cannot open tempfile" );
    } 
  
    y4pgo[0]	  = 0;
    yypact[0]   = 0; 
    y1NextState      = 0;
    y2LastNonterminal	  = 0;
  
    loop {
  
        switch (y4GetNumber()) { 
  
	case '\n':	yypact[++y1NextState] = (--y4FreePool) - y2Pool;     continue;
        case ',':                                               continue; 
        case '$':                                               break; 
        default: 
	    y1Error( "y4Optimize: Bad tempfile(1)" );
        } 
        break; 
    } 
           
    yypact[ y1NextState ]    = yypgo[0]  = (--y4FreePool) - y2Pool;
           
    loop {
  
        switch (y4GetNumber()) { 
  
	case '\n':	yypgo[++y2LastNonterminal]= y4FreePool-y2Pool;		  continue;
        case '\r':                                              continue; 
        case ',' :                                              continue; 
        case -1  :      /* EOF */                               break; 
        default: 
	    y1Error( "y4Optimize: Bad tempfile(2)" );
        } 
        break; 
    } 
           
    yypgo[ y2LastNonterminal-- ]  = (--y4FreePool) - y2Pool;
  
    for (i = 0;   i < y1NextState;   ++i) {
        k = 32000; 
        j = 0; 
	q = y2Pool + yypact[i+1];
	for (p = y2Pool + yypact[i];   p < q;	p += 2) {
  
            if (*p > j)   j = *p; 
            if (*p < k)   k = *p; 
        } 
  
        if (k <= j) { 
  
            /***********************************************/ 
            /* Nontrivial situation.                       */ 
            /* Temporarily, kill this for compatibility    */ 
            /* j -= k;  j is now the range                 */ 
            /***********************************************/ 
  
	    if (k > y4MaxOffset)   y4MaxOffset = k;
        } 
	y4Greed[i]    = (yypact[ i+1 ] - yypact[ i ])	+   2 * j;
  
	if (j > y4MaxSpread)   y4MaxSpread = j;
    } 
           
    /* Initialize y4GGreed table: */
           
    for (i = 1;   i <= y2LastNonterminal;   ++i) {
  
	y4GGreed[i] = 1;
        j = 0; 
  
        /* Minimum entry index is always 0: */ 
	q = y2Pool + yypgo[i+1] -1;
  
	for (p = y2Pool + yypgo[ i ];	p < q;	 p += 2) {
  
	    y4GGreed[i] += 2;
  
            if (*p > j)   j = *p; 
        } 
	y4GGreed[ i ] = y4GGreed[ i ]	+   2 * j;
  
	if (j > y4MaxOffset)   y4MaxOffset = j;
    } 
           
    /* Prepare to put the shift actions into the y1Action array: */
           
    for (i = 0;   i < MAXaCTIONS;   ++i)   y1Action[i] = 0;
    y4LastAction = y1Action;
           
    for (i = 0;   i < y1NextState;   ++i) {
  
	if (y4Greed[ i ] == 0	&&   y4DebugActions > 1) {
  
	    fprintf( y2ytabcFD, "State %d: null\n", i );
        } 
	y1GotoIndex[i] = YYFLAG1;
    } 
           
    while ((i = y4NextI())   !=   NOMORE) { 
  
        if (i >= 0)   y4StoreState(  i ); 
        else          y4EnterGoto(  -i ); 
           
    } 
           
    if (y4DebugActions > 2) {
  
	/* Print y1Action array: */
	for (p = y1Action;   p <= y4LastAction;   p += 10) {
  
	    fprintf( y2ytabcFD, "%4d  ", p-y1Action );
  
	    for (i = 0;   i < 10;   ++i)   fprintf( y2ytabcFD, "%4d  ", p[i] );
  
	    fprintf( y2ytabcFD, "\n" );
        } 
    } 
  
    /* Write out the output appropriate to the language: */ 
    y4PutParser(); 
           
    y4OptSummary(); 
           
    fclose( y2InputFD );
  
    ZAPFILE(TEMPNAME); 
} 

/************************************************************************/
/*	y4EnterGoto	Enter goto on nonterminal i into array y1Action.       */
/************************************************************************/
y4EnterGoto( i )	/* Called only from y4Optimize. */
int i;
{
    register *p, *r, *s, *q1, *q2;
          
    y4GGreed[ i ] = 0;
          
    q2	= y2Pool + yypgo[i+1] - 1;
    q1	= y2Pool + yypgo[i  ]	 ;
          
    /* Find a place for it: */
          
    for (p = y1Action;	 p < &y1Action[MAXaCTIONS];   ++p) {

	if (*p)   continue;

	for (r = q1;   r < q2;	 r += 2) {

	    s = p + *r +1;

	    if (*s)   goto nextgp;

	    if (s > y4LastAction) {
		if ((y4LastAction = s) > &y1Action[ MAXaCTIONS ])   {
		    y1Error( "y4EnterGoto: Array y1Action[] overflowed(1)" );
		}
            } 
	}

        /* We have found a spot: */
          
	*p  = *q2;

	if (p > y4LastAction) {

	    if ((y4LastAction = p)   >	 &y1Action[ MAXaCTIONS ]) {
		y1Error( "y4EnterGoto: Array y1Action[] overflowed(2)" );
	    }
	}

	for (r = q1;   r < q2;	 r += 2) {

	    s  = p + *r + 1;
	    *s = r[ 1 ]    ;
	}
          
	y4pgo[ i ]    = p - y1Action;

	if (y4DebugActions > 1) {
	    fprintf(
		y2ytabcFD,
		"Nonterminal %d, entry at %d\n",
		i,
		y4pgo[i]
	    );
	}
	goto nextgi;
nextgp: ;

    }
    y1Error( "y4EnterGoto: Cannot place goto %d\n", i );
          
nextgi:   
    ;
}
 
/************************************************************************/
/*	y4GetNumber	Read and convert an integer from stdin. 	*/
/************************************************************************/
static y4GetNumber() {		/* Called only from y4Optimize. */
    register s, val, c;
          
   /*********************************************************/
   /* Read and convert an integer from the standard input.  */
   /* Return the terminating character. 		    */
   /* Blanks, tabs, and newlines are ignored.		    */
   /*********************************************************/

   s	= 1;
   val	= 0;
          
   while  ((c = y1GetChar( y2InputFD ))   !=   EOF) {

	if	(isdigit( c ))	  val = val * 10   +   (c - '0');
	else if ( c == '-'   )	  s   = -1			;
	else if ( c == '\r'  )	  continue			;
	else			  break 			;

    }

    *y4FreePool++ = s * val;

    if (y4FreePool > &y2Pool[ MAXy2POOL ])   y1Error( "y4GetNumber: Out of space" );

    return   c;
}
 
/************************************************************************/
/*	y4NextI 	Find the next i.				*/
/************************************************************************/
static y4NextI() {	/* Called only from y4Optimize. */
    register i, max, maxi;
          
    max = 0;
          
    for (i = 1;   i <= y2LastNonterminal;   ++i){

	if( y4GGreed[i] >= max ) {

	    max     = y4GGreed[i];
	    maxi    = -i;
	}
    }
          
    for (i = 0;   i < y1NextState;   ++i) {

	if (y4Greed[ i ]   >=	max) {

	    max     = y4Greed[i];
	    maxi    = i;
	}
    }
          
    if (y4DebugNext    )   fprintf( y2ytabcFD, "nxti = %d, max = %d\n", maxi, max );
    if (max == 0)   return NOMORE;
    else	    return maxi  ;
}
 
/************************************************************************/
/*    y4OptSummary      Summary optimizer performance.                  */
/************************************************************************/
static y4OptSummary() { 	/* Called only from y4Optimize. */

    register int i, *p;
          
    if (y2OutputFD == NULL)   return;
          
    i	= 0;

    for (p = y4LastAction;   p >= y1Action;   --p) {

	if (*p == 0)   ++i;
    }

    fprintf(
	y2OutputFD,
	"Optimizer space used: input %d/%d, output %d/%d\n",
	y4FreePool-y2Pool+1,
	MAXy2POOL,
	y4LastAction - y1Action +1,
	MAXaCTIONS
    );
    fprintf(   y2OutputFD,   "%d table entries, %d zero\n",   (y4LastAction-y1Action)+1,   i);

    fprintf(
	y2OutputFD,
	"maximum spread: %d, maximum offset: %d\n",
	y4MaxSpread,
	y4MaxOffset
    );
    fclose( y2OutputFD );
}
 
/************************************************************************/
/*	y4StoreState	Enter state i into the y1Action array.		       */
/************************************************************************/
static y4StoreState( i )	/* Called only from y4Optimize. */
int i;
{
    register *r, *s, n, flag, j, *q1, *q2;
          
    y4Greed[ i ]  = 0;
          
    q2	= y2Pool + yypact[ i+1 ];
    q1	= y2Pool + yypact[ i   ];

    /* Find an acceptable place: */
          
    for (n = -y4MaxOffset;   n < MAXaCTIONS;   ++n) {

	flag = 0;

	for (r = q1;   r < q2;	 r += 2) {

	    if ((s = *r + n + y1Action)   <   y1Action)   goto nextn;

	    if (*s == 0)	   ++flag;
	    else if (*s != r[1])   goto nextn;
	}
          
        /********************************************/
	/* Check that the position equals another   */
	/* only if the states are identical:	    */
        /********************************************/

	for (j = 0;   j < y1NextState;	 ++j) {

	    if (y1GotoIndex[ j ] == n) {

		if (flag)   goto nextn;  /* We have some disagreement. */

		if (yypact[ j+1 ] + yypact[i]	==   yypact[j] + yypact[i+1]) {

		    /* States are equal: */
		    y1GotoIndex[ i ] = n;

		    if (y4DebugActions > 1) {
			fprintf(
			    y2ytabcFD,
			    "State %d: entry at %d equals state %d\n",
			    i,
			    n,
			    j
			);
		    }
		    return;
		}

		/* We have some disagreement: */
		goto nextn;
	    }
	}
          
	for (r = q1;   r < q2;	 r += 2) {

	    if ((s = *r + n + y1Action)   >=   &y1Action[ MAXaCTIONS ]) {
		y1Error( "y4StoreState: Out of space in optimizer y1Action[] array" );
	    }

	    if (s > y4LastAction)   y4LastAction = s;

            if (*s != 0   &&   *s != r[1]) {
		y1Error(
		    "y4StoreState: y1Action[] array clobbered, pos'n %d, by %d",
		    s-y1Action,
		    r[1]
		);
	    }
	    *s = r[1];
	}
	y1GotoIndex[ i ] = n;

	if (y4DebugActions > 1)   fprintf( y2ytabcFD, "State %d: entry at %d\n", i, y1GotoIndex[i] );

        return; 
          
nextn:	;
    }
    y1Error( "y4StoreState: Failed to place state %d\n",   i   );
}
