C	  TEKTRONIX 4662 PLOTTING & DIGITIZING INTERFACE SUBROUTINES
C	    INCLUDES  PLOT, APLOT, OUTT, LPLOT, AND GETGIN
C	    SUPPORTS ALL FOUR LINETYPES OF THE GT-46 SCREEN
C	    HANDLES HANDSHAKING WITH THE 4662 FLATBED PLOTTER
C		TO ENSURE THAT NO OVERRUN OF DATA CAN OCCUR
C
	SUBROUTINE PLOT(IX,IY)
C	  RELATIVE PLOTTING SUBROUTINE
C	  SIMPLY MOVES THE PLOTTER PEN (WHETHER UP OR DOWN)
C	  TO A RELATIVE POSITION ON THE PLATEN
C	   WRITTEN BY MICHAEL LAMPI   SPRING 1979
C
	COMMON/PLOTTR/LASTX,LASTY
C	  CHECK FOR ROOM IN THE PLOTTER BUFFER
	CALL BUFCHK(6)
	LASTX=(LASTX+IX)
	LASTY=(LASTY+IY)
	LASTXX=LASTX
	LASTYY=LASTY
	IF(LASTX.LE."7777) GOTO 10
	WRITE(5,5) LASTX
	LASTXX="7777
 5	FORMAT(' WARNING: PLASTX=',O6)
 10	IF(LASTY.LE."7777) GOTO 20
	WRITE(5,15) LASTY
	LASTYY="7777
 15	FORMAT(' WARNING: PLASTY=',O6)
 20	IF(LASTX.GE.0) GOTO 30
	WRITE(5,5) LASTX
	LASTXX=0
 30	IF(LASTY.GE.0) GOTO 40
	WRITE(5,15) LASTY
	LASTYY=0
 40	CONTINUE
C	SCALE Y DIMENSION PROPERLY SO IT WILL FIT ON PLOTTER
C	TRIED 3124., BUT DIDN'T SEEM TO WORK PROPERLY
	LASTYY=FLOAT(LASTYY)*(2731./4096.)
C	FIRST CHAR OUTPUT = HIY
	ICHAR="040+(LASTYY/"200)
	CALL OUTT(ICHAR)
C	XLOY - LOWEST ORDER BITS
	ICHAR="140+(LASTXX.AND."3)+(LASTYY.AND."3)*"4
	CALL OUTT(ICHAR)
C	LOY
	ICHAR="140+(LASTYY.AND."174)/4
	CALL OUTT(ICHAR)
C	NOW FOR X - HIX
	ICHAR="040+(LASTXX/"200)
	CALL OUTT(ICHAR)
C	LOX
	ICHAR="100+(LASTXX.AND."174)/4
	CALL OUTT(ICHAR)
	RETURN
	END



	SUBROUTINE APLOT(IX,IY,INTENS)
C	  ABSOLUTE POINT PLOTTING SUBROUTINE
C	  POSITIONS THE PLOTTER PEN GIVEN ABSOLUTE COORDINATES
C	  WRITTEN BY MICHAEL LAMPI   SPRING 1979
C
	COMMON/PLOTTR/LASTX,LASTY
	INTEGER GS,BELL
	DATA GS/"35/,BELL/"7/
C	SET UP NEW LASTX AND LASTY
	LASTX=4*IX
	IF(LASTX.LE."7777) GOTO 10
	WRITE(5,5) LASTX
	LASTX="7777
 5	FORMAT(' WARNING: ALASTX=',O6)
 10 	LASTY=4*IY
	IF(LASTY.LE."7777) GOTO 15
	WRITE(5,14) LASTY
	LASTY="7777
 14	FORMAT(' WARNING: ALASTY=',O6)
 15	IF(LASTX.GE.0) GOTO 20
	WRITE(5,5) LASTX
	LASTX=0
 20	IF(LASTY.GE.0) GOTO 30
	WRITE(5,14) LASTY
	LASTY=0
C	GET INTO GRAPHIC MODE WITHOUT (BELL) TO DRAW AN INVISIBLE LINE
 30	CALL OUTT(GS)
C	NOW LET PLOT DO ALL THE WORK
	CALL PLOT(0,0)
C	SEE IF WE SHOULD DROP THE PEN AND MAKE A DOT
	IF(INTENS.NE.0) CALL PLOT(0,0)
	RETURN
	END


	SUBROUTINE OUTT(ICHAR)
C	  WAIT FOR THE REMOTE LINE TO GET READY
 1	J=IOUTT1(ICHAR)
	IF(J.NE.0) GOTO 1
	RETURN
	END



	SUBROUTINE LPLOT(IX,IY,LINTYP,INTENS)
C	  THIS SUBROUTINE DRAWS ALL FOUR LINETYPES THAT THE GT-46
C	  GRAPHICS SCREEN SUPPORTS ON THE TEKTRONIX 4662 FLATBED PLOTTER
C
C	  WRITTEN BY MICHAEL LAMPI   SPRING 1979
C
	COMMON/PLOTTR/LASTX,LASTY
	IMPLICIT INTEGER (A-Z)
	REAL SFRAC,FRAC,TIMES,XSUM,YSUM,DX,DY,DDX,DDY,DBX,DBY,SLEN
	DATA GS/"35/,BELL/"7/
C
	ITX=IX*4
	ITY=IY*4
	IF(INTENS.NE.0.AND.LINTYP.NE.1) GOTO 100
C	  SOLID LINETYPE OR BLANK (UNDRAWN) LINE
	IF(INTENS.EQ.0) CALL OUTT(GS)
	IF(INTENS.NE.0) CALL PLOT(0,0)
 50	CALL PLOT(ITX,ITY)
	RETURN
C	  INITIALIZE TRUNCATION ACCUMULATORS
 100	XSUM=0.
	YSUM=0.
	IF(LINTYP.NE.2) GOTO 200
C	  WIDE-DASHED LINETYPE
	LENGTH=44*4
	DLEN=25*4
 105	FRAC=FLOAT(DLEN)/FLOAT(LENGTH)
	TIMES=(FLOAT(ITX)**2+FLOAT(ITY)**2)**.5/FLOAT(LENGTH)
	DX=FLOAT(IX)/TIMES
	DY=FLOAT(IY)/TIMES
	DDX=DX*FRAC
	DDY=DY*FRAC
	DBX=DX-DDX
	DBY=DY-DDY
C	  IF LENGTH <= MINIMUM DRAWN LENGTH SIMPLY DRAW A NORMAL VECTOR
	IF(TIMES.LT.1.) GOTO 50
	ITER=IFIX(TIMES)
	X=0
	Y=0
C	  PUT PEN DOWN FOR FIRST DASH
	CALL PLOT(0,0)
	DO 120 I=1,ITER
	CALL PLOT(4*(IFIX(DDX))+X,4*(IFIX(DDY))+Y)
C	  NOW DRAWN BLANK VECTOR PORTION OF DASHED LINE
	CALL OUTT(GS)
	CALL PLOT(4*(IFIX(DBX)),4*(IFIX(DBY)))
C	  NOW ADD UP THE ROUNDOFF
	XSUM=XSUM+4.*(DDX-AINT(DDX)+DBX-AINT(DBX))
	YSUM=YSUM+4.*(DDY-AINT(DDY)+DBY-AINT(DBY))
	X=IFIX(XSUM)
	XSUM=XSUM-AINT(XSUM)
	Y=IFIX(YSUM)
	YSUM=YSUM-AINT(YSUM)
 120	CONTINUE
	ITX=(TIMES-FLOAT(ITER))*DX*4.+XSUM+FLOAT(X)
	ITY=(TIMES-FLOAT(ITER))*DY*4.+YSUM+FLOAT(Y)
	GOTO 50
C
 200	IF(LINTYP.NE.3) GOTO 300
C	  NOW FOR THE SHORT-DASHED LINETYPE
	LENGTH=15*4
	DLEN=7*4
	GOTO 105
C
C	  NOW FOR THE DASH-DOT LINETYPE
 300	CONTINUE
	CALL PLOT(0,0)
	DLEN=16*4
	LENGTH=38*4
C	  DETERMINE SIZE OF UNDRAWN PORTION OF EACH DASH/DOT COMBINATION
	SLEN=FLOAT(LENGTH-DLEN)/2.
	FRAC=FLOAT(DLEN)/FLOAT(LENGTH)
C	  DETERMINE NUMBER OF ITERATIONS
	TIMES=(FLOAT(ITX)**2+FLOAT(ITY)**2)**.5/FLOAT(LENGTH)
C	  IF NUMBER OF ITERATIONS IS LESS THAN 1 JUST DRAW A SOLID LINE
	IF(TIMES.LT.1.) GOTO 50
C	  CALCULATE INCREMENT FOR DRAWN PORTION OF EACH DASH
	DX=FLOAT(IX)/TIMES
	DY=FLOAT(IY)/TIMES
	DDX=DX*FRAC
	DDY=DY*FRAC
C	  NOW CALCULATE THE UNDRAWN PORTION OF THE LINE
	SFRAC=SLEN/FLOAT(LENGTH)
	DBX=SFRAC*DX
	DBY=SFRAC*DY
	ITER=IFIX(TIMES)
	X=0
	Y=0
C	  NOW DO THE ACTUAL JOB OF PLOTTING EACH SEGMENT
	DO 320 I=1,ITER
	J=4*IFIX(DDX)+X
	JJ=4*IFIX(DDY)+Y
	CALL PLOT(J,JJ)
C	  PEN UP
	CALL OUTT(GS)
	CALL PLOT(4*IFIX(DBX),4*IFIX(DBY))
C	  DRAW A POINT
	CALL PLOT(0,0)
C	  PEN UP
	CALL OUTT(GS)
	CALL PLOT(4*IFIX(DBX),4*IFIX(DBY))
C	  ACCUMULATE ALL THE ROUND-OFF
	XSUM=XSUM+4.*(DDX-AINT(DDX)+2.*(DBX-AINT(DBX)))
	YSUM=YSUM+4.*(DDY-AINT(DDY)+2.*(DBY-AINT(DBY)))
	X=IFIX(XSUM)
	XSUM=XSUM-AINT(XSUM)
	Y=IFIX(YSUM)
	YSUM=YSUM-AINT(YSUM)
 320	CONTINUE
C	  FINISH REMAINDER OF LINE WITH A SOLID VECTOR
	ITX=(TIMES-FLOAT(ITER))*DX*4.+XSUM+FLOAT(X)
	ITY=(TIMES-FLOAT(ITER))*DY*4.+YSUM+FLOAT(Y)
	GOTO 50
	END



	SUBROUTINE BUFCHK(LEN)
	INTEGER IN(8)
C	  SUBROUTINE TO DETERMINE IF THERE IS SUFFICIENT ROOM IN THE
C	  PLOTTER BUFFER FOR (LEN) CHARACTERS. IF NOT, THEN THIS
C	  SUBROUTINE WAITS UNTIL SUFFICIENT ROOM IS AVAILABLE
C
C	  WRITTEN BY MICHAEL LAMPI    SPRING 1979
C
	DATA LASTLN/0/
	IF(LEN.GE.LASTLN) GOTO 100
C	  WE APPEAR TO HAVE ENOUGH ROOM - UPDATE COUNT & RETURN
 50	LASTLN=LASTLN-LEN
	RETURN
C
C	  ASK PLOTTER HOW MUCH ROOM IS LEFT
 100	CALL OUTT("33)
	CALL OUTT('A')
	CALL OUTT('O')
	CALL OUTT('1')
C	  TERMINATE WITH A 'SYNC' CHARACTER
	CALL OUTT("31)
C	  NOW READ THE STATUS WORD
 102	DO 120 I=1,8
 110	J=INPTT1(IDUMMY)
	IF(J.LT.0) GOTO 110
	J=J.AND."177
C	  CHECK FOR EXTRANNEOUS INPUT
	IF(I.NE.8.AND.J.EQ."15) GOTO 102
	IN(I)=J
 120	CONTINUE
C	  CHECK FOR STATUS INPUT
	IF((IN(7).AND."3).NE.2) GOTO 102
C	  NOW CALCULATE BUFFER SIZE
	LASTLN=(IN(7).AND."10)/"10 + (IN(6).AND."37)*2
     C	     + (IN(4).AND."37)*"100
C	  NOW CHECK IF THERE IS ROOM
	IF(LASTLN.GT.LEN) GOTO 50
C	  NOT ENOUGH ROOM - DELAY A WHILE
C
C
	WRITE(5,300)
300	FORMAT(' LOOPING...(THIS SHOULD NEVER OCCUR)')
	GOTO 100
	END




	SUBROUTINE GETGIN(IX,IY,ISPD,IERR)
C	SUBROUTINE TO RECEIVE DIGITIZING DATA FROM TEKTRONIX
C	4662 FLATBED PLOTTER AND CONVERT TO 10-BIT X & Y COORDINATES
C	WRITTEN 12-29-78 BY MICHAEL LAMPI
C
C	FORMAT OF INPUT AS FOLLOWS
C		HIGHEST X	0 1 # # # # #
C			Y	0 1 # # # # #
C		HIGH	X	0 1 # # # # #
C			Y	0 1 # # # # #
C		INTER	X	0 1 # # # # #
C			Y	0 1 # # # # #
C		LOWEST X & Y	1 0 X Y P D D
C	WHERE X AND Y ARE THE LEAST SIGNIFICANT BITS OF THE PEN ADDRESS
C	      P IS THE STATUS OF THE PEN (0 = UP, 1 = DOWN)
C	      DD IS THE DATA TYPE THAT CAUSED THE TRANSFER:
C		00 - GRAPHICS INPUT MODE (GIN)
C		01 - BLOCK ACKNOWLEDGE
C		10 - STATUS INPUT
C		11 - SIZE INPUT
C
	LOGICAL*1 BUFFER(8)
C
C	CHECK WHICH MODE OF INPUT REQUESTED - CONTINOUS OR ACCORDING TO
C	USE DEPRESSING 'CALL' BUTTON ON PLOTTER
	IF(ISPD.EQ.1) GOTO 3
C
C	CONTINOUS MODE DESIRED - SEND A 'GIN' COMMAND TO PLOTTER
	CALL OUTT("33)
	CALL OUTT('A')
	CALL OUTT('M')
C	GET INFORMATION FROM PLOTTER
3	DO 10 I=1,8
5	J=INPTT1(IDUMMY)
	IF(J.EQ.-1) GOTO 5
C	CHECK FOR INVALID INPUT
	IF((J.AND."100).AND.I.LT.7) GOTO 20
	BUFFER(I)=J
	IF(I.NE.7) BUFFER(I)=BUFFER(I).AND."37
10	CONTINUE
	J=BUFFER(7)
	IF((J.AND."100).NE.0.AND.(J.AND."3).EQ.0) GOTO 50
C	WRITE(5,15) BUFFER
C15	FORMAT(8(1X,O4))
C	INVALID INPUT RECEIVED - RETURN WITH ERROR STATUS SET
20	IERR=1
	RETURN
C
C	WE NOW HAVE A BUFFER OF INPUT - DECODE ADDRESS
C
50	IX=BUFFER(1)*32+BUFFER(3)
	IY=BUFFER(2)*32+BUFFER(4)
	IY=FLOAT(IY)*1024./682.
	IERR=0
	RETURN
	END
