/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	u_mape_seg.h,v $
 * Revision 1.1.2.2  92/06/19  11:01:53  Robert_Picco
 * 	Segmentation code
 * 	[92/06/18  21:08:07  Robert_Picco]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: u_mape_seg.h,v $ $Revision: 1.1.2.2 $ (DEC) $Date: 92/06/19 11:01:53 $
 */
#ifndef	__U_MAPE_SEG__
#define	__U_MAPE_SEG__ 1

struct vm_seg_object {
	struct vm_object
			sego_object;		/* Object common part */
	struct vm_seg_object
			*sego_cfl, *sego_cbl;	/* Cached queue */
	vm_offset_t	sego_segbase;		/* Virtual address base */
	struct pmap_seg	*sego_pmap;		/* Pmap seg id */
	short		sego_flags;		/* Flags */
	int		sego_nseg;		/* Number of segments */
	struct vm_seg	*sego_seglist;		/* Segments attached */
};

#define	sego_size	sego_object.ob_size
#define	sego_ref_count	sego_object.ob_ref_count
#define	sego_res_count	sego_object.ob_res_count

#define	OSEG_LLOCK	0x01			/* Lookup lock */
#define OSEG_LWANT	0x02			/* Want lookup lock */
#define	OSEG_FIXED	0x04			/* Mapped by a fixed request */
#define	OSEG_CACHED	0x08			/* On cached list */
#define	OSEG_ERROR	0x10			/* Release on error */

typedef	struct vm_seg_object *vm_seg_object_t;
#define	VM_SEG_OBJECT_NULL	(vm_seg_object_t) 0


enum seg_ret {SEG_CONFLICT, SEG_LOADED, SEG_EMPTY};

struct vm_seg {					/* Segments in the global obj */
	struct vm_seg	*seg_vnext;		/* vop segments */
	struct vm_seg	*seg_onext;		/* seg object segment on */
	struct vm_seg_object
			*seg_obj;		/* Segment object */
	vm_offset_t	seg_start;		/* Starting offset of seg */
	vm_offset_t	seg_size;		/* Size of this seg */
	struct vm_vp_object
			*seg_vop;		/* Object backing seg */
	vm_offset_t	seg_offset;		/* Offset into bobject */
	vm_prot_t	seg_prot;		/* Segment protection */
};

typedef struct vm_seg *vm_seg_t;
#define	VM_SEG_NULL	(vm_seg_t) 0

#endif	/* __U_MAPE_SEG__ */
