/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	shm.h,v $
 * Revision 4.2.4.5  92/04/21  10:11:10  Larry_Woodman
 * 	Initial debug changes.
 * 	[92/03/31  10:50:06  Larry_Woodman]
 * 
 * Revision 4.2.4.4  92/03/27  15:12:12  Craig_Horman
 * 	Merge with AG
 * 	[92/03/27  13:39:46  Craig_Horman]
 * 
 * 	Merge with BL5
 * 	[92/03/10  12:34:01  Craig_Horman]
 * 
 * 	Added C++ Support
 * 	[92/02/26  18:28:39  Craig_Horman]
 * 
 * Revision 4.2.4.3  92/02/26  15:49:22  Charles_Briggs
 * 	UBC merge
 * 	[92/02/23  16:01:33  Charles_Briggs]
 * 
 * 	UBC merge.
 * 	[92/02/22  14:13:35  Charles_Briggs]
 * 
 * Revision 4.2.4.2  92/01/16  15:31:30  William_Burns
 * 	Merge from ODE/TIN: revision 3.1.9.2
 * 	date: 92/01/14 10:59:34;  author: devrcs;  state: Exp;  lines added/del: 5/1
 * 	sccs rev: 3.2;  orig date: 92/01/01 09:57:06;  orig author: fred
 * 	Fred Canter - SVVS shmop fix QAR 2466.
 * 	[92/01/16  15:12:46  William_Burns]
 * 
 * Revision 4.2  91/09/19  23:00:05  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: shm.h,v $ $Revision: 4.2.4.5 $ (DEC) $Date: 92/04/21 10:11:10 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * RESTRICTED RIGHTS LEGEND
 * Use, Duplication or Disclosure by the Government is subject to
 * restrictions as set forth in paragraph (b)(3)(B) of the rights in
 * Technical Data and Computer Software clause in DAR 7-104.9(a).
 */ 
/*
 * OSF/1 Release 1.0
 */

/*
 * COMPONENT_NAME: (SYSIPC) IPC Shared Memory Facility
 *
 * FUNCTIONS:
 *
 * ORIGINS: 27 3
 *
 * (C) COPYRIGHT International Business Machines Corp. 1987, 1989
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 */

#ifndef _SYS_SHM_H_
#define _SYS_SHM_H_

#include <standards.h>
#include <sys/ipc.h>
#include <sys/types.h>
#include <mach/machine/vm_types.h>
#ifdef _KERNEL
#include <vm/vm_object.h>
#include <vm/vm_anon.h>
#endif

#ifdef _XOPEN_SOURCE

/*
 *	Implementation Constants.
 */

#ifdef _KERNEL
#define SHMLBA  PAGE_SIZE
#else
#define SHMLBA  getpagesize()
#endif  /* _KERNEL */
/*
 *	Operation Flags.
 */

#define	SHM_RDONLY	010000	/* attach read-only (else read-write) */
#define	SHM_RND		020000	/* round attach address to SHMLBA */

/*
 *	Structure Definitions.
 */

/*
 *      There is a shared mem id data structure for each shared memory
 *      and mapped file segment in the system.
 */

struct shmid_ds {
	struct ipc_perm	shm_perm;	/* operation permission struct */
	int		shm_segsz;	/* size of segment in bytes */
	u_short		shm_lpid;	/* pid of last shmop */
	u_short		shm_cpid;	/* pid of creator */
	u_short		shm_nattch;	/* current # attached */
	time_t		shm_atime;	/* last shmat time */
	time_t		shm_dtime;	/* last shmdt time */
	time_t		shm_ctime;	/* last change time */
};

#ifdef _KERNEL
struct shmid_internal {
	struct shmid_ds	s;		/* shared mem id data structure */
	struct vm_shm_object *shm_object;	/* Our object */
};
#endif /* _KERNEL */

#ifndef _KERNEL
#ifdef _NO_PROTO
extern caddr_t	shmat();
extern int	shmdt();
extern int	shmctl();
#else
#if defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C"
{
#endif
extern caddr_t	shmat(int, caddr_t, int);
extern int 	shmdt(caddr_t);
extern int 	shmctl(int, int, struct shmid_ds *);
#if defined(__cplusplus)
}
#endif
#endif
#endif /* _NO_PROTO */
#endif /* _KERNEL */

#endif /* _XOPEN_SOURCE */

#ifdef _OSF_SOURCE

/*
 *	ipc_perm Mode Definitions.
 */
#define	SHM_R		IPC_R	/* read permission */
#define	SHM_W		IPC_W	/* write permission */

#ifdef _KERNEL
struct	shminfo {
	int	shmmax,		/* max shared memory segment size */
		shmmin,		/* min shared memory segment size */
		shmmni,		/* number of shared memory identifiers */
		shmseg;		/* max attached shared memory segments per process */
};
#endif /* _KERNEL */

#endif /* _OSF_SOURCE */


#if defined(__cplusplus)
extern struct shmid_internal *shmem;
#else
extern struct shmid_internal shmem[];
#endif
extern struct shminfo shminfo;

#endif /* _SYS_SHM_H_ */




