/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	fault.h,v $
 * Revision 1.1.2.3  92/06/02  13:00:04  David_Scoda
 * 	"/proc update, speedup, 64 bit, memory usage"
 * 
 * Revision 1.1.3.3  92/06/02  07:56:34  David_Scoda
 * 	<<<bci after bmerge>>>
 * 
 * Revision 1.1.3.2  92/06/02  07:53:16  David_Scoda
 * 	<<<add defines for Alpha>>>
 * 
 * Revision 1.1.2.2  92/03/25  13:48:50  David_Scoda
 * 	"BL6 /proc fixes"
 * 
 * Revision 1.1.1.3  92/03/25  12:57:21  David_Scoda
 * 	bci after bmerge for /proc changes
 * 
 * Revision 1.1.1.2  92/03/24  12:50:38  David_Scoda
 * 	<<<new header file for /proc support>>>
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: fault.h,v $ $Revision: 1.1.2.3 $ (DEC) $Date: 92/06/02 13:00:04 $
 */

/*
 * This header file defines the /proc fault tracing nmemonics in terms of
 * EXC_ defines (from <machine/cpu.h> for the mips acrhitecture).
 */

#ifndef	_SYS_FAULT_H_
#define	_SYS_FAULT_H_

#ifdef mips

#include	<machine/cpu.h>

#define	FLTILL		(EXC_II)		/* illegal instruction */
#define	FLTBPT		(EXC_BREAK)		/* breakpoint */
#define	FLTIOVF		(EXC_OV)		/* overflow */
#define	FLTIZDIV	(EXC_BREAK)		/* n/0 handled via breakpoint*/
#define	FLTPAGE		(EXC_RMISS | EXC_WMISS)	/* read or write TLB miss */

/* #define	FLTPRIV		not supported by MIPS architecture */
/* #define	FLTTRACE	not supported by MIPS architecture */
/* #define	FLTACCESS	not supported by MIPS architecture */
/* #define	FLTBOUNDS	not supported by MIPS architecture */
/* #define	FLTFPE		not supported by MIPS architecture */
/* #define	FLTSTACK	not supported by MIPS architecture */

#endif /* mips */

#ifdef __alpha

#include	<machine/trap.h>

#define	FLTIOVF		T_ARITH
#define	FLTIZDIV	T_ARITH
#define	FLTILL		T_IFAULT
#define	FLTBPT		T_IFAULT
#define	FLTPAGE		T_MMANG

#endif /* __alpha */

#endif	/* _SYS_FAULT_H_ */
