/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	exec_incl.h,v $
 * Revision 4.2.2.2  92/02/26  15:48:43  Charles_Briggs
 * 	UBC merge
 * 	[92/02/23  16:00:27  Charles_Briggs]
 * 
 * 	UBC merge.
 * 	[92/02/22  14:17:44  Charles_Briggs]
 * 
 * Revision 4.2  91/09/19  23:03:59  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: exec_incl.h,v $ $Revision: 4.2.2.2 $ (DEC) $Date: 92/02/26 15:48:43 $
 */ 
/*
 *
 * 28-Feb-1991, Ken Lesniak
 *	Add support for ELF executables and shared libraries
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/* 
 * OSF/1 Release 1.0
 */
/*
 * This file contains common definitions and include files used by
 *  both kern_exec.c and ldr_exec.c
 */

#include <cputypes.h>
#include <bsd_a_out.h>
#include <sysv_coff.h>
#include <sysv_elf.h>
#include <osf_mach_o.h>

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/map.h>
#include <sys/user.h>
#include <sys/kernel.h>
#include <sys/proc.h>
#include <sys/mount.h>
#include <sys/ucred.h>
#include <sys/buf.h>
#include <sys/vnode.h>
#include <sys/mman.h>
#include <sys/vm.h>
#include <sys/file.h>
#include <sys/uio.h>
#include <sys/acct.h>
#include <sys/exec.h>

#include <machine/reg.h>
#if	defined(vax) || defined(i386)
#include <machine/psl.h>
#endif

#if	SYSV_ELF
/*
 * File headers for ELF files.
 */
#include <sysV/elf_abi.h>
#ifdef mips
#include <sysV/elf_mips.h>
#endif
#endif

#if	SYSV_COFF
/*
 *	Fileheaders for coff files.
 */
#ifdef __hp_osf
/* On HP, get coff header files copied from usr/include/<machine> source rather than
   those in the kernel/sysv source.  This is probably what needs to be done
   for the other platforms as well (right now, mips has 2 versions of each
   header - in usr/include/<machine> and in kernel/sysv).  The makefile at
   kernel/include/Makefile does the copying of these (and other) headers. */
#include <scnhdr.h>
#include <aouthdr.h>
#include <filehdr.h>
#else
#include <sysV/scnhdr.h>
#include <sysV/aouthdr.h>
#include <sysV/filehdr.h>
#endif /* hp_osf */
#endif

#if	OSF_MACH_O
/*
 *	header files for processing OSF/mach-o.
 */
#include <mach_o_header.h>
#include <mach_o_format.h>
#include <kern/kalloc.h>
#endif

#ifdef	mips
#include <sys/ptrace.h>
#endif


/*
 *  Force all namei() calls to permit remote names since this module has
 *  been updated.
 */
#if	MACH_RFS
#undef	namei
#define namei	rnamei
#endif

#ifdef	ibmrt
#include <ca/debug.h>
#endif

#ifdef	sun4
#include <sun4/asm_linkage.h>
#endif

#include <sys/signal.h>
#include <kern/task.h>
#include <kern/thread.h>

#include <mach/vm_param.h>
#include <vm/vm_map.h>
#include <vm/vm_kern.h>
#include <vm/vm_user.h>
#include <kern/zalloc.h>

#include <kern/parallel.h>



#if	BSD_A_OUT
/*
 * All of these silly loader_page_size's should be moved into a machine
 * dependent directory, for obvious reasons.  -BB
 */
#ifdef	vax
#define LOADER_PAGE_SIZE	(1024)
#endif
#if	defined(ibmrt) || defined(balance)
#define LOADER_PAGE_SIZE	(2048)
#endif
#ifdef	sun
#define LOADER_PAGE_SIZE	(8192)
#endif
#ifdef	__hp_osf
/* warning, this may be changed to 4096 at a later date */
#define LOADER_PAGE_SIZE	(8192)
#endif
#ifdef	i386
#define	LOADER_PAGE_SIZE	(4096)
#endif
#endif	/* BSD_A_OUT */

#if	SYSV_COFF
/*
 *	Corresponding definitions are in coff_getxfile because the
 *	section size (SECTALIGN, corresponds to LOADER_PAGE_SIZE)
 *	must be obtained from the file header for some architectures.
 */

#ifdef	LOADER_PAGE_SIZE
#define SECTALIGN		LOADER_PAGE_SIZE
#else
#define LOADER_PAGE_SIZE	SECTALIGN
#endif
#endif

#define loader_round_page(x)	((vm_offset_t)((((vm_offset_t)(x)) \
						+ LOADER_PAGE_SIZE - 1) \
					& ~(LOADER_PAGE_SIZE-1)))
#define loader_trunc_page(x)	((vm_offset_t)(((vm_offset_t)(x)) \
					& ~(LOADER_PAGE_SIZE-1)))


/*
 *	A corrupted fileheader can cause getxfile to decide to bail
 *	out without setting up the address space correctly.  It is
 *	essential in this case that control never get back to the
 *	user.  The following error code is used by getxfile to tell
 *	execve that the process must be killed.
 */

#define EGETXFILE	126
