/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	task_swap.h,v $
 * Revision 1.1.2.3  92/05/20  09:37:37  Larry_Woodman
 * 	Add task swapout macros.
 * 	[92/05/08  14:39:24  Larry_Woodman]
 * 
 * Revision 1.1.2.2  92/02/26  15:39:55  Charles_Briggs
 * 	UBC merge.
 * 	[92/02/21  16:46:17  Charles_Briggs]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: task_swap.h,v $ $Revision: 1.1.2.3 $ (DEC) $Date: 92/05/20 09:37:37 $
 */
/*	
 *	@(#)task_swap.h	3.2	(ULTRIX/OSF)	11/20/91
 */ 
/*
 * @DIGITAL_COPYRIGHT@
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/*
 *	File:   kern/task_swap.h
 *	Declarations of thread swap_states and swapping routines.
 */

/*
 *	Swap states for threads.
 */

#ifndef	_KERN_TASK_SWAP_H_
#define _KERN_TASK_SWAP_H_
/*
 *	exported queues
 */
extern	queue_head_t	task_inswapped_queue;	/* queue of resident tasks */
extern	queue_head_t    task_outswapped_queue;	/* queue of swapped tasks */
extern	queue_head_t    task_inswap_work_queue; /* queue of incomming tasks */
extern	queue_head_t    task_outswap_work_queue;/* queue of outgoing tasks */
/*
 *	exported locks
 */
extern	simple_lock_data_t	task_inswapped_queue_lock;
extern  simple_lock_data_t	task_outswapped_queue_lock;
extern  simple_lock_data_t	task_inswap_work_queue_lock;
extern  simple_lock_data_t	task_outswap_work_queue_lock;
/*
 *	exported counts
 */
extern	int	task_inswapped_queue_count;
extern  int	task_outswapped_queue_count;
extern	int	task_inswap_work_queue_count;
extern	int	task_outswap_work_queue_count;
/*
 *	exported misc.
 */
extern  int     task_swap_work;

#define	EXCESSIVE_FAULTRATE(task_fault_rate, average_fault_rate)	\
		(task_fault_rate > average_fault_rate)

#define THREAD_TASK_SWAPPABLE(time_sleeping)	\
		(sched_tick - time_sleeping > 2)

#define THREAD_LONGTIME_SLEEPER(time_sleeping)    \
		(sched_tick - time_sleeping > 30)

#endif  /* _KERN_TASK_SWAP_H_ */
