/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	bt463.h,v $
 * Revision 1.1.3.3  92/02/27  18:04:42  Barbara_Corriero
 * 	Merge with 4.L, there are 512 colorcells instead of 256
 * 	[92/02/24  16:40:23  Barbara_Corriero]
 * 
 * Revision 1.1.3.2  91/11/20  14:07:31  Hal_Project
 * 	Moved from dec/io/...; pool reorg
 * 	[91/11/18  08:56:54  Donald_Dutile]
 * 
 * Revision 4.2  91/09/19  23:22:23  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: bt463.h,v $ $Revision: 1.1.3.3 $ (DEC) $Date: 92/02/27 18:04:42 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

/*	Modification history:
 *
 *	Created based on bt459.h
 *		Andy Goodrich
 *		December 1990
 */

#ifndef bt463_DEFINED
#define bt463_DEFINED 1

/*
 *	Layout of hardware when viewed from Turbo Bus:
 */
struct bt463 {
    volatile char addr_low;
    char pad1[3];
    volatile char addr_high;
    char pad2[3];
    volatile char bt_reg;
    char pad3[3];
    volatile char color_map;
    char pad4[3];
};

/*
 * The reason a different color cell representation is used is
 * to reduce kernel memory usage.  This form is sufficient for
 * an 256 entry color map, and saves 8 bytes/cell, or 2k bytes/screen.
 */
typedef struct bt463_color_cell {
	unsigned char dirty_cell;
	unsigned char red;	/* only need 8 bits */
	unsigned char green;
	unsigned char blue;
} Bt463_Color_Cell;

typedef struct bt463_wid_cell {
	unsigned char low_byte;		/* Low order 8 bits of wid P0-P7. */
	unsigned char middle_byte;	/* Middle 8 bits of wid P8-P15. */
	unsigned char high_byte;	/* High order 8 bits of wid P0-P7. */
	unsigned char unused;
} Bt463_Wid_Cell;

/*
 *	Closure information for Brooktree 463 RAMDAC
 */
struct bt463info {
        volatile struct bt463  *btaddr;	/* hardware location in virt. mem. */
	char 		screen_on;	/* whether screen is on */
	char 		dirty_colormap;	/* has cmap been reloaded?*/
	char 		dirty_cursormap; /* has curs map been reloaded?*/
	short 		fb_xoffset;	/* offset to video */
	short 		fb_yoffset;	/* ... */
	void    (*enable_interrupt)();	/* enables one interrupt at V.R. */
	caddr_t		cursor_closure;	/* hack hook into cursor code */
	ws_color_cell    saved_entry;
	ws_color_cell    cursor_fg;	/* current cursor foreground color. */
	ws_color_cell    cursor_bg;	/* current cursor background color. */
	short 	  min_dirty;/* range of dirty entries needing updating. */
	short	  max_dirty;				/* ... */	
	Bt463_Color_Cell cells[512];
};


#define CURSOR_COLOR0           0x0100
#define CURSOR_COLOR1           0x0101
#define BT463_ID_REG                  0x0200
#define COMMAND_REG_0           0x0201
#define COMMAND_REG_1           0x0202
#define COMMAND_REG_2           0x0203

#define P0_P7_READ_MASK         0x0205
#define P8_P15_READ_MASK        0x0206
#define P16_P23_READ_MASK       0x0207
#define P24_P27_READ_MASK       0x0208

#define P0_P7_BLINK_MASK        0x0209
#define P8_P15_BLINK_MASK       0x020a
#define P16_P23_BLINK_MASK      0x020b
#define P24_P27_BLINK_MASK      0x020c

#define BT463_TEST_REG                0x020d

#define INPUT_SIGNATURE         0x20E
#define OUTPUT_SIGNATURE        0x20F

#define REVISION_REG            0x0220


/*
 *    Window Type Field Definitions:
 */
#define SET_WT_SHIFT( x ) ( ((x) & 0x1f) )
#define SET_WT_PLANES(x)  ( ((x) & 0x0f) <<  5 )
#define SET_WT_MODE(x)    ( ((x) & 0x07) >>  9 )
#define SET_WT_OVERLAY(x) ( ((x) & 0x01) << 12 )
#define SET_WT_OV_MASK(x) ( ((x) & 0x0f) << 13 )
#define SET_WT_LUT_ADDR(x)( ((x) & 0x3f) << 17 )
#define SET_WT_BYPASS(x)  ( ((x) & 0x01) << 23 )

#define WT_VALUE(shift, planes, mode, overlay, ov_mask, lut_addr, bypass) \
	(SET_WT_SHIFT(shift) | SET_WT_PLANES(planes) | SET_WT_MODE(mode) \
	| SET_WT_OVERLAY(overlay) | SET_WT_OV_MASK(ov_mask) | SET_WT_LUT_ADDR(lut_addr) \
	| SET_WT_BYPASS(bypass) )

#define GET_WT_SHIFT( x ) ( (x & 0x00001f) )
#define GET_WT_PLANES(x)  ( (x & 0x0001e0) >>  5 )
#define GET_WT_MODE(x)    ( (x & 0x000e00) >>  9 )
#define GET_WT_OVERLAY(x) ( (x & 0x001000) >> 12 )
#define GET_WT_OV_MASK(x) ( (x & 0x01e000) >> 13 )
#define GET_WT_LUT_ADDR(x)( (x & 0x7e0000) >> 17 )
#define GET_WT_BYPASS(x)  ( (x & 0x800000) >> 23 )

/*####*/

#define LUT_BASE_24 0x100  /* Base offset into lut of true color colormap. */
#define LUT_BASE_8  0x000 /* Base offset into lut of eight bit colormap. */

#define ADDR_LOW_MASK 0x00ff /* Mask to obtain bits for 'addr_low' register. */
#define ADDR_HIGH_MASK	0xff00 /* Mask to obtain bits for 'addr_high' reg. */

int bt463_init_color_map();
int bt463_load_color_map_entry();
int bt463_video_on();
int bt463_video_off();
void bt463_clean_colormap();

extern struct bt463info bt463_softc[];

#endif /* !bt463_DEFINED */
