/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	inode_pager.h,v $
 * Revision 4.2  91/09/19  22:06:17  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: inode_pager.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/19 22:06:17 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * OSF/1 Release 1.0
 */

#ifndef	_BUILTIN_INODE_PAGER_H_
#define _BUILTIN_INODE_PAGER_H_

#include <mach/kern_return.h>

#define MS_NONE		0x0000
#define MS_PREFER	0x0001		/* Prefer this file. */
/*
 * Number of pages of vnode_pager address space allocated per
 * vnode_pager thread
 */
#define VNODE_PAGER_ALLOC	10

/*
 * Miscellaneous pager stats that can be returned per swap device.
 */
#define PNAMELEN 90
struct pager_stat {
	long		ps_npgs;	/* Size of file in pages.	     */
	long		ps_pfree;	/* Number of unused pages.	     */
	long		ps_lowat;	/* Low water page.		     */
	boolean_t	ps_prefer;	/* Is this a prefered paging file?   */
	char		ps_name[PNAMELEN];	/* Filename of this file.	     */
};

#ifdef	_KERNEL
#include <mach_xp.h>

#include <mach/boolean.h>
#include <mach/memory_object.h>

extern void		vnode_pager_bootstrap();

extern memory_object_t	inode_pager_setup();
extern void		inode_pager_release();
extern void		vnode_uncache();
extern boolean_t	vnode_uncache_try();

#include <kern/lock.h>

decl_simple_lock_data(extern,inode_pager_init_lock)

extern void		vnode_pager();

#endif	/* _KERNEL */
#endif	/* _BUILTIN_INODE_PAGER_H_ */
