/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	hal_sysinfo.h,v $
 * Revision 1.1.2.5  92/05/05  12:35:45  Peter_Keilty
 * 	merged with ag.latest
 * 	[92/05/04  17:00:58  Peter_Keilty]
 * 
 * 	Merge with pre.bl6
 * 	[92/04/04  09:49:52  Peter_Keilty]
 * 
 * 	Added GSI_SCS_SYSID 38 for CI
 * 	[92/03/26  14:53:08  Peter_Keilty]
 * 
 * Revision 1.1.2.4  92/03/26  22:57:45  Joel_Gringorten
 * 	Added def for GSI_GRAPHICTYPE
 * 	[92/03/26  22:55:32  Joel_Gringorten]
 * 
 * Revision 1.1.2.3  92/03/12  12:39:46  Timothy_Burke
 * 	Added get/setsysinfo calls needed for loadable drivers.  They are used to
 * 	pass "config" information and to store driver method state.
 * 	[92/03/04  09:16:21  Timothy_Burke]
 * 
 * 	Moved from dec/machine/mips; pool reorg.
 * 	[91/11/18  00:10:19  Donald_Dutile]
 * 
 * Revision 1.1.2.2  92/01/22  14:55:42  Dave_Gerson
 * 	Extra header removed.
 * 	[92/01/21  15:22:32  Dave_Gerson]
 * 
 * 	Created this file for HAL layer as reqd by SWOE-HAL partitioning of
 * 	{get,set}sysinfo().  Macros moved to this file from mips/sysinfo.h
 * 	pertain to system dependant commands.
 * 	[92/01/21  13:43:20  Dave_Gerson]
 * 
 * Revision 4.2.2.2  91/11/05  10:32:13  William_Burns
 * 	Merge from ODE/TIN: revision 3.3.9.2
 * 	date: 91/10/24 16:15:09;  author: devrcs;  state: Exp;  lines added/del: 2/1
 * 	sccs rev: 3.4;  orig date: 91/10/10 10:15:53;  orig author: burns
 * 	Add setsysinfo call to allow setting the dumpdev. Used by swapon.
 * 	[91/10/28  10:34:51  William_Burns]
 * 
 * Revision 4.2  91/09/19  23:16:31  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: hal_sysinfo.h,v $ $Revision: 1.1.2.5 $ (DEC) $Date: 92/05/05 12:35:45 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */

/*
 *
 *   Modification history:
 *
 * 05 Jun 91 -- map for pcameron (Phil Cameron)
 *	Define unsupported ops from ULTRIX is ULT_BIN_COMPAT
 *	is defined.
 *
 * 31 May 91 -- map
 *	Ported to OSF.
 *
 *  9 Mar 88 -- chet
 *	Created this file.
 *
 */

/*
 *	This file contains constants used with the hal_getsysinfo() and
 *	hal_setsysinfo() system calls.
 *
 *	Both of these calls are operation driven; particular
 *	flavors of operation may use arguments, identifiers, flags, etc.
 *	to define the actual result.
 *
 */

/***************************************************************************
 ***************************************************************************
 **  WARNING, HAZARD, WATCH OUT, NOTICE!!!!!!!!!!!!!!
 **
 ** Whenever adding a new GSI or SSI number look in both <hal/hal_sysinfo.h>
 ** and <sys/sysinfo.h> to make sure that the function numbers remain unique!
 ** The defines for GSI/SSI appear in these two header files and can not
 ** overlap, otherwise the hal variant would never be called!
 **
 ***************************************************************************
 ***************************************************************************/

#ifndef _HAL_SYSINFO_H_
#define _HAL_SYSINFO_H_

/*
 *	hal_getsysinfo() operation types
 */

#define GSI_NETBLK	4	/* Return the entire netblk structure */
				/* which is used for network install */
#if ULT_BIN_COMPAT
#define GSI_WSD_TYPE    10      /* Workstation Display Type Info */

#define GSI_WSD_UNITS   11      /* Workstation Display Units Info */

#endif /* ULT_BIN_COMPAT */

#define	GSI_BOOTCTLR	21	/* Logical Controller # for TURBOchannel slot */

#define	GSI_CONSTYPE	22	/* MIPS console type identifier */


/* All values from 1 - 22 are reserved. This is for compatibility */
/* with ULTRIX							  */

#define GSI_BUS_STRUCT  23     /* get bus structure */
#define GSI_BUS_NAME    24     /* get name of bus */

#define GSI_CTLR_STRUCT 25     /* get controller structure */
#define GSI_CTLR_NAME   26     /* get name of controller */

#define GSI_DEV_STRUCT  27     /* get device structure */
#define GSI_DEV_NAME    28     /* get name of device */

#define	GSI_CPU		29	/* cpu type (from cpu global variable) */
#define GSI_MAX_CPU     30     /* max # cpu's on this machine */

#define GSI_PRESTO      34     /* size of non-volatile ram if installed */

#if     ULT_BIN_COMPAT

#define GSI_GRAPHICTYPE 36      /* Graphics module names */

#endif  /* ULT_BIN_COMPAT */

#define GSI_SCS_SYSID	38     /* scs_sysid for ci */
#define GSI_BUS_PNAME   39     /* get port name of bus */
#define GSI_CTLR_PNAME  40     /* get port name of controller */

#define GSI_DEV_MOD	100     /* return dev_mod struct - loadable drivers */

/*
 *      setsysinfo() SSI_NVPAIRS variable names
 */

/* All values from 1 - 8 are reserved for compatibility with ULTRIX */
#define SSIN_LOAD_CONFIG 100	/* Add a new loadable driver config struct */
#define SSIN_DEL_CONFIG 101	/* Delete all driver config structs        */
#define SSIN_LOAD_DEVSTATE 102	/* Add device method state	           */
#define SSIN_UNLOAD_DEVSTATE 103 /* Delete device method state	           */

#endif /* _HAL_SYSINFO_H_ */







