/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	fixpoint.h,v $
 * Revision 1.1.3.2  91/11/20  13:32:55  Hal_Project
 * 	Moved from dec/machine/mips; pool reorg.
 * 	[91/11/18  00:05:43  Donald_Dutile]
 * 
 * Revision 4.2  91/09/19  23:10:58  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: fixpoint.h,v $ $Revision: 1.1.3.2 $ (DEC) $Date: 91/11/20 13:32:55 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/* 
 * derived from fixpoint.h	2.1	(ULTRIX/OSF)	12/3/90
 */

/*		2.1	fixpoint.h	*/

/*
 * Copyright 1985 by MIPS Computer Systems, Inc.
 */

/*
 * Fix-point arithmetic package
 */

/*
 * Basic fix-point types
 */
/*
 * TODO: should probably move this over to types.h so that avenrun is
 * not defined in vm_sched.c
 */
typedef	int 		fix;
typedef	unsigned int	ufix;

/*
 * Number of fraction bits.
 */
#define FBITS		8

/*
 * Conversion to fix-point representation
 * works with int, float, double, char, ....
 */
#define	TO_FIX(x)	((fix)((x)*(1<<FBITS)))

/*
 * Conversion from fix-point to various integer datatypes
 */
#define	FIX_TO_SHORT(x)		((short)((x)>>FBITS))
#define	FIX_TO_INT(x)		((int)((x)>>FBITS))

/*
 * Conversion from fix-point to double
 */
#define	FIX_TO_DBL(x)	(((double)(x))/(1<<FBITS))

/*
 * Multiplication/division of 2 fix-point values
 */
#define	MUL_2FIX(x, y)	(((x)*(y))>>FBITS)
#define	DIV_2FIX(x, y)	(((x)<<FBITS)/(y))
