/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	dcedfs_data.c,v $
 * Revision 1.1.2.2  92/02/26  15:35:31  Charles_Briggs
 * 	DCE merge.
 * 	[92/02/22  13:34:26  Charles_Briggs]
 * 
 * $EndLog$
 */
#ifndef lint
static char *rcsid = "@(#)$RCSfile: dcedfs_data.c,v $ $Revision: 1.1.2.2 $ (DEC) $Date: 92/02/26 15:35:31 $";
#endif


/*
 * Stub routines to support DFS as a layered product
 * options DFS is enabled in BINARY to accommodate 
 * future configurability of DFS;  these stubs are 
 * DEFINED ONLY WHEN THE DCE DFS LAYERED PRODUCT IS NOT CONFIGURED
 */

#ifndef	DCEDFS

#include <sys/secdefines.h>
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/time.h>
#include <sys/kernel.h>
#include <sys/namei.h>
#include <sys/uio.h>
#include <sys/vnode.h>
#include <sys/specdev.h>
#include <sys/mount.h>
#include <sys/buf.h>
#include <sys/biostats.h>
#include <sys/ucred.h>

int
dfs_readop (vp, uio, ioflg, cred) 
     struct vnode *vp;
     struct uio   *uio;
     int          ioflg;
     struct ucred cred;
{
     register int error;

     VOP_READ (vp, uio, ioflg, cred, error);
     return (error);
}

int
dfs_writeop (vp, uio, ioflg, cred) 
     struct vnode *vp;
     struct uio   *uio;
     int          ioflg;
     struct ucred cred;
{
     register int error;

     VOP_WRITE (vp, uio, ioflg, cred, error);
     return (error);
}

int
afs_syscall (syscall, parm1, parm2, parm3, parm4, parm5)
     long syscall;
     long parm1;
     long parm2;
     long parm3;
     long parm4;
     long parm5;
{
     return (1);
}

/*
 * DFS Extended Ioctl system call (stub)
 */
int
dfs_xioctl(p, args, retval)
     struct proc *p;
     void *args;
     int *retval;
{
     return (ioctl_base (p, args, retval));
}

/*
 * DFS Extended Setgroups call (stub)
 */
int
dfs_xsetgroups(p, args, retval)
     register struct proc *p;
     void *args;
     int *retval;
{
     return (setgroups_base (p, args, retval));
}

#endif /* DCEDFS */


int
dfs_xxdebug ()
{
	return (1);
}













