/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	cm_data.c,v $
 * Revision 1.1.2.3  92/03/27  19:08:09  Peter_Lega
 * 	"Integrated svid3, svr4, soe2 habita
 * 	ts into base"
 * 
 * Revision 1.1.4.6  92/03/27  14:56:27  Peter_Lega
 * 	final before submit
 * 
 * Revision 1.1.4.5  92/03/26  21:47:54  Peter_Lega
 * 	more changes
 * 
 * Revision 1.1.4.3  92/03/25  20:15:23  Peter_Lega
 * 	removed SVID2
 * 
 * Revision 1.1.4.2  92/03/25  15:56:44  Peter_Lega
 * 	Debugged code
 * 
 * Revision 1.1.3.3  92/03/17  20:19:34  Philip_Cameron
 * 	Add list of valid modules/habitats and revisions
 * 
 * Revision 1.1.3.2  92/03/17  19:40:10  Philip_Cameron
 * 	Added support for svid2, svid3, svr4, and soe2 habitats.
 * 
 * Revision 1.1.2.2  92/03/09  08:22:25  Philip_Cameron
 * 	Use the GENERIC file to control this file.
 * 	[92/03/09  07:50:16  Philip_Cameron]
 * 
 * 	Added bin_compat_debug and bin_compat_trace from conf/param.c
 * 	[92/02/06  07:56:57  Philip_Cameron]
 * 
 * 	Created file.
 * 	[92/02/05  08:44:02  Philip_Cameron]
 * 
 * $EndLog$
 */
#ifndef lint
static char *rcsid = "@(#)$RCSfile: cm_data.c,v $ $Revision: 1.1.2.3 $ (DEC) $Date: 92/03/27 19:08:09 $";
#endif

/*
 * This is a list of the compatability and habitat modules that
 * may be statically linked into the kernel. 
 */

#include <sys/systm.h>
#include <sys/habitat.h>
#include "ult_bin.h"
#include "sysv_hab.h"
#include "svid_three_hab.h"
#include "svr_four_hab.h"
#include "soe_two_hab.h"


#if NULT_BIN
extern void ult_cfg_static();
#endif
#if NSYSV_HAB
extern void sysv_cfg_static();
#endif
#if NSVID_THREE_HAB
extern void svid_three_cfg_static();
#endif
#if NSVR_FOUR_HAB
extern void svr_four_cfg_static();
#endif
#if NSOE_TWO_HAB
extern void soe_two_cfg_static();
#endif
extern void rt_cfg_static();


void (* cm_static[MAXSTATICMODS])() = {

#if NULT_BIN
	ult_cfg_static,
#endif
#if NSYSV_HAB
	sysv_cfg_static,
#endif
#if NSVID_THREE_HAB
	svid_three_cfg_static,
#endif
#if NSVR_FOUR_HAB
	svr_four_cfg_static,
#endif
#if NSOE_TWO_HAB
	soe_two_cfg_static,
#endif
	/* real-time is always static */
	rt_cfg_static,
	0,
};



/*
 * List of valid modules/habitats and revisions
 *	Add to the list as the need arises
 */
struct cm_valid cm_valid[] = {
	ULTBIN,		ULT42V11,	/* Ultrix 4.2 compat module	*/
	SYSV_HAB, 	SYSVV11,	/* System V habitat		*/
	SVID3_HAB,	SVID3V11,	/* Svid 3 habitat		*/
	SVR4_HAB,	SVR4V11,	/* Svr 4 habitat		*/
	SOE2_HAB,	SOE2V11,	/* Soe 2 habitat		*/
	RT_HAB,		RTV11,		/* Real-time habitat		*/
	   0,	  	   0
};



/*
 * Compatability module support.
 * 	Control diagnostics
 */
int bin_compat_debug 	= 0;
int bin_compat_trace	= 0;

