/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	autoconf_data.c,v $
 * Revision 1.1.3.4  92/02/24  11:42:16  Peter_Keilty
 * 	bmerge against ag.latest
 * 	[92/02/23  13:32:16  Peter_Keilty]
 * 
 * 	Remove msiintv and ciintv defines and ciintr()
 * 	[92/02/22  12:19:01  Peter_Keilty]
 * 
 * 	Code cleanup and merge of AG.latest
 * 	[92/02/18  15:58:38  Peter_Keilty]
 * 
 * 	Initial checkin of DSA IO subsystem and
 * 	related system files
 * 	[92/02/12  18:35:02  Peter_Keilty]
 * 
 * Revision 1.1.3.3  91/12/18  21:41:26  William_Burns
 * 	date: 91/11/14 15:51:11;  author: devrcs;  state: Exp;  lines added/del: 3/3
 * 	sccs rev: 3.3;  orig date: 91/11/05 15:10:27;  orig author: burns
 * 	Cleaned up comments.
 * 	[91/12/18  10:31:36  William_Burns]
 * 
 * Revision 1.1.3.2  91/11/20  13:51:41  Hal_Project
 * 	Moved from dec/data; pool reorg
 * 	[91/11/18  00:44:18  Donald_Dutile]
 * 
 * Revision 4.2  91/09/19  23:23:51  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: autoconf_data.c,v $ $Revision: 1.1.3.4 $ (DEC) $Date: 92/02/24 11:42:16 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * OSF/1 Release 1.0
 */
/* 
 * derived from autoconf_data.c	2.13	(ULTRIX)	12/28/89
 */
/************************************************************************
 *
 *			Modification History
 *
 * 28-Dec-89 Robin
 *	Added nNKDM nNKLESIB nNMBA so unifind can know if the bus is there
 *	when its called.  If unifind is called now and no devices are
 *	configed on the bus (no bus) then the system crashes.
 *
 * 14-Oct_89 Robin
 *	The cpu.h include needs the types.h include before its used.
 *	This include of types.h should be in cpu.h but I seem to
 *	remember a "rule (?)" about no nested includes to help
 *	make depend run, so I'll put it here.  XXX
 *
 * 13-Oct-1989 gmm
 *	Moved the include location of cpu.h before cpudata.h. Needed for
 *	MIPS smp support
 *
 * 08-June-1989	Robin
 *	added a stub routine for uqdriver so that it would be
 *	defined if nothing causes the uqdriver to be in the system.  This
 *	is needed in machdep gendump routine to allow dumps on Q-bus
 *	devices.  Also added #if on uba_hd structure declaration to make
 *	it a size of one if all the uba devices evaluste to zero.  It
 *	was causing a complie warning on array uba_hd[0,0,0]; no wonder!
 *
 * 20-Jul-89	rafiey (Ali Rafieymehr)
 *	included two stub routines (xmisst(), and get_xmi()).
 *
 * 20-Jul-1989  map (Mark A. Parenti)
 *	Include number of KDM70's when sizing uba structures.
 *
 * 24-May-1989	darrell
 *	changed the #include to find cpuconf.h in it's new location -- 
 *	sys/machine/common/cpuconf.h
 *
 * 24-Mar-1989  Pete Keilty
 * 	Added msi interrupt routine for mips.
 *
 * 21-Mar-1989  Pete Keilty
 *	Added ci interrupt routines for mips. Also added ifdef vax
 * 	around mba.h
 *
 * 30-jan-1989	jaw
 * 	cleanup of SMP per-cpu data.
 *
 * 09-Dec-1988	Todd M. Katz			TMK0002
 *	1. Changed MSI defines completely:
 *		1) The variable nummsi is always defined and declared.
 *		2) Dummy routines are never defined( their definitions have
 *	   	   been moved to conf.c for consistentcy ).
 *		3) Define and declare nNMSI, msi_adapt[], and msiintv[] only
 *		   when local MSI ports have been configured.
 *	2. Currently only one CI port is supported.  Change ciintv[] to reflect
 *	   this and rename the appropriate locore interrupt service routine
 *	   from Xcia0int() -> Xci0int().
 *
 * 20-Apr-1988  Ricky Palmer
 *	Added an omitted dummy "msiintr" routine to MSI defines.
 *
 * 24-Mar-1988	Robin
 *	Added code to protect locore from causing undefines in processors that
 *	do not config in the NI or MSI drivers.  Locore calls the interupt
 *	routines and if they are not there the stub in here is used.  Also
 *	the interupt for a NI on a ka640 needs to go to STRAY if the ka640
 *	does not config in the device and that is also done here.
 *
 * 15-Feb-1988	Fred Canter
 *	Added VAX420 (CVAXstar/PVAX) to CPUs needing emulation code.
 *	Also added VAX3600 & VAX6200, which were missing.
 *
 * 08-Jan-1988	Todd M. Katz			TMK0001
 *	Added the data variable scs_disable.  This variable is initialized
 *	by SCS to contain the address of the SCS shutdown routine.  Otherwise,
 *	it is referenced only during panics when the specified shutdown
 *	routine is invoked to permanently disable all local system ports.
 *
 * 12-11-87	Robin L. and Larry C.
 *	Added portclass support to the system.
 *
 * 12-Aug-86  -- prs	Removed isGENERIC option.
 *
 * 3-Aug-86   -- jaw 	allocate a uba struct for klesib
 *
 * 5-Jun-86   -- jaw 	changes to config.
 *
 * 14-Apr-86 -- jaw
 *	remove MAXNUBA referances.....use NUBA only!
 *
 * 18-Mar-86 -- jaw  add routines to cpu switch for nexus/unibus addreses
 *		     also got rid of some globals like nexnum.
 *		     ka8800 cleanup.
 *
 *	Stephen Reilly, 22-Mar-85
 *	Added new structures for the floating emulation stuff
 *
 ***********************************************************************/

#include "ci.h"
#include "uq.h"
#include "msi.h"
#include "ln.h"
#include "vaxbi.h"
#ifdef mips
#include "ne.h"
#endif

#ifdef vax
#include "mba.h"
#else
#define NMBA 0
#endif vax

#include "uba.h"
#include "kdb.h"
#include "klesib.h"
#include "kdm.h"

#include <sys/types.h>			/* cpu.h needs this */
/* #include <machine/pte.h> */
#include <machine/cpu.h>

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/map.h>
#include <sys/buf.h>
#include <sys/dk.h>
#include <sys/vm.h>
#include <sys/conf.h>
/*#include <sys/dmap.h>	*/
#include <sys/reboot.h>
/* #include <sys/cpudata.h> */


#ifdef vax
#include <machine/mem.h>
#include <machine/mtpr.h>
#include <machine/ioa.h>
#include <machine/nexus.h>
#endif vax

#include <hal/scb.h>
#include <io/dec/scs/sca.h>

#ifdef vax
#include <dec/io/mba/vax/mbareg.h>
#include <dec/io/mba/vax/mbavar.h>
#endif vax

#include <io/dec/uba/ubareg.h>
#include <io/dec/uba/ubavar.h>
#include <hal/cpuconf.h>

#ifdef mips
struct qbm_regs *qb_ptr;	/* Points to unibus adaptor regs */
#endif mips

#ifdef	BINARY
#if NCI > 0
extern	int	nNCI;
#endif NCI

#if NMSI > 0
extern	int	nNMSI;
#endif NMSI

extern	int	numbvp;
extern	int	numci;
extern	int	nummsi;
#ifdef vax
extern	int	(*mbaintv[])();
#endif vax
extern	int	(*ubaintv[])();
extern	int	nNMBA;
extern	(*Mba_find)();
extern	int	nNUBA;
extern  int	nNKDM;
extern  int	nNKDB;
extern  int	nNMBA;
extern  int	nNKLESIB;

#else
int cpu_avail = 1;

/*
 * Addresses of the (locore) routines which bootstrap us from
 * hardware traps to C code.  Filled into the system control block
 * as necessary.
 */
#ifdef mips
#if NVAXBI == 0
bisst() {}	/* stub for VAXBI start self test */
#endif NVAXBI
#endif mips

#if NUQ == 0
uqdriver() {}	/* stub for machdep gendump() */
#endif NUQ

#if NMBA > 0 
int	(*mbaintv[4])() =	{ Xmba0int, Xmba1int, Xmba2int, Xmba3int };
#endif NMBA 

#ifdef VAX8600
int	(*ubaintv[7])() =	{ Xua0int, Xua1int, Xua2int, Xua3int, Xua4int, Xua5int, Xua6int }; 
#else
#ifdef VAX780
int	(*ubaintv[4])() =	{ Xua0int, Xua1int, Xua2int, Xua3int };
#else VAX780
int	(*ubaintv[4])() = 	{ (int (*)()) -1, ( int(*)()) -1, ( int(*)()) -1, ( int(*)()) -1};
#endif VAX780
#endif VAX8600

#ifdef mips		/* Stubs for the SGEC */
#if NNE == 0
neintr(){stray(0,0xd4);}
neprobe(){return(-1);     /* stub returns -1 if its not configured */ }
#endif NNE
#endif mips
		/* Make locore and ka650 happy if no NI device is configed in */
#if NLN == 0

#ifdef vax
lnintr(){logstray(1,0x14,0xd4);} /* ELSI_SCB */
#endif vax
#ifdef mips
lnintr() {stray(0,0xd4);} 
#endif mips

lnprobe(){return(-1);     /* stub returns -1 if its not configured */ }
#endif NLN
		/* Protect ka650.c from undefines if no MSI devices are configed in */

/*
 * Allocate the MSI adapter data structures.
 */
int		nummsi = 0;		/* Number of local MSI ports	     */
#if NMSI > 0
int		nNMSI = NMSI;		/* Number of configured MSI ports    */
struct _pccb	*msi_adapt[ NMSI ];	/* MSI adapter structures	     */
#endif NMSI

int		numbvp = 0;		/* Number of local BVP ports	     */

/*
 * Allocate the CI adapter structures
 */
int		numci = 0;		/* Number of local CI ports	     */
#if NCI > 0
int		nNCI = NCI;		/* Number of configured CI ports     */
CIISR		ci_isr[ NCI ];

#ifdef mips
ciintr(int i) { (ci_isr[i].isr)(ci_isr[i].pccb); }
#endif mips

#else
CIISR		ci_isr[ 1 ];
#endif NCI

void		( *scs_disable )()	/* Address of SCS shutdown routine   */
		    = NULL;		/* Initialized by SCS		     */

/*
 * This allocates the space for the per-uba information,
 * such as buffered data path usage.
 */
#if NUBA != 0  || NKDB != 0 || NKLESIB != 0 || NKDM != 0
struct	uba_hd uba_hd[NUBA+NKDB+NKLESIB+NKDM];
#else
struct uba_hd uba_hd[1];
#endif NUBA

#if NUBA > 0
int	tty_ubinfo[NUBA];
#else
int	tty_ubinfo[1];
#endif

#if NMBA > 0
extern	mbafind();
int	(*Mba_find)() = mbafind;
#else NMBA
int	(*Mba_find)() = (int (*)()) -1;
mbintr()	{/* Keep locore happy */ }
#endif NMBA

#include "xmi.h"
#if NXMI == 0
get_xmi() {/* stub */}
xmisst() {/* stub */}
int numxmi;
#endif

int	nNKDM = NKDM;
int	nNUBA = NUBA;
int	nNKDB = NKDB;
int	nNMBA = NMBA;
int	nNKLESIB = NKLESIB;

#ifdef vax
#ifdef	EMULFLT

asm(".globl	_vaxopcdec");
asm("_vaxopcdec:	.long	vax$opcdec");
asm(".globl	_vaxspecialhalt");
asm("_vaxspecialhalt: .long	vax$special_halt");
asm(".globl	_vaxspecialcont");
asm("_vaxspecialcont: .long	vax$special_cont");
asm(".globl	_vaxemulbegin");
asm("_vaxemulbegin:	.long	vax$emul_begin");
asm(".globl	_vaxemulend");
asm("_vaxemulend:	.long	vax$emul_end");
asm(".globl	_exeacviolat");
asm("_exeacviolat:	.long	exe$acviolat");

#else	EMULFLT

int (*vaxopcdec)() = 0;

#if defined (MVAX) || defined (VAX3600) || defined (VAX6200) || defined (VAX420)
asm(".globl	_vaxspecialhalt");
asm("_vaxspecialhalt: .long	vax$special_halt");
asm(".globl	_vaxspecialcont");
asm("_vaxspecialcont: .long	vax$special_cont");
asm(".globl	_vaxemulbegin");
asm("_vaxemulbegin:	.long	vax$emul_begin");
asm(".globl	_vaxemulend");
asm("_vaxemulend:	.long	vax$emul_end");
asm(".globl	_exeacviolat");
asm("_exeacviolat:	.long	exe$acviolat");

#else MVAX || VAX420

int (*vaxspecialhalt)() = 0;
int (*vaxspecialcont)() = 0;
int (*vaxemulbegin)() = 0;
int (*vaxemulend)() = 0;
int (*exeacviolat)() = 0;
#endif MVAX || VAX420

#endif EMULFLT
#endif vax

#endif BINARY

