/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	param.c,v $
 * Revision 4.3.2.10  92/06/18  15:16:11  Anthony_Decarlo
 * 	bmerge
 * 	[92/06/18  14:32:09  Anthony_Decarlo]
 * 
 * 	Added declaration for sys_v_mode
 * 	[92/06/15  10:43:52  Anthony_Decarlo]
 * 
 * Revision 4.3.2.9  92/05/21  12:53:57  Marian_Macartney
 * 	Make vm_tune parameters configurable
 * 	[92/05/21  12:47:25  Marian_Macartney]
 * 
 * Revision 4.3.2.8  92/04/24  09:29:48  Robert_Picco
 * 	UBC parameters and VM kluster
 * 	[92/04/16  08:08:30  Robert_Picco]
 * 
 * 	UBC parameters and VM kluster
 * 	[92/04/16  08:07:36  Robert_Picco]
 * 
 * Revision 4.3.2.7  92/04/22  15:06:06  Stephen_Strange
 * 	Changed definition for NVNODE to reduce the number of vnodes allocated.
 * 	[92/04/22  15:05:15  Stephen_Strange]
 * 
 * Revision 4.3.2.6  92/03/27  18:06:18  Diane_Lebel
 * 	AG merge
 * 	[92/03/27  18:00:16  Diane_Lebel]
 * 
 * 	Added support for per-process configurable file descriptor
 * 	limits through setrlimit syscall.
 * 	[92/03/26  19:54:32  Diane_Lebel]
 * 
 * Revision 4.3.2.5  92/03/26  11:44:22  Robert_Picco
 * 	changed bufcache default from 10 to 3 percent
 * 	[92/03/24  10:00:22  Robert_Picco]
 * 
 * Revision 4.3.2.4  92/03/25  12:38:29  Stephen_Strange
 * 	Changed value of nmount_max
 * 	[92/03/25  09:51:03  Stephen_Strange]
 * 
 * 	Changed the value of nmount_max.
 * 	[92/03/05  10:50:49  Stephen_Strange]
 * 
 * 	add /proc support
 * 	[92/02/27  14:44:51  David_Scoda]
 * 
 * Revision 4.3.2.3  92/02/27  15:22:52  David_Scoda
 * 	"add /proc support"
 * 
 * Revision 4.3.2.2  91/12/18  21:41:20  William_Burns
 * 	Merge from ODE/TIN: revision 3.8.9.3
 * 	date: 91/11/14 15:42:10;  author: devrcs;  state: Exp;  lines added/del: 103/1
 * 	sccs rev: 3.10;  orig date: 91/11/04 16:54:42;  orig author: fred
 * 	Fred Canter - config cleanup.
 * 	[91/12/04  11:40:30  William_Burns]
 * 
 * Revision 4.3  91/11/26  11:05:34  devbld_zk3
 * 	Baselevel AG_BL0
 * 
 * Revision 4.2.2.2  91/10/25  14:46:59  William_Burns
 * 	Merge from ODE/TIN: revision 3.8.9.2
 * 	date: 91/10/22 19:59:23;  author: devrcs;  state: Exp;  lines added/del: 4/5
 * 	sccs rev: 3.9;  orig date: 91/10/08 15:17:36;  orig author: pcameron
 * 	Removed definition of ult_bin_isatty_fix
 * 	[91/10/25  11:22:03  William_Burns]
 * 
 * Revision 4.2  91/09/19  22:07:16  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
#ifndef lint
static char	*sccsid = "@(#)$RCSfile: param.c,v $ $Revision: 4.3.2.10 $ (DEC) $Date: 92/06/18 15:16:11 $";
#endif
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * Modification History
 *
 * 27-Oct-91	Fred Canter
 *	Move rlimit structures here so data/stack size limits can
 *	be set in the kernel config file.
 *	Make System V IPC definitions configurable.
 *
 *  8-Oct-91	Phil Cameron
 *	Removed "ult_bin_isatty_fix" since it is no longer needed.
 *
 *  2-Jul-91	Jim McGinness
 *	Add "ult_bin_isatty_fix" as configureable parameter.  It is
 *	initialized here, used in bsd/tty.c, and can be altered
 *      as a boot parameter or through mipskopt().  It replaces the
 *	"ult_bin" parameter use in earlier base levels.
 *
 * 10-june-1991  Brian Harrigan
 *         Allow rt_preepmt_opt to be set/cleared at config time and
 *         configurable on kernels built from binaries
 * 6-June-1991   Brian Stevens
 *	  Allow maxuprc, bufcache, maxcallouts, and maxthreads (per task) to
 *	  be specified in the config file and to be configurable on kernels
 *	  built from binaries.
 *
 * 04-Jun-1991   Diane Lebel
 * 	Added max_nofile parameter for configurable number of
 *	per-process file descriptors.
 *
 * 15-May-1991   Paula Long
 *        Extended the size of the callout queue to take into account
 *        the fact that the sleep() and usleep() functions use the callout
 *        queue to put a process/thread to sleep.  Also Additional per-process
 *        timers were made available when RT_TIMER is defined, and that 
 */


/*
 * Copyright (C) 1988,1989 Encore Computer Corporation.  All Rights Reserved
 *
 * Property of Encore Computer Corporation.
 * This software is made available solely pursuant to the terms of
 * a software license agreement which governs its use. Unauthorized
 * duplication, distribution or sale are strictly prohibited.
 *
 */
/*
 * Copyright (c) 1980, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *

 */

#include <quota.h>
#include <confdep.h>

/*
 * NOTE: confdep.h MUST preceed param.h.
 *
 *	This allows overriding System V IPC default
 *	definitions from the kernel config file.
 */

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/socket.h>
#include <sys/user.h>
#include <sys/proc.h>
#include <sys/vnode.h>
#include <ufs/quota.h>
#include <sys/file.h>
#include <sys/callout.h>
#include <sys/clist.h>
#include <sys/mbuf.h>
#include <sys/kernel.h>
#include <sys/utsname.h>
#include <sys/msg.h>
#include <sys/sem.h>
#include <sys/shm.h>

#include <rt_timer.h>

/*
 * System parameter formulae.
 *
 * This file is copied into each directory where we compile
 * the kernel; it should be modified there to suit local taste
 * if necessary.
 *
 * Compiled with -DTIMEZONE=x -DDST=x -DMAXUSERS=xx
 */

/*
 * The CLOCKS_PER_SEC (Posix) constant is defined per machine in
 * <machine/machlimits.h>. But if it isn't default to 100.
 */

#if !defined(CLOCKS_PER_SEC)
#define CLOCKS_PER_SEC 100
#endif

int	hz = CLOCKS_PER_SEC;
int	tick = 1000000 / CLOCKS_PER_SEC;
                                        /* This is the amount of time which
					   must be added once every hz tick
					   (i.e. once per second!) */
int	fixtick = 1000000 - ((1000000/CLOCKS_PER_SEC) * CLOCKS_PER_SEC);
int     maxdriftrecip = 1000;		/* This is a default which represents
					   a ridiculously poor clock which
					   drifts at a rate of 1 part in 1000,
					   most cpu clocks are good to between
					   1 part in 10000 (maxdriftrecip =
					   10000) and 2 parts in 100000
					   (maxdriftrecip = 50000). This value
					   should be established in some (clock)
					   hardware dependent module, e.g.
					   mc146818clock.c. for the PMAX */
#if	CLOCKS_PER_SEC > 100
int	tickadj = 1;			/* can adjust CLOCKS_PER_SEC usecs per second */
#else
int	tickadj = 100 / CLOCKS_PER_SEC;		/* can adjust 100 usecs per second */
#endif
struct	timezone tz = { TIMEZONE, DST };

struct utsname utsname = {
	"OSF1",
	"",
	"",
	"",
	MACHINE
};
		
#define NPROC (20 + 8 * MAXUSERS)
int	nproc = NPROC;

/* The following calculation was adopted from Ultrix */
#define NVNODE (NPROC + (2*MAXUSERS) + 128)

/* The following was the original calculation (from OSF) */
/*#define NVNODE (((((2*NPROC)+ 16 + MAXUSERS) + 32)*2) + (NMOUNT+((8*NMOUNT)*2)))*/

int	nvnode = NVNODE;
int	nfile = 16 * ((2*NPROC) + 16 + MAXUSERS) / 10 + 32;

/*
 * maxuprc is set from source by CHILD_MAX in sys/limits.h.  Allow it to be
 * overridden if maxuprc is set in the config file.  Future kernel code should
 * use the global int maxuprc, not MAXUPRC or CHILD_MAX.
 */
#if !defined(MAXUPRC)
int   maxuprc = CHILD_MAX;
#else
int   maxuprc = MAXUPRC;
#endif

#if !defined(BUFCACHE)
int   bufcache = 3;
#else
int   bufcache = BUFCACHE;
#endif

#if	!defined(UBCMINPERCENT)
int	ubc_minpercent = 10;
#else
int	ubc_minpercent = UBCMINPERCENT
#endif

#if	!defined(UBCMAXPERCENT)
int	ubc_maxpercent = 70;
#else
int	ubc_maxpercent = UBCMAXPERCENT;
#endif

#if	!defined(WRITEIO_KLUSTER)
vm_size_t vm_max_wrpgio_kluster = 32*1024;
#else
vm_size_t vm_max_wrpgio_kluster = VM_WRITEIO_KLUSTER;
#endif	

#if	!defined(READIO_KLUSTER)
vm_size_t vm_max_rdpgio_kluster = 16*1024;
#else
vm_size_t vm_max_rdpgio_kluster = READIO_KLUSTER;
#endif

#if !defined(MAXTHREADS)
int   maxthreads = 256; /* max threads per task */
#else
int   maxthreads = MAXTHREADS; /* max threads per task */
#endif

int   maxusers = MAXUSERS;
int   sys_v_mode = SYS_V_MODE;
/* #if RT
 * RT_PREEMPT_OPT is set at config time so that preemption can be
 * turned off in a kernel which has RT_PREEMPT compiled on.
*/
#if !defined(RT_PREEMPT_OPT)
int   rt_preempt_opt= 0; /* preemption is OFF*/
#else
int   rt_preempt_opt = 1; /* Preemption is ON */
#endif
/*
 * #if RT
 * The callout queue needs to be extended to take into account the
 * use of the callout queue for putting a thread to sleep.  It must
 * also be extended when RT_TIMERS are included, since RT_TIMERS allow
 * TIMER_MAX timers per-process.
 */
#if !defined(MAXCALLOUTS)
#if RT_TIMER
int	ncallout = 16 + NPROC + (NPROC * TIMER_MAX) + THREAD_MAX;
#else
int	ncallout = 16 + NPROC + THREAD_MAX;
#endif                         
#else
int   ncallout = MAXCALLOUTS;
#endif

int	nclist = 60 + 12 * MAXUSERS;
int	create_fastlinks = 1;
int	select_max_elements = 1024 + NPROC * 4;
int	select_chunk_elements = 256;
int	path_num_max = 64;
int	ucred_max = 128;

/*
 *  Note: nmount_max is *not* a hard limit on the total number of mounts (nfs,
 *  	ufs, s5).  It is the number passed to zinit() when initializing the
 *  	'mount_zone' zone.  This zone is dynamically expandable.
 */
int	nmount_max = 2 * NMOUNT;

int	nmount = NMOUNT;		/* max number of ufs mounts */

int	nchsize = NVNODE * 11 / 10;
int	inohsz = 512;
int	spechsz = 64;
int	nchsz = 128;
int	bufhsz = 512;
int	numcpus = 1;
#ifdef	multimax
int	nmbclusters;
#else
int     nmbclusters = NMBCLUSTERS;
#endif
#if	QUOTA
int	nquota = (MAXUSERS * 9) / 7 + 3;
int	ndquot = NVNODE + (MAXUSERS * NMOUNT) / 4;
#endif
int ufs_blkpref_lookbehind = 8;

/*
 * The default number of per-process file descriptors is configurable.
 * The getdtablesize(2) system call should be used to obtain the
 * current limit.  open_max_soft is the default per-process limit.
 * A process can increase its soft limit up to its hard limit using 
 * setrlimit(2).  The default hard and soft limits below must be 
 * at least 64, and less than or equal to OPEN_MAX_SYSTEM in param.h.
 */

int open_max_hard = OPEN_MAX_HARD;
int open_max_soft = OPEN_MAX_SOFT;

/*
 * These are initialized at bootstrap time
 * to values dependent on memory size
 */

int	nbuf;


/*
 * These have to be allocated somewhere; allocating
 * them here forces loader errors if this file is omitted
 * (if they've been externed everywhere else; hah!).
 */
struct	proc *proc, *procNPROC;
struct	vnode *vnode, *vnodeNVNODE;
struct	file *file, *fileNFILE;
struct 	callout *callout;
struct	cblock *cfree = 0;
struct	cblock *cfreelist = 0;
int	cfreecount = 0;
struct	buf *buf;
char	*buffers;
struct	namecache *namecache;
#if	QUOTA
struct	quota *quota, *quotaNQUOTA;
struct	dquot *dquot, *dquotNDQUOT;
#endif

/*
 * Establish current and maximum values for task's
 * data and stack sizes. If maxdsiz is specified in
 * the config file, then the define comes from confdep.h,
 * otherwise the defaults in vmparam.h are used. Same
 * for maxssiz, dfldsiz, and dflssiz.
 */
#include <sys/vmparam.h>

struct rlimit vm_initial_limit_stack = { DFLSSIZ, MAXSSIZ };
struct rlimit vm_initial_limit_data = { DFLDSIZ, MAXDSIZ };
struct rlimit vm_initial_limit_core = { RLIM_INFINITY, RLIM_INFINITY };

/*
 * System V IPC definitions. Default values come from param.h
 * or user can override the defaults in the kernel config file
 * (in which case values come from confdep.h).
 */

/* messages */
struct msqid_ds msgque[MSGMNI];         /* msg queue headers */
struct msginfo  msginfo = {             /* message parameters */
                           MSGMAX,
                           MSGMNB,
                           MSGMNI,
                           MSGTQL
};
/* Following will need work when security is implemented. */
#if     SEC_ARCH
/*
 * Allocate space for the message queue tag pools. On systems that
 * allocate the message queue structures dynamically, the tag pools
 * should also be dynamically allocated at the same time as the
 * queues.
 */
tag_t           msgtag[MSGMNI * SEC_TAG_COUNT];
#endif

/* semaphores */
struct semid_ds sema[SEMMNI];           /* semaphore data structures */
struct sem      sem[SEMMNS];            /* semaphores */
struct seminfo  seminfo = {             /* semaphore information structure */
                           SEMMNI,
                           SEMMSL,
                           SEMOPM,
                           SEMUME,
                           SEMVMX,
                           SEMAEM
};

union {
        u_short         semvals[SEMMSL];        /* set semaphore values */
        struct semid_ds ds;                     /* set permission values */
        struct sembuf   semops[SEMOPM];         /* operation holding area */
} semtmp;

/* Following will need work when security is implemented. */
#if     SEC_ARCH
/*
 * Allocate space for the semaphore tag pools.  On systems that allocate
 * the semaphore structures dynamically, the tag pools should also be
 * dynamically allocated at the same time as the semaphores.
 */
tag_t           semtag[SEMMNI * SEC_TAG_COUNT];
#endif

/* shared memory */
struct  shminfo shminfo = {     /* shared memory info structure */
                SHMMAX,
                SHMMIN,
                SHMMNI,
                SHMSEG
};

struct  shmid_internal  shmem[SHMMNI];  /* shared memory headers */

/* Following will need work when security is implemented. */
#if     SEC_ARCH
/*
 * Allocate space for the shared memory tag pools.  On systems that allocate
 * the shared memory structures dynamically, the tag pools should also be
 * dynamically allocated at the same time.
 */
tag_t           shmtag[SHMMNI * SEC_TAG_COUNT];
#endif

/* 
 * vm tune parameters 
 * If any of the vm_tune parameters are defined in
 * the config file, then the define comes from
 * confdep.h, otherwise the defaults in vm_tune.h
 * are used.
 */
#include <vm/vm_tune.h>

struct vm_tune vm_tune = {
		COWFAULTS,		/* Copy point */
		MAPENTRIES,		/* Maximum map entries */
		MAXVAS,			/* Maximum VAS for user map */
		MAXWIRE,		/* Maximum wired memory */
		HEAPPERCENT,		/* Percent of memory for heap */
		ANONKLSHIFT,		/* 128K anon page shift */
		ANONKLPAGES,		/* Use system default anon_klpages */
		VPAGEMAX,		/* Maximum vpage for umap */
		UBCPAGESTEAL,		/* Steal from vnode clean list */
		UBCDIRTYPERCENT,	/* Percent dirty UBC buffers */
		UBCSEQSTARTPERCENT,	/* Start when ubc is this percent */
		UBCSEQPERCENT,		/* Percent sequential allocates */
		CSUBMAPSIZE,		/* Size of kernel copy map */
		UBCBUFFERS,		/* Maximum UBC buffers */
		SWAPBUFFERS,		/* Maximum swap buffers */
		CLUSTERMAP,		/* ckluster dup map size*/
		CLUSTERSIZE		/* max cluster bp size */
};




