/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	entry.s,v $
 * Revision 1.1.3.8  92/06/19  14:54:56  Donald_Dutile
 * 	Removed sr_usermask import. clean up.
 * 	[92/05/18  10:12:24  Donald_Dutile]
 * 
 * Revision 1.1.3.7  92/03/28  09:29:23  William_Burns
 * 	Removed obsolete include of md.h
 * 	[92/03/28  09:28:51  William_Burns]
 * 
 * Revision 1.1.3.6  92/03/26  18:02:06  Gary_Dupuis
 * 	Changed ifdef PMAX to ifdef mips.
 * 	[92/03/26  16:04:44  Gary_Dupuis]
 * 
 * Revision 1.1.3.5  92/02/12  10:46:46  Brian_Stevens
 * 	Replace call to check_dbg with a call to kdebug_init.  Did
 * 	minor cleanup around this.
 * 	[92/02/12  10:27:24  Brian_Stevens]
 * 
 * Revision 1.1.3.4  92/02/05  17:20:42  Donald_Dutile
 * 	Add initial pcb on startup; setup debug stack similarly;
 * 	part of mips kstack changes.
 * 	[92/01/09  22:46:12  Donald_Dutile]
 * 
 * Revision 1.1.3.3  91/12/18  21:37:26  William_Burns
 * 	date: 91/11/14 15:48:53;  author: devrcs;  state: Exp;  lines added/del: 1/62
 * 	sccs rev: 3.2;  orig date: 91/11/05 10:20:44;  orig author: burns
 * 	Cleaned up comments.
 * 	[91/12/17  15:24:34  William_Burns]
 * 
 * Revision 1.1.3.2  91/11/20  13:32:47  Hal_Project
 * 	Moved from dec/machine/mips; pool reorg.
 * 	[91/11/18  00:05:38  Donald_Dutile]
 * 
 * Revision 4.2  91/09/19  23:13:28  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: entry.s,v $ $Revision: 1.1.3.8 $ (DEC) $Date: 92/06/19 14:54:56 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/* 
 * derived from entry.s	2.2	(ULTRIX/OSF)	12/15/90
 */
/*
 * @(#)entry.s	4.3	(ULTRIX)	9/6/90
 */
/* ------------------------------------------------------------------ */
/* | Copyright Unpublished, MIPS Computer Systems, Inc.  All Rights | */
/* | Reserved.  This software contains proprietary and confidential | */
/* | information of MIPS and its suppliers.  Use, disclosure or     | */
/* | reproduction is prohibited without the prior express written   | */
/* | consent of MIPS.                                               | */
/* ------------------------------------------------------------------ */
/*
 *		Modification History
 *
 * 17-Jan-91 -- Don Dutile
 *	Merged to v4.2.  Added save and restore of a3, the vector boot
 *	variable.
 *
 * 06-Sep-90 -- Randall Brown
 *	Cleanup of some code.  Removed code no longer being used. 
 *
 * 09-Aug-90 -- Randall Brown
 *	Added the variable sr_usermask, so that the mask that get put
 *	into the status register can vary from machine to machine .
 *
 * 20-Jul-1990	burns
 *	first hack at moving to OSF/1 (snap3)
 *
 * 16-Apr-90 -- jaw/gmm
 *	move kstackflg to cpudata structure.
 *
 * 01-Dec-89 -- bp
 *	fixed the SAS bss alignment problem for MDMAPSIZE
 *
 * 09-Nov-89 -- bp
 *	put mips page table entrys in bss
 *	be carefull adding entries because of an .lcomm problem
 *	which is commented on below
 *
 * 03-Oct-89 -- gmm
 *	SMP changes (remove kstackflag, secondary startup etc)
 *
 * 10-July-89 -- burns
 *	Support for DECsystem 58xx.
 *
 * 20 Feb 89 -- Kong
 *	Added to Sysmap 1026 PTEs to map the 4Mb memory space and 8Kb
 *	I/O space of the Qbus of the Mipsfair.
 *
 * 07 Dec 88 -- depp
 *	Moved the startup stack off the PROM stack (as MIPSco did it), to
 *	prevent PROM area corruption.  The PROM stack now exists elsewhere
 */


#include <confdep.h>

#include <machine/asm.h>
#include <machine/reg.h>
#include <machine/regdef.h>

#include <machine/machparam.h>
#include <machine/vmparam.h>
#include <mach/mips/vm_param.h>
#include <machine/cpu.h>
#include <machine/pcb.h>
#include <hal/entrypt.h>	/* prom entry point definitions */

#include <kern/xpr.h>

#include <assym.s>
#include <mach/mips/vm_param.h>

/*
 * Save area for boot params
 */
	LBSS(_argc, 4)
	 BSS(_argv, 4)
	LBSS(_environ, 4)
	LBSS(_vector, 4)
/*
 * We better get a stack for ourselves as soon as possible.
 * Note: the "intstack" misnomer is because the machine-independent
 * code knows about this symbol, which must therefore be defined.
 */
	.text				# so that it goes upfront
	.align	2
	.globl	pcb_initial_space

pcb_initial_space:
	.space	2*NBPG
	.globl	intstack
intstack:
	.space	INTSTACK_SIZE-4
	.globl	boot_stack
boot_stack:
	.space	4

/*
 * Kernel entry point
 */
ENTRY_FRAME=	(4*4)+4+4		/* 4 argsaves, old fp, and old sp */
EXPORT(eprol)				/* for benefit of profiling */
NESTED(start, ENTRY_FRAME, zero)
        j       _realstart              /* kernel entry point */
        j       _coredump               /* dump core to config'ed dump dev */
#ifdef notdef
        j       _xprdump                /* dumpt  
        j       _xprtail                /* dump tail of trace buffer */
        j       _msgdump                /* dump msg buffer to console */
#endif /* notdef */

/*
 * Kernel initialization
 */
_realstart:
	/*
	 * Now on prom stack; a0, a1, a2, and a3 contain argc, argv, environ
	 * and vector from boot.  Stay on that stack, for the time being.
	 */

        /* jal  _dz_setup */
        /* above strickly for porting ... careful about trashing a0-a3  */

	la	gp,_gp
	/*
	 * Save invocation parameters
	 */
	sw	a0,_argc
	sw	a1,_argv
#ifdef	mips
	/* accomodate screwy Ultrix loader with similarly screwy fix */
	bne	a2,zero,1f
	la	a2,0xa000376c	/* XXX magic: prom environ */
1:
#endif	/* mips */
/* end from OSF */
	sw	a2,_environ
	sw	a3,_vector
	/*
	 * Check whether we should load kdebug
	 */
	jal	kdebug_init		# see if debugging requested
	la	gp,_gp			# this time, screwy prom_exec()
	/*
	 *  Reload arguments and get started
	 */
	lw	a0,_argc
	lw	a1,_argv		# kdebug_init may have to "change" argv
	lw	a2,_environ
	lw	a3,_vector
1:
/* set up virtual PCB */
	li	a3,0x7ffff000
	la	a1,pcb_initial_space
	addiu	a1,(NBPG-1)
	and	a1,a3,a1

	ori	a1,0x700
	li      a2,VM_MIN_KERNEL_ADDRESS-(2*NBPG)
	li	a3,TLBWIRED_KSTACK<<TLBINX_INXSHIFT
	.set 	noreorder
	mtc0	a3,C0_INX
	mtc0	a1,C0_TLBLO
	mtc0	a2,C0_TLBHI
	nop
	c0	C0_WRITEI
	nop
       	.set	reorder
	li      a3,0x7ffff000
        la      a1,pcb_initial_space
        addiu   a1,((2*NBPG)-1)
        and     a1,a3,a1
        ori     a1,0x700
        li      a2,VM_MIN_KERNEL_ADDRESS-(1*NBPG)
        li      a3,TLBWIRED_KSTACK1<<TLBINX_INXSHIFT
        .set    noreorder
        mtc0    a3,C0_INX
        mtc0    a1,C0_TLBLO
        mtc0    a2,C0_TLBHI
        nop
        c0      C0_WRITEI
        nop
	.set	reorder
        li      sp,PCB_WIRED_ADDRESS-ENTRY_FRAME          # switch stack
	li	k0,PCB_WIRED_ADDRESS	# address of PCB
	sw      gp,PCB_KSTACK(k0)	# running on kernel stack now
        sw      zero,ENTRY_FRAME-4(sp)  # zero old ra for debuggers

	lw	a0,_argc
	lw	a1,_argv		# kdebug_init may have to "change" argv
	lw	a2,_environ
	lw	a3,_vector

	.set noreorder
	nop
	mtc0	zero,C0_TLBHI		# clean a little
	nop
	li	v0,KPTEADDR		# kernel's pte base; was KPTEBASE in ULTRIX
	nop
	mtc0	v0,C0_CTXT
	nop
	.set reorder

	/*
	 * End of cold code.  mips_init(argc,argv,environ) will do the rest,
	 * including creating the first thread and making it start at main().
	 */
	jal	mips_init		# call mips_init(argc, argv, environ)

	/* NOTREACHED */
	END(start)
