#include <sys/param.h>
#include <sys/buf.h>
#include <sys/map.h>
#include <sys/vm.h>
#include <sys/config.h>
#include <io/common/devdriver.h>

#include <io/dec/uba/ubavar.h>


int nulldev();

int (*tcint0[])() = { nulldev, 0 };	/* no interrupt routine for tc */
extern struct driver ascdriver;
extern Xascintr0();
int	 (*ascint0[])()	= { Xascintr0, 0 } ;

extern struct driver lndriver;
extern Xlnintr0();
int	 (*lnint0[])()	= { Xlnintr0, 0 } ;

extern struct driver dcdriver;
extern Xdcintr0();
int	 (*dcint0[])()	= { Xdcintr0, 0 } ;

extern struct driver fbdriver;
extern Xfbint0();
int	 (*fbint0[])()	= { Xfbint0, 0 } ;


/* struct	port {	*/
/*	int	(*conf)();		/* config routine for this port */
/*};	*/





extern int tcconfl1();
extern int tcconfl2();


/* struct	bus {	*/
/*	u_long          *bus_mbox       /* bus mail box */
/*	struct bus	*nxt_bus	/* next bus				*/
/*	struct controller *ctlr_list;	/* controllers connected to this bus */
/*	struct bus	*bus_hd;	/* pointer to bus this bus connected to */
/*	struct bus	*bus_list;	/* buses connected to this bus */
/*	int		bus_type;	/* bus type 			*/
/*	char		*bus_name;	/* bus name 			*/
/*	int		bus_num;	/* bus number			*/
/*	int		node;		/* node or slot number		*/
/*	char		*connect_bus;	/* conected to bus name 	*/
/*	int		connect_num;	/* connected to bus number	*/
/*	int		(*confl1)();	/* Level 1 configuration routine */
/*	int		(*confl2)();	/* Level 2 configuration routine */
/*	char		*pname;		/* port name, if needed		*/
/*	struct port	*port;		/* pointer to port structure	*/
/*	int		(**intr)();	/* interrupt routine(s) for this bus  */
/*	int		alive;		/* alive indicator		*/
/*	struct bus_framework	*framework; /* Subsystem expansion routines */
/*	char		*driver_name;	/* name of controlling driver */
/*	caddr_t		private[5];	/* Reserved for bus use		*/
/*	caddr_t		conn_priv[5];	/* Reserved for connected bus use*/
/*	caddr_t		rsvd[5];	/* Reserved for future expansion */
/* };	*/


struct bus bus_list[] = {
	{ 0,0,0,0,0,0,"tc",0,-1,"nexus",-1,tcconfl1,tcconfl2,"",0,tcint0,0,0,"",0,0,0},
	{ 0,0,0,0,0,0,(char *)0,0,0,"",0,0,0,"",0,0,0,0,(char *)0,0,0,0}
};

/* struct	controller {	*/
/*	u_long         *ctlr_mbox;      /* ctlr mailbox */
/*	struct controller *nxt_ctlr;	/* pointer to next ctlr on this bus */
/*	struct device	*dev_list;	/* devices connected to this ctlr */
/*	struct bus	*bus_hd;	/* pointer to bus for this ctlr   */
/*	struct driver	*driver;	/* pointer to driver structure for */
/*					/* this controller 		   */
/*	int		*ctlr_type;	/* controller type		*/
/*	char		*ctlr_name;	/* controller name		*/
/*	int		ctlr_num;	/* controller number		*/
/*	char		*bus_name;	/* bus name			*/
/*	int		bus_num;	/* bus number connected to 	*/
/*	int		rctlr;		/* remote controller number	*/
/*					/* e.g. ci node or scsi id	*/
/*	int		node;		/* node or slot number		*/
/*	int		alive;		/* alive indicator		*/
/*	char		*pname;		/* port name			*/
/*	struct port	*port;		/* port structure		*/
/*	int		(**intr)();	/* interrupt routine(s) for this ctlr */
/*	caddr_t		addr;		/* virtual address of controller */
/*	caddr_t		addr2;		/* virtual address of second ctlr */
/*					/* register space		  */
/*	int		flags;		/* flags from from config 	*/
/*	int		bus_priority;	/* bus priority from from config */
/*	int		ivnum;		/* interrupt vector number	*/
/*	int		priority;	/* system ipl level		*/
/*	int		cmd;		/* cmd for go routine		*/
/*	caddr_t		physaddr;	/* physical address of addr	*/
/*	caddr_t		physaddr2;	/* physical address of addr2	*/
/*	caddr_t		private[5];	/* Reserved for ctlr use	*/
/*	caddr_t		conn_priv[5];	/* Reserved for connected bus use*/
/*	caddr_t		rsvd[5];	/* reserved for future expansion */
/* };	*/




struct controller controller_list[] = {
	{ 0,0,0,0,&ascdriver,0,"asc",0,"tc",0,0,5,0,"",0,ascint0,0,0,0x0,0,0x0,0,0,0,0,0,0,0},
	{ 0,0,0,0,&lndriver,0,"ln",0,"tc",0,0,6,0,"",0,lnint0,0,0,0x0,0,0x0,0,0,0,0,0,0,0},
	{ 0,0,0,0,&dcdriver,0,"dc",0,"tc",0,0,7,0,"",0,dcint0,0,0,0x0,0,0x0,0,0,0,0,0,0,0},
	{ 0,0,0,0,&fbdriver,0,"fb",0,"tc",0,0,0,0,"",0,fbint0,0,0,0x0,0,0x0,0,0,0,0,0,0,0},
	{ 0,0,0,0,0,0,(char *)0,0,"",0,0,0,0,"",0,0,0,0,0,0,0,0,0,0,0,0,0}
};

/* struct	device_list {	*/
/*	struct device	*nxt_dev;	/* pointer to next dev on this ctlr */
/*	struct controller *ctlr_hd;	/* pointer to ctlr for this device */
/*	char		*dev_type;	/* device type			*/
/*	char		*dev_name;	/* device name			*/
/*	int		logunit;	/* logical unit	number		*/
/*	int		unit;		/* physical unit number		*/
/*	int		ctlr_num;	/* controller number for this device */
/*	char		*ctlr_name;	/* controller name connected to */
/*	int		alive;		/* alive indicator ( -1 if at   */
/*	                                /* nexus, -2 if dead, -4 if     */
/*	                                /* read only, -8 if write only )*/
/*	caddr_t		private[5];	/* reserved for device use	*/
/*	caddr_t		conn_priv[5];	/* Reserved for connected ctlr use*/
/*	caddr_t		rsvd[5];	/* reserved for future expansion */
/* };	*/


struct device device_list[] = {
	{ 0,0,"disk","rz",0,0,"asc",0,0,0,0,0},
	{ 0,0,"disk","rz",1,8,"asc",0,0,0,0,0},
	{ 0,0,"",(char *)0,0,0,"",0,0,0,0,0}
};
