/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	XiePipeInterface.h,v $
 * Revision 1.2.2.3  92/04/06  08:24:43  Gary_Grebus
 * 	Update to XIE VN/ALPHA_BL1 baselevel.
 * 	[92/03/31  10:59:22  Gary_Grebus]
 * 
 * Revision 1.2  91/12/30  12:48:20  devbld
 * 	Initial load of project
 * 
 * $EndLog$
 */
/* BuildSystemHeader added automatically */
/* $Header: /b5/aguws3.0/aguws3.0_rcs/src/dec/extensions/include/XiePipeInterface.h,v 1.2.2.3 92/04/06 08:24:43 Gary_Grebus Exp $ */

/*  DEC/CMS REPLACEMENT HISTORY, Element XIEPIPEINTERFACE.H */
/*  *4     3-SEP-1991 17:44:50 GREBUS "Start changes for compressed data support" */
/*  *3    17-JUN-1991 14:52:20 HENNESSY "Add Macros to handle optimizer support in ProcExecuteFlo path" */
/*  *2    22-FEB-1991 16:14:09 GREBUS "Fixed bug which was passing wrong pointer on non-VMS systems" */
/*  *1    18-FEB-1991 16:50:18 GREBUS "Definitions to access/hide the yielding support" */
/*  DEC/CMS REPLACEMENT HISTORY, Element XIEPIPEINTERFACE.H */

/***********************************************************
Copyright 1989,1991 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/************************************************************************
**
**  FACILITY:
**
**      X Image Extension DIX
**
**  ABSTRACT:
**
**	This module contains the macros which are used to access the
**      the DDX routines needed to create and run pipelines.
**	
**	
**  ENVIRONMENT:
**
**	VAX/VMS V5.4
**	ULTRIX  V4.0
**
**  AUTHOR(S):
**
**      Gary L. Grebus
**
**  CREATION DATE:
**
**      Thu Feb  7 17:05:40 1991
**
************************************************************************/
#ifdef DWV3

/* For DECWindows V3, interpose the layer to support yielding */
extern int 	XieAbortPipeline();
extern Pipe 	XieCreatePipeline();
extern int	XieDestroyPipeline();
extern int	XieFlushPipeline();
extern int      XieInitPipelineInterface();
extern int	XieResumePipeline();

#define AbortPipeline_(flo)		(XieAbortPipeline( flo ))
#define CreatePipeline_(client, flo)	(XieCreatePipeline( client, flo ))
#define DestroyPipeline_(flo)		(XieDestroyPipeline( flo ))
#define FlushPipeline_(flo)		(XieFlushPipeline( flo ))
#define InitiatePipeline_(flo)		(DdxInitiatePipeline_( Pipe_(flo) ))
#define InitPipelineInterface_()        (XieInitPipelineInterface())
#define	OptimizePipeline_(flo)		(DdxOptimizePipe_(Pipe_(flo)))
#define ResumePipeline_(flo) 		(XieResumePipeline( flo ))
#else

/* Everywhere else, call the DDX routines directly */
#define AbortPipeline_(flo)		(DdxAbortPipeline_(Pipe_(flo)))
#define CreatePipeline_(client, flo)	(DdxCreatePipeline_( 0 ))
#define DestroyPipeline_(flo)		(DdxDestroyPipeline_( Pipe_(flo) ))
#define FlushPipeline_(flo)		(DdxFlushPipeline_(Pipe_(flo)))
#define InitiatePipeline_(flo)		(DdxInitiatePipeline_(Pipe_(flo)))
#define InitPipelineInterface_()        (Success) /* Dummy */
#define	OptimizePipeline_(flo)		(DdxOptimizePipe_(Pipe_(flo)))
#define ResumePipeline_(flo) 		(DdxResumePipeline_(Pipe_(flo)))

#endif /* DWV3 */
