(* Copyright (C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* *)
(* Last modified on Tue Oct 27 13:08:04 PST 1992 by steveg *)

(* "XTrestle" checks for X-style "-display" and "-geometry" switches and
   installs a top-level window accordingly. *)

MODULE XTrestle;

<* PRAGMA LL *>
IMPORT Axis, ParseParams, Rect, Scan, StableVBT, Stdio, Trestle,
       TrestleComm, TrestleImpl, VBT, VBTClass, XParam;

PROCEDURE Install (v          : VBT.T;
                   applName   : TEXT    := NIL;
                   inst       : TEXT    := NIL;
                   windowTitle: TEXT    := NIL;
                   iconTitle  : TEXT    := NIL;
                   bgColorR   : REAL    := -1.0;
                   bgColorG   : REAL    := -1.0;
                   bgColorB   : REAL    := -1.0;
                   iconWindow : VBT.T   := NIL   )
  RAISES {TrestleComm.Failure} =
  VAR
    display, geometry: TEXT          := NIL;
    screen                           := 0;
    geoRec           : XParam.GeoRec;
    trsl             : Trestle.T;
  <* FATAL Scan.BadFormat, XParam.Error *>
  BEGIN
    ParseParams.BeginParsing(Stdio.stderr);
    IF ParseParams.KeywordPresent("-display") THEN
      display := ParseParams.GetNext();
      screen := XParam.ParseDisplay(display).screen;
    END;

    IF ParseParams.KeywordPresent("-geometry") THEN
      geometry := ParseParams.GetNext();
      geoRec := XParam.ParseGeometry(geometry);
      IF geoRec.size.h = VBT.DefaultShape.hi
           OR geoRec.size.v = VBT.DefaultShape.hi THEN
        WITH shapes = VBTClass.GetShapes(v, FALSE) DO
          geoRec.size.h := shapes[Axis.T.Hor].pref;
          geoRec.size.v := shapes[Axis.T.Ver].pref;
        END;
      END;
    END;

    trsl := Trestle.Connect(display);
    TrestleImpl.SetDefault(trsl);
    Trestle.Attach(v, trsl);
    Trestle.Decorate(v, inst, windowTitle, iconTitle, bgColorR, bgColorG,
                     bgColorB, applName, iconWindow);

    IF geometry = NIL THEN
      Trestle.MoveNear(v, NIL);
    ELSE
      IF geoRec.size.h # VBT.DefaultShape.hi
           AND geoRec.size.v # VBT.DefaultShape.hi THEN
        StableVBT.SetShape(v, geoRec.size.h, geoRec.size.v);
      END;
      Trestle.Overlap(
        v, screen, Rect.NorthWest(XParam.Position(trsl, screen, geoRec)));
    END;
  END Install;

BEGIN
END XTrestle.

