(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(* Last modified on Fri Jun 12 18:03:29 1992 by mhb                          *)

MODULE CursorFromAscii;

IMPORT AsciiUtil, Cursor, PixmapFromAscii, Rd, Scan, Text, Thread;

<* FATAL Rd.Failure *>

PROCEDURE ReadRGB (rd: Rd.T; which: CHAR): Cursor.RGB
  RAISES {Thread.Alerted, Scan.BadFormat, AsciiUtil.Error, Error} =
  VAR
    bw : Text.T;
    rgb: Cursor.RGB;
  BEGIN
    AsciiUtil.GetReal(rd, "red"   & Text.FromChar(which) & ":", rgb.r);
    AsciiUtil.GetReal(rd, "green" & Text.FromChar(which) & ":", rgb.g);
    AsciiUtil.GetReal(rd, "blue"  & Text.FromChar(which) & ":", rgb.b);
    AsciiUtil.GetReal(rd, "gray"  & Text.FromChar(which) & ":", rgb.gray);
    AsciiUtil.GetText(rd, "bw"    & Text.FromChar(which) & ":", bw);
    IF Text.Equal(bw, "UseBg") THEN
      rgb.bw := Cursor.BW.UseBg
    ELSIF Text.Equal(bw, "UseFg") THEN
      rgb.bw := Cursor.BW.UseFg
    ELSIF Text.Equal(bw, "UseIntensity") THEN
      rgb.bw := Cursor.BW.UseIntensity
    ELSE
      RAISE Error
    END;
    RETURN rgb
  END ReadRGB;

PROCEDURE Read (rd: Rd.T): Cursor.T RAISES {Thread.Alerted, Error} =
  BEGIN
    RETURN Cursor.FromRaw(ReadRaw(rd));
  END Read;

PROCEDURE ReadRaw (rd: Rd.T): Cursor.Raw RAISES {Thread.Alerted, Error} =
  VAR
    r       : Cursor.Raw;
    ignoreMe: Text.T;
  BEGIN
    TRY
      AsciiUtil.Get2Int(rd, "hotspot: ", r.hotspot.h, r.hotspot.v);
      r.color1 := ReadRGB(rd, '1');
      r.color2 := ReadRGB(rd, '2');
      r.color3 := ReadRGB(rd, '3');
      AsciiUtil.GetText(rd, "plane1:", ignoreMe);
      r.plane1 := PixmapFromAscii.ReadRaw(rd);
      AsciiUtil.GetText(rd, "plane2:", ignoreMe);
      r.plane2 := PixmapFromAscii.ReadRaw(rd);
    EXCEPT
      Scan.BadFormat, AsciiUtil.Error, PixmapFromAscii.Error => RAISE Error
    END;
    RETURN r
  END ReadRaw;

BEGIN
END CursorFromAscii.
