(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Mon Aug  3 15:38:48 PDT 1992 by meehan                   *)
(*      modified on Tue Jun 16 12:54:15 PDT 1992 by muller                   *)
(*      modified on Wed Jun  3 08:06:53 1992 by mhb *)
(*      modified on Fri Mar 27 02:20:14 1992 by steveg *)
(*      modified on Mon Feb 11 16:06:46 PST 1991 by brooks *)

(* An "AnyEvent.Code" is an object that can hold any of the
   Trestle event-time events. This object type is useful for "VBT"
   methods that are called in response to multiple styles of user
   gestures. For instance, the "callback" method of a
   "NumericVBT" is invoked either because a user clicked on the
   plus/minus buttons or because the user typed a carriage
   return in the type-in field.  The event is passed to the method
   as a "Code", and the "callback" method can then use
   "TYPECASE" to differentiate button clicks from carriage
   returns, and to retrieve the data specific to each type of
   event. *)

INTERFACE AnyEvent;

IMPORT VBT;

TYPE
  Code = BRANDED OBJECT END;
  KeyCode = Code OBJECT key: VBT.KeyRec END;
  MouseCode = Code OBJECT mouse: VBT.MouseRec END;
  PositionCode = Code OBJECT position: VBT.PositionRec END;
  MiscCode = Code OBJECT misc: VBT.MiscRec END;
(* The four subtypes of "Code" correspond to the four event-time
   events: mouse, position, miscellaneous, and keyboard. *)

PROCEDURE KeyToCode (READONLY event: VBT.KeyRec): KeyCode;
(* Return "event" as a "KeyCode". *)

PROCEDURE MouseToCode (READONLY event: VBT.MouseRec): MouseCode;
(* Return "event" as a "MouseCode". *)

PROCEDURE PositionToCode (READONLY event: VBT.PositionRec):
  PositionCode;
(* Return "event" as a "PositionCode". *)

PROCEDURE MiscToCode (READONLY event: VBT.MiscRec): MiscCode;
(* Return "event" as a "MiscCode". *)

PROCEDURE TimeStamp (code: Code): VBT.TimeStamp;
(* Return the timestamp of the event "code".  It is a checked
   runtime error if "code" is not a proper subtype of "Code". *)

END AnyEvent.

