(* Copyright (C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* *)
(* by Steve Glassman and Stephen Harrison *)
(* Last modified on Fri Jul 24 01:10:20 1992 by steveg *)

<*PRAGMA LL*>

MODULE Scale;

(* Scale provides a filter which automatically rescales its
   contents to fill the window.  Fonts sizes are changed
   to the closest existing size font. *)

IMPORT Axis, Rect, ScaleFilter, VBT, VBTClass;

REVEAL
  T = PublicT BRANDED OBJECT
      OVERRIDES
        reshape := Reshape;
      END;

PROCEDURE Reshape (sf: T; READONLY cd: VBT.ReshapeRec) =
  VAR
    dom := cd.new;
    v   := ScaleFilter.Child(sf);
  BEGIN
    IF NOT Rect.IsEmpty(dom) THEN
      VAR
        sz := VBTClass.GetShapes(v, TRUE);
        sx := FLOAT(Rect.HorSize(dom)) / FLOAT(sz[Axis.T.Hor].pref);
        sy := FLOAT(Rect.VerSize(dom)) / FLOAT(sz[Axis.T.Ver].pref);
      BEGIN
        IF sf.keepAspectRatio THEN sx := MIN(sx, sy); sy := sx; END;
        IF 0.95 > sx OR sx > 1.05 OR 0.95 > sy OR sy > 1.05 THEN
          ScaleFilter.Scale(sf, sx, sy);
        END;
      END;
    END;
    ScaleFilter.T.reshape(sf, cd);
  END Reshape;

BEGIN
END Scale.

