(* Copyright (C) 1992, Digital Equipment Corporation                        *)
(* All rights reserved.                                                     *)
(* See the file COPYRIGHT for a full description.                           *)
(*                                                                          *)
(* Last modified on Sun Aug  9 19:09:56 1992 by meehan                      *)
(*      modified on Tue Jun 16 13:08:57 PDT 1992 by muller                  *)
(*      modified on Mon Jun 15 21:49:45 1992 by mhb                         *)

(* A {\em feedback} is a "VBT" (specifically, a multi-filter) to
   which "normal" and "excited" methods are attached.  Just as
   "MultiClass" implements the attachment of methods to any "VBT"
   to make it a ``multi'', "FeedbackClass" implements the
   attachment of "normal" and "excited" methods to any
   multi-filter to make it a ``feedback''.

   To do this, we create an instance "fc" of "FeedbackClass.T"
   and attach it to a multi-filter "v" by way of "v"'s property
   set.  "fc" points back to "v" via the field "fc.vbt".

   Clients that define their own feedbacks can make a
   multi-filter "v" into a feedback by calling
   "Be(v,fc)" during initialization.

   Some clients export their feedbackclass, e.g.,
   "BorderedFeedbackVBT.FC", and their "init" methods take a
   feedbackclass argument which defaults to "NIL".  By
   convention, this means that the "init" method will use a new
   instance of the exported multiclass, e.g., "NEW(FC)", as the
   feedbackclass.  *)

INTERFACE FeedbackClass;

IMPORT VBT;

TYPE
  T <: Public;
  Public = OBJECT
             vbt  : VBT.T;      (* READONLY *)
             last           := LastCall.Normal;
             state          := FALSE;
           METHODS
             normal  ();
             excited ();
           END;
(* The default methods for "normal" and "excited" are no-ops. *)

TYPE
  LastCall = {Normal, Excited};

PROCEDURE Be (v: VBT.T; fc: T);
(* Make "v" into a "Feedback.T" by storing "fc" in "v"'s property set and
   settting "fc.vbt" equal to "v". The initial state is "FALSE" (``off''). *)

PROCEDURE Resolve (v: VBT.T): T;
(* Return "fc" for which "Be(v,fc)" was previously called.
   Return "NIL" if there is no such "fc". *)

END FeedbackClass.
