(* Copyright (C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* *)
(* by Steve Glassman, Mark Manasse and Greg Nelson *)
(* Last modified on Fri Nov  6 20:05:02 PST 1992 by msm *)
(* modified on Mon Feb 24 13:59:50 PST 1992 by muller *)
(* modified on Wed Nov 20 18:49:31 PST 1991 by gnelson *)

<*PRAGMA LL*>

UNSAFE INTERFACE XScrnTpRep;

IMPORT X, PaintPrivate, Rect, Ctypes, XScreenType;

REVEAL
  XScreenType.T <: Public;

TYPE
  Public = XScreenType.Public OBJECT
             optable: REF ARRAY OF OpRecord;
             pmtable: REF ARRAY OF PixmapRecord;
             empty                                := 0
           END;

  (* If pm is a ScrnPixmap.T whose screentype is st, a T, then pm.id is
     either SolidPixmap, or pm.id is the index into st.pmtable of the
     PixmapRecord describing pm, unless st.bits = st, in which case
     SolidPixmap - pm.id is the index in st.bits.pmtable. *)

  OpRecord = RECORD
               function, fill_style              : Ctypes.Int;
               plane_mask, foreground, background: Ctypes.UnsignedLong;
             END;

  PixmapRecord = RECORD
                   pixmap: X.Pixmap;
                   domain: Rect.T;
                   depth : INTEGER
                 END;

CONST SolidPixmap: PaintPrivate.Pixmap = -1;

END XScrnTpRep.

