(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* by Steve Glassman, Mark Manasse and Greg Nelson           *)
(* Last modified on Mon Feb 24 13:57:05 PST 1992 by muller   *)
(*      modified on Tue Oct 22 21:34:39 PDT 1991 by gnelson  *)
(*      modified on Wed Sep 11 15:22:49 PDT 1991 by msm      *)
<*PRAGMA LL*>

MODULE Font;

IMPORT Palette, ScrnFont, ScreenType, TrestleComm;

TYPE TextList = REF ARRAY OF TEXT;

PROCEDURE FromName(READONLY names: ARRAY OF TEXT): T =
  VAR tl := NEW(TextList, NUMBER(names)); BEGIN 
    FOR i := 0 TO LAST(names) DO tl[i] := names[i] END;
    RETURN Palette.FromFontClosure(NEW(Closure, names := tl))
  END FromName;

TYPE Closure = Palette.FontClosure OBJECT
    names: TextList;
  OVERRIDES
    apply := Apply
  END;

PROCEDURE Apply(cl: Closure; st: ScreenType.T): ScrnFont.T =
  BEGIN
    FOR i := FIRST(cl.names^) TO LAST(cl.names^) DO
      TRY
        RETURN st.font.lookup(cl.names[i])
      EXCEPT
        TrestleComm.Failure, ScrnFont.Failure => (*skip*)
      END
    END;
    RETURN Palette.ResolveFont(st, BuiltIn)
  END Apply;
  
BEGIN END Font.
