(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Mon Feb 24 13:51:00 PST 1992 by muller  *)
(*      modified on Mon Aug 12 14:29:26 PDT 1991 by gnelson *)
<*PRAGMA LL*>

(* Cross-address space filter VBTs.

   A cross-address space "VBT" is a filter in which the parent and child
   are in different address spaces. The filter has no effect except to
   transport events between the address spaces. For example, the ivy
   text editor can use cross-address space "VBTs" to manage text
   subwindows of applications in other address spaces.

   The child side of a cross address space filter applies "ToRemote"
   to its provider, and passes the resulting "Remote" to the parent
   address space as a network object.  The parent side passes the "Remote"
   to "FromRemote" to obtain the parent side of the provider.  
    *)
   
INTERFACE VBTProvider;
   
IMPORT VBT;

EXCEPTION Error(TEXT);

TYPE
  T = OBJECT METHODS apply(TEXT): VBT.T RAISES {Error};
  Remote <: ROOT;
  (* A "Remote" is an pure object type that can be passed or exported
     as a network object. *)

  (* The locking level of an apply method is VBT.mu.  The VBT.mu's for
     the different address spaces are ordered so that
  
      parent space VBT.mu < child space VBT.mu .
      
   Clients must avoid using cross-address space filters in a way that 
   would produce a cycle in this order.  *)

PROCEDURE ToRemote(provider: T): Remote;

PROCEDURE FromRemote(r: Remote): T RAISES {Error};

END VBTProvider.

    

