# include "stdio.h"
# define U(x) ((x)&0377)
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX 200
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin ={stdin}, *yyout ={stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;

        /* Copyright (C) 1989, Digital Equipment Corporation           */
	/* All rights reserved.                                        */
	/* See the file COPYRIGHT for a full description.              */

 	/* Last modified on Thu Apr 23 18:08:06 PDT 1992 by muller           */
 	/*      modified on Mon Apr 20 15:59:06 1992 by nichols@xerox.com    */
	/*      modified on Mon Nov 25 17:41:09 PST 1991 by meehan           */
	/*      modified on Thu Nov  2 18:18:07 1989 by kalsow               */


	/* The routine  AddLexLength  is called by every lexical */
	/* augment, in order to keep track of the number of */
	/* characters that have been read.  It simply adds */
	/* the length of  yytext  to the accumulated count in  lexposition, */
	/* which is declared in pp.yacc . */
	/* It also tracks the current column the input is in for comment */
	/* processing. */

	int currentCol = 0;	/* current column of input */

	AddLexLength ()
	{
	  register int i;

	  for (i = 0; i < yyleng; ++i)
	      AddChar(yytext[i]);
	  if (yyleng >= lexbufsize) {
	    fprintf (stderr, "Lex buffer overflow in pretty-printer\n");
	    exit(-1); }
	}

	AddChar(c)
	    char c;
	{
	  ++lexposition;
	  switch(c) {
	    case '\n':
	      currentCol = 0;
	      break;
	    case '\t':
	      /* Round up to next tab stop. */
	      currentCol = (currentCol + 8) & ~7;
	      break;
	    default:
	      ++currentCol;
	      break;
	  }
	}

/* The routine BufferLexeme is used to copy a lexeme into */	
/* the buffer declared in pp.yacc (which see) where it can */
/* be accessed by the parser actions. */

BufferLexeme (addLength)
int addLength;
{ 
	if (addLength) AddLexLength();
	lexptr = lexbufsize - lexptr;
	yylval = lexptr;
	strcpy (lexbuf + lexptr, yytext);
}

/* The routine CapBufferLexeme is like BufferLexeme, but it
 capitalizes as it copies. */

CapBufferLexeme (addLength)
int addLength;
{ 
	char *p, *q = yytext;

	if (addLength) AddLexLength();
	lexptr = lexbufsize - lexptr;
	yylval = lexptr;
	p = lexbuf + lexptr;
	while (*p++ = toupper (*q++)) ;
}


/* The NPS information is saved in the comments array.  Elements 0 to
   nComments-1 refer to top-level comments or pragmas.  The NLs, startCol,
   and text fields are valid for them.  comments[nComments] contains only a
   newline count, giving the number of newlines after the final comment. */
struct Comment {
    int NLs;			/* number of newlines before this comment */
    int startCol;		/* start column of the comment */
    char *text;			/* text of the comment; NULL if none */
    long save;			/* temp */
};
struct Comment *comments = NULL;
int nComments = 0;
int nCommentsAlloced = 0;
static char *commText;		/* the text of the comments goes here */
static char *commTextPtr;	/* pointer to next available char */
static char *commTextLimit;

/* Make sure we have enough comment space allocated. */
static AllocComments(n)
{
    extern char *malloc();
    extern char *realloc();

    if (nCommentsAlloced == 0) {
	nCommentsAlloced = n+10;
	comments = (struct Comment *)
	    malloc(nCommentsAlloced * sizeof(*comments));
	/* Also allocate room for text. */
	commText = malloc(4096);
	commTextLimit = commText + 4096;
    }
    else if (nCommentsAlloced < n) {
	nCommentsAlloced = n+10;
	comments = (struct Comment *)
	    realloc(comments, nCommentsAlloced * sizeof(*comments));
    }
}

static char commentChar;	/* '(' or '<' */
static int commentLevel;	/* nesting level */

/* Called when a comment is started, either at top-level or nested. */
static StartComment(c)
    char c;
{
    if (commentLevel == 0) {
	/* Starting a top-level comment.  Need to allocate two more than
	   what we have now: one for the new comment, and one for the extra
	   newline count we keep in comments[nComments]. */
	AllocComments(nComments+2);
	comments[nComments].startCol = currentCol;
	comments[nComments].text = commTextPtr;
	++nComments;
	comments[nComments].NLs = 0;
    }
    ++commentLevel;
    commentChar = c;
}

static EndComment()
{
   if (commentLevel == 1)
       SaveChar(0);		/* finish off the text. */
   --commentLevel;
}

/* Save a char in the current comment (if any) and also count it for lex
   position and current column. */
static SaveChar(c)
    char c;
{
    if (c != 0)
	AddChar(c);
    if (commentLevel > 0) {
	if (commTextPtr >= commTextLimit) {
	    int i;
            long oldSize = commTextLimit - commText;
	    long newSize = oldSize + 4096;
	    /* Need to realloc the text.  We first save all the pointers as
	       offsets, do the realloc, then reset the pointers. */
	    for (i = 0; i < nComments; ++i)
		comments[i].save = comments[i].text - commText;
	    commText = realloc(commText, newSize);
	    commTextLimit = commText + newSize;
	    commTextPtr = commText + oldSize;
	    for (i = 0; i < nComments; ++i)
		comments[i].text = commText + comments[i].save;
	}
	*commTextPtr++ = c;
    }
}

static int IsWhite(c)
    register char c;
{
    return c == ' ' || c == '\t' || c == '\f' || c == '\n' || c == '\r';
}

/* Handle a "non-program-sequence."  This is a sequence of whitespace,
   comments and pragmas.  We only remember newlines, comments, and pragmas
   in the stuff we send to the parser.  The start column of the comments
   and pragmas are remembered in case the comment requests no formatting.

   When we arrive, the first character of whitespace or comment is in
   yytext, and we're responsible for taking care of the rest. */
HandleNPS ()
{
    register char c, c2;
    char target;
    int tok;
    char *p;
    /* Magic variable to tell us we found a special pragma last time. */
    static int pragmaToken = -1;

    if (pragmaToken != -1) {
	int tok = pragmaToken;
	pragmaToken = -1;
	input();		/* parse the '*' we pushed back. */
	/* Copy the comment into the normal token buffer. This assumes
	   lexbufsize > sizeof(yytext), but the code above assumes that,
	   anyway. */
	strcpy(yytext, comments[nComments].text);
	BufferLexeme(0);
	return tok;
    }
    commentLevel = 0;
    AllocComments(2);
    commTextPtr = commText;
    nComments = 0;
    comments[0].NLs = 0;
    /* Now deal with the main loop. */
    c = yytext[0];
    do {
	/* Check for a comment start whether we're in or out of a comment. */
	if ((commentLevel == 0 && (c == '(' || c == '<')) ||
	    (commentLevel > 0 && c == commentChar)) {
	    c2 = input();
	    if (c2 == '*') {
		StartComment(c);
		SaveChar(c);
		SaveChar(c2);
	    }
	    else if (commentLevel == 0) {
		unput(c2);
		unput(c);
		return WHITESPACE;
	    }
	    else {
		unput(c2);
		SaveChar(c);
	    }
	}
	/* Not in comment: check for newline or non-whitespace. */
	else if (commentLevel == 0) {
	    if (!IsWhite(c)) {
		unput(c);
		return WHITESPACE;
	    }
	    if (c == '\n')
		++comments[nComments].NLs;
	    SaveChar(c);
	}
	/* In comment: check for comment end. */
	else {
	    SaveChar(c);
	    if (c == '*') {
		c2 = input();
		target = commentChar == '(' ? ')' : '>';
		if (c2 == target) {
		    SaveChar(c2);
		    EndComment();
		    /* Check to see if this pragma is one of the ones we
		       return special tokens for.  We don't return them for
		       all pragmas since some can appear anywhere in a
		       program.  If this pragma matches, then return it (if
		       it's the first thing we saw) or push it back and
		       return whitespace.  Ugh.
		    
		    We also make sure the pragma isn't too large to fit in
		       our normal token buffer.  If it is, we give up and
		       treat it as a comment. */
		    if (commentLevel == 0 && (tok = CheckPragma()) != -1
			&& strlen(comments[0].text) < lexbufsize - 1) {
			/* Save it for next time. */
			--nComments;
			currentCol = comments[nComments].startCol;
			pragmaToken = tok;
			/* Now push back "<*" so the lexer will call us
			   next time. */
			unput('*');
			unput('<');
			return WHITESPACE;
		    }
		}
		else
		    unput(c2);
	    }
	}
    } while ((c = input()) != 0 /* EOF */);
    return WHITESPACE;
}

struct PragmaEntry {
    char *name;
    int len;
    int token;
};
static struct PragmaEntry pragmaTable[] = {
    "EXTERNAL", 8, PR_EXTERNAL,
    "INLINE", 6, PR_INLINE,
    "OBSOLETE", 8, PR_OBSOLETE,
    "UNUSED", 6, PR_UNUSED,
    NULL, 0, -1
};


/* See if the last pragma was one of our special ones. */
int 
CheckPragma()
{
    char *p = comments[nComments - 1].text;
    struct PragmaEntry *pe;
    int c;

    if (*p != '<')
	return -1;
    p += 2;
    while (IsWhite(*p))
	++p;
    for (pe = pragmaTable; pe->name != NULL; ++pe) {
	if (strncmp(p, pe->name, pe->len) == 0 &&
	    ((c = p[pe->len]) == '*' || IsWhite(c)))
	    return pe->token;
    }
    return -1;
}

# define Prog 2
# define Com 4
# define Prag 6
# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
	{ return (HandleNPS()); }
break;
case 2:
	{ return (HandleNPS()); }
break;
case 3:
{ return (HandleNPS()); }
break;
case 4:
	{BufferLexeme(1); return(PLUS);}
break;
case 5:
	{BufferLexeme(1); return(MINUS);}
break;
case 6:
	{BufferLexeme(1); return(ASTERISK);}
break;
case 7:
	{BufferLexeme(1); return(SLASH);}
break;
case 8:
	{BufferLexeme(1); return(ASSIGN);}
break;
case 9:
	{BufferLexeme(1); return(AMPERSAND);}
break;
case 10:
	{BufferLexeme(1); return(DOT);}
break;
case 11:
	{BufferLexeme(1); return(COMMA);}
break;
case 12:
	{BufferLexeme(1); return(SEMICOLON);}
break;
case 13:
	{BufferLexeme(1); return(LPAREN);}
break;
case 14:
	{BufferLexeme(1); return(LBRACKET);}
break;
case 15:
	{BufferLexeme(1); return(LBRACE);}
break;
case 16:
	{BufferLexeme(1); return(UPARROW);}
break;
case 17:
	{BufferLexeme(1); return(EQUAL);}
break;
case 18:
	{BufferLexeme(1); return(RARROW);}
break;
case 19:
	{BufferLexeme(1); return(SHARP);}
break;
case 20:
	{BufferLexeme(1); return(LESS);}
break;
case 21:
	{BufferLexeme(1); return(GREATER);}
break;
case 22:
	{BufferLexeme(1); return(LSEQUAL);}
break;
case 23:
	{BufferLexeme(1); return(SUBTYPE);}
break;
case 24:
	{BufferLexeme(1); return(GREQUAL);}
break;
case 25:
	{BufferLexeme(1); return(DOTDOT);}
break;
case 26:
	{BufferLexeme(1); return(COLON);}
break;
case 27:
	{BufferLexeme(1); return(RPAREN);}
break;
case 28:
	{BufferLexeme(1); return(RBRACKET);}
break;
case 29:
	{BufferLexeme(1); return(RBRACE);}
break;
case 30:
	{BufferLexeme(1); return(BAR);}
break;
case 31:
{PTRKEYWORDENTRY tempp;
				 if ((tempp=lookup(yytext))!=NULL){
				        CapBufferLexeme(1);
					return(tempp->lexval);}
				 else {BufferLexeme(1); return(IDENT);}}
break;
case 32:
       {BufferLexeme(1); return(CARD_CONST);}
break;
case 33:
{BufferLexeme(1); return(REAL_CONST);}
break;
case 34:
{
				 BufferLexeme(1); return(STR_CONST);}
break;
case 35:
{
				 BufferLexeme(1); return(STR_CONST);}
break;
case 36:
{
	BufferLexeme(0);
	/* Due to bison bug, we return 0 explicitly instead of ENDOFFILE. */
	return(0);
	}
break;
case 37:
{BufferLexeme(0);return(MODUNIT);}
break;
case 38:
{BufferLexeme(0);return(DEFUNIT);}
break;
case 39:
	{BufferLexeme(1); return(BAD);}
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */
int yyvstop[] ={
0,

36,
39,
0,

37,
39,
0,

39,
0,

38,
39,
0,

3,
39,
0,

3,
0,

3,
39,
0,

39,
0,

19,
39,
0,

9,
39,
0,

39,
0,

13,
39,
-1,
0,

27,
39,
0,

6,
39,
0,

4,
39,
0,

11,
39,
0,

5,
39,
0,

10,
39,
0,

7,
39,
0,

32,
39,
0,

26,
39,
0,

12,
39,
0,

20,
39,
-2,
0,

17,
39,
0,

21,
39,
0,

31,
39,
0,

14,
39,
0,

28,
39,
0,

16,
39,
0,

15,
39,
0,

30,
39,
0,

29,
39,
0,

37,
0,

38,
0,

34,
0,

35,
0,

1,
0,

25,
0,

-33,
0,

32,
0,

8,
0,

2,
0,

23,
0,

22,
0,

18,
0,

24,
0,

31,
0,

33,
0,

33,
-33,
0,

33,
0,

32,
0,

-33,
0,

33,
-33,
0,
0};
# define YYTYPE unsigned char
struct yywork { YYTYPE verify, advance; } yycrank[] ={
0,0,	0,0,	1,9,	1,10,	
1,11,	44,0,	1,12,	47,0,	
0,0,	0,0,	1,13,	1,14,	
0,0,	0,0,	44,0,	0,0,	
47,0,	0,0,	49,0,	0,0,	
14,41,	0,0,	46,0,	14,42,	
0,0,	0,0,	0,0,	49,47,	
14,43,	0,0,	0,0,	46,44,	
0,0,	1,15,	0,0,	1,16,	
1,17,	45,44,	0,0,	1,18,	
1,19,	1,20,	1,21,	1,22,	
1,23,	1,24,	1,25,	1,26,	
1,27,	1,28,	14,43,	20,50,	
26,51,	48,47,	31,56,	46,44,	
49,47,	63,0,	0,0,	1,29,	
1,30,	1,31,	1,32,	1,33,	
29,55,	32,59,	1,34,	33,60,	
0,0,	1,34,	31,57,	0,0,	
1,34,	31,58,	2,17,	0,0,	
0,0,	2,18,	0,0,	2,20,	
2,21,	2,22,	0,0,	2,24,	
2,25,	67,0,	2,27,	67,68,	
0,0,	1,34,	0,0,	0,0,	
1,35,	1,11,	1,36,	1,37,	
1,11,	2,29,	2,30,	2,31,	
2,32,	2,33,	0,0,	0,0,	
0,0,	0,0,	0,0,	67,62,	
0,0,	49,47,	0,0,	3,17,	
0,0,	46,44,	3,18,	0,0,	
3,20,	3,21,	3,22,	0,0,	
3,24,	3,25,	0,0,	3,27,	
1,38,	1,39,	1,40,	67,62,	
0,0,	0,0,	2,35,	0,0,	
2,36,	2,37,	3,29,	3,30,	
3,31,	3,32,	3,33,	68,0,	
0,0,	68,68,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
4,17,	0,0,	0,0,	4,18,	
0,0,	4,20,	4,21,	4,22,	
0,0,	4,24,	4,25,	0,0,	
4,27,	68,62,	2,38,	2,39,	
2,40,	0,0,	0,0,	3,35,	
0,0,	3,36,	3,37,	4,29,	
4,30,	4,31,	4,32,	4,33,	
0,0,	0,0,	0,0,	0,0,	
0,0,	68,62,	0,0,	0,0,	
0,0,	5,17,	0,0,	0,0,	
5,18,	0,0,	5,20,	5,21,	
5,22,	0,0,	5,24,	5,25,	
0,0,	5,27,	0,0,	3,38,	
3,39,	3,40,	0,0,	0,0,	
4,35,	0,0,	4,36,	4,37,	
5,29,	5,30,	5,31,	5,32,	
5,33,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	6,17,	0,0,	
0,0,	6,18,	0,0,	6,20,	
6,21,	6,22,	0,0,	6,24,	
6,25,	0,0,	6,27,	0,0,	
4,38,	4,39,	4,40,	0,0,	
0,0,	5,35,	0,0,	5,36,	
5,37,	6,29,	6,30,	6,31,	
6,32,	6,33,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	7,17,	
0,0,	0,0,	7,18,	0,0,	
7,20,	7,21,	7,22,	0,0,	
7,24,	7,25,	0,0,	7,27,	
0,0,	5,38,	5,39,	5,40,	
0,0,	0,0,	6,35,	0,0,	
6,36,	6,37,	7,29,	7,30,	
7,31,	7,32,	7,33,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
8,17,	0,0,	0,0,	8,18,	
0,0,	8,20,	8,21,	8,22,	
0,0,	8,24,	8,25,	0,0,	
8,27,	0,0,	6,38,	6,39,	
6,40,	0,0,	0,0,	7,35,	
0,0,	7,36,	7,37,	8,29,	
8,30,	8,31,	8,32,	8,33,	
0,0,	16,0,	16,44,	16,44,	
0,0,	16,44,	0,0,	0,0,	
0,0,	16,44,	16,0,	19,0,	
19,47,	19,47,	0,0,	19,47,	
0,0,	0,0,	0,0,	19,47,	
19,0,	0,0,	0,0,	7,38,	
7,39,	7,40,	0,0,	0,0,	
8,35,	0,0,	8,36,	8,37,	
16,44,	0,0,	16,45,	0,0,	
0,0,	0,0,	0,0,	16,44,	
0,0,	0,0,	19,47,	16,44,	
19,47,	0,0,	16,44,	0,0,	
16,44,	19,48,	0,0,	0,0,	
0,0,	19,47,	0,0,	0,0,	
19,47,	0,0,	19,47,	0,0,	
8,38,	8,39,	8,40,	0,0,	
0,0,	16,44,	0,0,	0,0,	
16,44,	0,0,	0,0,	16,44,	
0,0,	0,0,	0,0,	19,47,	
0,0,	0,0,	19,47,	0,0,	
0,0,	19,47,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
16,44,	0,0,	0,0,	0,0,	
16,46,	0,0,	0,0,	16,44,	
0,0,	0,0,	19,47,	0,0,	
0,0,	0,0,	19,49,	0,0,	
28,52,	19,47,	28,53,	28,53,	
28,53,	28,53,	28,53,	28,53,	
28,53,	28,53,	28,53,	28,53,	
64,66,	0,0,	64,66,	0,0,	
0,0,	64,67,	64,67,	64,67,	
64,67,	64,67,	64,67,	64,67,	
64,67,	64,67,	64,67,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	34,61,	34,61,	34,61,	
34,61,	34,61,	34,61,	34,61,	
34,61,	34,61,	34,61,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	28,54,	34,61,	34,61,	
34,61,	34,61,	34,61,	34,61,	
34,61,	34,61,	34,61,	34,61,	
34,61,	34,61,	34,61,	34,61,	
34,61,	34,61,	34,61,	34,61,	
34,61,	34,61,	34,61,	34,61,	
34,61,	34,61,	34,61,	34,61,	
0,0,	0,0,	0,0,	0,0,	
34,61,	0,0,	34,61,	34,61,	
34,61,	34,61,	34,61,	34,61,	
34,61,	34,61,	34,61,	34,61,	
34,61,	34,61,	34,61,	34,61,	
34,61,	34,61,	34,61,	34,61,	
34,61,	34,61,	34,61,	34,61,	
34,61,	34,61,	34,61,	34,61,	
52,62,	52,62,	52,62,	0,0,	
52,62,	0,0,	0,0,	0,0,	
52,62,	52,62,	66,67,	66,67,	
66,67,	66,67,	66,67,	66,67,	
66,67,	66,67,	66,67,	66,67,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	52,62,	
0,0,	52,62,	0,0,	0,0,	
0,0,	0,0,	52,62,	0,0,	
0,0,	0,0,	52,62,	0,0,	
0,0,	52,0,	0,0,	52,63,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	54,65,	54,65,	
54,65,	54,65,	54,65,	54,65,	
54,65,	54,65,	54,65,	54,65,	
52,62,	0,0,	0,0,	52,64,	
0,0,	0,0,	52,62,	54,65,	
54,65,	54,65,	54,65,	54,65,	
54,65,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	52,64,	
0,0,	0,0,	0,0,	52,62,	
0,0,	0,0,	52,62,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	54,65,	
54,65,	54,65,	54,65,	54,65,	
54,65,	0,0,	0,0,	0,0,	
0,0};
struct yysvf yysvec[] ={
0,	0,	0,
yycrank+-1,	0,		0,	
yycrank+-39,	yysvec+1,	0,	
yycrank+-76,	yysvec+1,	0,	
yycrank+-113,	yysvec+1,	0,	
yycrank+-150,	yysvec+1,	0,	
yycrank+-187,	yysvec+1,	0,	
yycrank+-224,	yysvec+1,	0,	
yycrank+-261,	yysvec+1,	0,	
yycrank+0,	0,		yyvstop+1,
yycrank+0,	0,		yyvstop+4,
yycrank+0,	0,		yyvstop+7,
yycrank+0,	0,		yyvstop+9,
yycrank+0,	0,		yyvstop+12,
yycrank+18,	0,		yyvstop+15,
yycrank+0,	yysvec+14,	yyvstop+17,
yycrank+-324,	0,		yyvstop+20,
yycrank+0,	0,		yyvstop+22,
yycrank+0,	0,		yyvstop+25,
yycrank+-334,	0,		yyvstop+28,
yycrank+9,	0,		yyvstop+30,
yycrank+0,	0,		yyvstop+34,
yycrank+0,	0,		yyvstop+37,
yycrank+0,	0,		yyvstop+40,
yycrank+0,	0,		yyvstop+43,
yycrank+0,	0,		yyvstop+46,
yycrank+6,	0,		yyvstop+49,
yycrank+0,	0,		yyvstop+52,
yycrank+382,	0,		yyvstop+55,
yycrank+3,	0,		yyvstop+58,
yycrank+0,	0,		yyvstop+61,
yycrank+12,	0,		yyvstop+64,
yycrank+3,	0,		yyvstop+68,
yycrank+6,	0,		yyvstop+71,
yycrank+413,	0,		yyvstop+74,
yycrank+0,	0,		yyvstop+77,
yycrank+0,	0,		yyvstop+80,
yycrank+0,	0,		yyvstop+83,
yycrank+0,	0,		yyvstop+86,
yycrank+0,	0,		yyvstop+89,
yycrank+0,	0,		yyvstop+92,
yycrank+0,	0,		yyvstop+95,
yycrank+0,	0,		yyvstop+97,
yycrank+0,	yysvec+14,	0,	
yycrank+-4,	yysvec+16,	0,	
yycrank+3,	0,		yyvstop+99,
yycrank+-21,	yysvec+16,	0,	
yycrank+-6,	yysvec+19,	0,	
yycrank+14,	0,		yyvstop+101,
yycrank+-17,	yysvec+19,	0,	
yycrank+0,	0,		yyvstop+103,
yycrank+0,	0,		yyvstop+105,
yycrank+-535,	0,		yyvstop+107,
yycrank+0,	yysvec+28,	yyvstop+109,
yycrank+542,	0,		0,	
yycrank+0,	0,		yyvstop+111,
yycrank+0,	0,		yyvstop+113,
yycrank+0,	0,		yyvstop+115,
yycrank+0,	0,		yyvstop+117,
yycrank+0,	0,		yyvstop+119,
yycrank+0,	0,		yyvstop+121,
yycrank+0,	yysvec+34,	yyvstop+123,
yycrank+0,	0,		yyvstop+125,
yycrank+-11,	yysvec+52,	yyvstop+127,
yycrank+397,	0,		yyvstop+130,
yycrank+0,	yysvec+54,	yyvstop+132,
yycrank+498,	0,		0,	
yycrank+-39,	yysvec+52,	yyvstop+134,
yycrank+-93,	yysvec+52,	yyvstop+136,
0,	0,	0};
struct yywork *yytop = yycrank+644;
struct yysvf *yybgin = yysvec+1;
char yymatch[] ={
00  ,01  ,02  ,03  ,03  ,05  ,03  ,03  ,
03  ,011 ,012 ,03  ,011 ,011 ,03  ,03  ,
03  ,03  ,03  ,03  ,03  ,03  ,03  ,03  ,
03  ,03  ,03  ,03  ,03  ,03  ,03  ,03  ,
' ' ,03  ,'"' ,03  ,03  ,03  ,03  ,047 ,
03  ,03  ,03  ,'+' ,03  ,'+' ,'.' ,03  ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'0' ,'0' ,03  ,03  ,03  ,03  ,03  ,03  ,
03  ,'A' ,'A' ,'A' ,'D' ,'D' ,'A' ,'G' ,
'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,
'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,
'X' ,'G' ,'G' ,03  ,0134,03  ,03  ,'_' ,
03  ,'A' ,'A' ,'A' ,'D' ,'D' ,'A' ,'G' ,
'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,
'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,
'X' ,'G' ,'G' ,03  ,03  ,03  ,03  ,03  ,
03  ,03  ,03  ,03  ,03  ,03  ,03  ,03  ,
03  ,03  ,03  ,03  ,03  ,03  ,03  ,03  ,
03  ,03  ,03  ,03  ,03  ,03  ,03  ,03  ,
03  ,03  ,03  ,03  ,03  ,03  ,03  ,03  ,
03  ,03  ,03  ,03  ,03  ,03  ,03  ,03  ,
03  ,03  ,03  ,03  ,03  ,03  ,03  ,03  ,
03  ,03  ,03  ,03  ,03  ,03  ,03  ,03  ,
03  ,03  ,03  ,03  ,03  ,03  ,03  ,03  ,
03  ,03  ,03  ,03  ,03  ,03  ,03  ,03  ,
03  ,03  ,03  ,03  ,03  ,03  ,03  ,03  ,
03  ,03  ,03  ,03  ,03  ,03  ,03  ,03  ,
03  ,03  ,03  ,03  ,03  ,03  ,03  ,03  ,
03  ,03  ,03  ,03  ,03  ,03  ,03  ,03  ,
03  ,03  ,03  ,03  ,03  ,03  ,03  ,03  ,
03  ,03  ,03  ,03  ,03  ,03  ,03  ,03  ,
03  ,03  ,03  ,03  ,03  ,03  ,03  ,03  ,
0};
char yyextra[] ={
0,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,0,0,0,0,0,0,
0};
/*	ncform	4.1	83/08/11	*/

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank){		/* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"unsigned char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
