(********
Return-Path: jm13@gte.com
Received: by jumbo.pa.dec.com; id AA26833; Wed, 8 Apr 92 09:22:05 -0700
Received: by mts-gw.pa.dec.com; id AA07201; Wed, 8 Apr 92 09:22:01 -0700
Received: from bermuda by bunny.gte.com (5.61/GTEL2.19)id AA23627; Wed, 8 Apr 92 12:21:58 -0400
Received: from localhost by bermuda.gtel.com (4.1/SMI-4.1)id AA14808; Wed, 8 Apr 92 12:22:11 EDT
Message-Id: <9204081622.AA14808@bermuda.gtel.com>
To: kalsow
Subject: Re: "type not found" error reading in pickles (M3 2.04, Sparc 2) 
In-Reply-To: kalsow@src.dec.com on Fri, Apr 3, 1992
Date: Wed, 08 Apr 92 12:22:10 -0400
From: Joe Morrison <jm13@gte.com>

Hello! 

> I don't know why your program isn't working.  Nobody else has reported
> the bug.  It sounds like something in RTTypeFP isn't working correctly.
> If you examine RT0u.types[*].fpInfo^ after writing a pickle and then
> again just before PklRead.ReadTypes dies, you may be able to see what's
> wrong.  Is PklRead.ReadTypes failing on the first type is trys (ltc = 0)?

Yes, it always fails on the first type. We are still working on this,
but for your interest, we've now produced a relatively small piece of
code that exhibits the bug (included below). We'll keep you posted...

- Joe Morrison and Farshad Nayeri

------------------------------ cut here ------------------------------
***************)

(*
  This program is to demonstrate a bug we have encountered in our use
  of Modula-3 (version 2.04 on SPARCstation 2, Sunos 4.1.1).

  When you run this program, you will be prompted for a command.
  Typing "w" pickles a TEXT string into the file "foo". Typing "r"
  reads the pickle. Typing "h" writes the TEXT string into a dummy
  file (called "hackfile") and THEN tries to read the pickle. Type
  Ctrl-D to end the session.

  To exhibit the bug, do the following:

    Session 1: w
    Session 2: r
      On our system, this produces the message "Pkl error: unknown type".

  Here are some other scenarios, for interest:

    Session 1: w, r
      This works, without any problem.

    Session 1: w
    Session 2: r, h
      As expected, the first read generates the error, then the read
      with the hack (writing to the dummy file) works correctly!

  We are sure that this will all work fine on your system; it's just
  that we have gremlins or something :-)
*)

MODULE Main;

IMPORT Rd, Stdio, Text, Wr, FileStream, Pkl, Thread, RTTypeFP, Fmt;

PROCEDURE Write () RAISES ANY =
    VAR f := FileStream.OpenWrite ("foo");
    BEGIN
        Pkl.Write ("teststring", f);
        Wr.Close (f);
    END Write;

PROCEDURE Read (): REFANY RAISES ANY =
    VAR
        f := FileStream.OpenRead ("foo");
        t := Pkl.Read (f);
    BEGIN
        Rd.Close (f);
        RETURN t;
    END Read;

PROCEDURE WriteFP () RAISES ANY =
    VAR tc := TYPECODE ("teststring");
    VAR fp := RTTypeFP.ToFingerprint (tc);
    BEGIN
        DumpFP (tc, fp);
    END WriteFP;

PROCEDURE ReadFP () RAISES ANY =
    VAR fp := RTTypeFP.Fingerprint { 16_894bdc4d , 16_74d6ded1 };
    VAR tc := RTTypeFP.FromFingerprint (fp);
    BEGIN
        DumpFP (tc, fp);
    END ReadFP;

PROCEDURE DumpFP (tc: RTTypeFP.Typecode;  READONLY fp: RTTypeFP.Fingerprint)
    RAISES ANY =
    BEGIN
        Wr.PutText (Stdio.stdout, "TYPECODE:  ");
        Wr.PutText (Stdio.stdout, Fmt.Int (tc));
        Wr.PutText (Stdio.stdout, "  fingerprint:");
        FOR i := FIRST (fp) TO LAST (fp) DO
          Wr.PutText (Stdio.stdout, " 0x");
          Wr.PutText (Stdio.stdout, Fmt.Unsigned (fp[i], 16));
        END;
        Wr.PutText (Stdio.stdout, "\n");
    END DumpFP;

PROCEDURE ReadHack (): REFANY RAISES ANY =
    VAR g := FileStream.OpenWrite ("hackfile");
    BEGIN
        Pkl.Write ("teststring", g);
        Wr.Close (g);
        RETURN Read ();
    END ReadHack;

PROCEDURE Main () =
    <* FATAL Wr.Failure, Thread.Alerted *>
    VAR t: TEXT;
    BEGIN
        LOOP
            TRY
                Wr.PutText (Stdio.stdout, "Command (w = write, r = read, h = read with hack): ");
                Wr.Flush (Stdio.stdout);
                t := Rd.GetLine (Stdio.stdin);
                IF Text.Equal (t, "w") THEN      Write ();
                ELSIF Text.Equal (t, "r") THEN   EVAL Read ();
                ELSIF Text.Equal (t, "h") THEN   EVAL ReadHack ();
                ELSIF Text.Equal (t, "W") THEN   WriteFP ();
                ELSIF Text.Equal (t, "R") THEN   ReadFP ();
                ELSE  Wr.PutText (Stdio.stdout, "Bad command; try again.\n");
                END;
            EXCEPT

            | Rd.EndOfFile =>
                Wr.PutText (Stdio.stdout, "\n");
                EXIT;

            | Pkl.Error (code) =>
                CASE code OF
                | Pkl.Code.UnknownType => Wr.PutText (Stdio.stdout, "Pkl error: unknown type\n");
                ELSE                      Wr.PutText (Stdio.stdout, "Pkl error: one of the other errors\n");
                END;

            ELSE Wr.PutText (Stdio.stdout, "Error: UNKNOWN EXCEPTION\n");
            END;
        END;
    END Main;

BEGIN
    Main ();
END Main.
