(* Copyright 1992 Digital Equipment Corporation.           *)
(* Distributed only by permission.                         *)
(* Last modified on Wed Aug  5 11:36:26 PDT 1992 by karsenty   *)
(*      modified on Tue Aug  4 15:13:35 PDT 1992 by karlin     *)
(*      modified on Wed Jul 22 01:10:06 1992 by mhb        *)

MODULE MFLegendView;

IMPORT MaxflowViewClass, GraphVBT, R2, MFViews, Filter, TextVBT,
       View, ZeusPanel, Graph, MFAlgs, VBT, MaxflowIE, Rect, Font;

TYPE
  T = MaxflowViewClass.T BRANDED OBJECT
        gvbt: GraphVBT.T;
      OVERRIDES
        startrun := Startrun;
        oeSetup := Setup;
      END;

PROCEDURE Startrun (view: T) =
  (* sleazy hack: remove the old GraphVBT and just ignore it;
     heck, what else are VM and GC good for? *)
  BEGIN
    EVAL Filter.Replace(view, NEW(GraphVBT.T).init());
    (* call the superclass startrun in ZeusClass.T *)
    MaxflowViewClass.T.startrun(view); 
  END Startrun;


PROCEDURE Setup (view: T; g: Graph.T; source, sink: Graph.Vertex) =
  VAR
      wc := GraphVBT.WorldRectangle{
            w := 0.0, s := 0.0, e := 1.0, n := 1.0};
      stdsize, bigsize : R2.T;
      v : GraphVBT.Vertex;
      f : Font.T := Font.FromName (ARRAY OF TEXT {"helvetica-bold-r-*-*-*-140-*"});

  BEGIN
    view.gvbt  := NEW(GraphVBT.T, world := wc).init();
    EVAL Filter.Replace(view, view.gvbt);

    stdsize := R2.T{0.08,0.08};   
    bigsize := R2.T{0.6,0.2};   

    (* cornflowerblue *)

    EVAL NEW (GraphVBT.Vertex, graph := view.gvbt, 
                pos := R2.T {0.25, 0.9},
	        sizeW := stdsize, 
                color := MFViews.Color ("cornflowerblue") ).init();
    
    EVAL NEW (GraphVBT.Vertex, graph := view.gvbt, 
                pos := R2.T {0.75, 0.9},
	        sizeW := bigsize, 
                label := "Forward flow along path (color saturation = flow/capacity)",
                font  := f,
                fontColor := MFViews.Color ("black"),
                color := MFViews.Color ("white") ).init();
    
    (* limegreen *)

    EVAL NEW (GraphVBT.Vertex, graph := view.gvbt, 
                pos := R2.T {0.25, 0.7},
	        sizeW := stdsize, 
                color := MFViews.Color ("limegreen") ).init();
    
    EVAL NEW (GraphVBT.Vertex, graph := view.gvbt, 
                pos := R2.T {0.75, 0.7},
	        sizeW := bigsize, 
                label := "Backward flow along path",
                font  := f,
                fontColor := MFViews.Color ("black"),
                color := MFViews.Color ("white") ).init();
    
    (* magenta *)

    EVAL NEW (GraphVBT.Vertex, graph := view.gvbt, 
                pos := R2.T {0.25, 0.5},
	        sizeW := stdsize, 
                color := MFViews.Color ("magenta") ).init();
    
    EVAL NEW (GraphVBT.Vertex, graph := view.gvbt, 
                pos := R2.T {0.75, 0.5},
	        sizeW := bigsize, 
                label := "Flow = capacity",
                font  := f,
                fontColor := MFViews.Color ("black"),
                color := MFViews.Color ("white") ).init();
    
    (* black *)

    v := NEW (GraphVBT.Vertex, graph := view.gvbt, 
                pos := R2.T {0.25, 0.3},
	        sizeW := stdsize,
                shape := GraphVBT.VertexShape.Ellipse,
                color := MFViews.Color ("gray") ).init();
    
    EVAL  NEW (GraphVBT.VertexHighlight, vertex := v,
                color := MFViews.Color ("black"),
                borderMM := R2.T{1.0, 1.0}).init();	

    EVAL NEW (GraphVBT.Vertex, graph := view.gvbt, 
                pos := R2.T {0.75, 0.3},
	        sizeW := bigsize, 
                label := "Augmenting path vertex",
                font  := f,
                fontColor := MFViews.Color ("black"),
                color := MFViews.Color ("white") ).init();
    
    
    (* yellow *)

    v := NEW (GraphVBT.Vertex, graph := view.gvbt, 
                pos := R2.T {0.25, 0.1},
	        sizeW := stdsize,
                shape := GraphVBT.VertexShape.Ellipse,
                color := MFViews.Color ("gray") ).init();
    
    EVAL  NEW (GraphVBT.VertexHighlight, vertex := v,
                color := MFViews.Color ("yellow"),
                borderMM := R2.T{1.0, 1.0}).init();	

    EVAL NEW (GraphVBT.Vertex, graph := view.gvbt, 
                pos := R2.T {0.75, 0.1},
	        sizeW := bigsize, 
                label := "currentVertex",
                font  := f,
                fontColor := MFViews.Color ("black"),
                color := MFViews.Color ("white") ).init();
    
    
    view.gvbt.redisplay();
  END Setup;

PROCEDURE New (): View.T =
  VAR a : T :=  NEW(T).init(TextVBT.New("Legend"));
  BEGIN
    RETURN a;
  END New;

BEGIN
  ZeusPanel.RegisterView (New, "Legend", "Maxflow");

END MFLegendView.
