(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

MODULE M3ToolFrame;

IMPORT M3Context, M3Args;
IMPORT WiredStandard, M3CBE_C_Tool, M3DPathTool, M3CFETool, M3ASTCacheTool;

PROCEDURE Init(context: M3Context.T): INTEGER=
  BEGIN
    M3CBE_C_Tool.ToolInit();             (* register target machine variants *)
    IF M3Args.CheckHelp() THEN RETURN 0 END; (* check for -help *)
    IF M3CBE_C_Tool.Init() < 0 THEN RETURN -1 END; (* fail if bad target *)
    M3DPathTool.Check();                 (* check for -D path *)
    M3ASTCacheTool.Check();              (* check for -ASTCache n *)
    WiredStandard.Set(context);          (* include "standard" interface *)
    RETURN 1;
  END Init;

PROCEDURE Startup(worker: WorkProc; compile := TRUE): INTEGER RAISES ANY=
  VAR
    context := M3Context.New();
    compileResult: INTEGER := Init(context);
  BEGIN
    IF compileResult <= 0 THEN RETURN compileResult END;
    IF compile THEN compileResult := M3CFETool.CompileInContext(context) END;
    RETURN worker(context, compileResult);        (* call user procedure *)
  END Startup;

BEGIN
END M3ToolFrame.
