INTERFACE M3LInitOrder;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT SList;
IMPORT M3Context, M3AST_AS;

TYPE T <: REFANY;

PROCEDURE Set(c: M3Context.T; main: M3AST_AS.Compilation_Unit;
    showMD: BOOLEAN): T RAISES {};
(* Compute the initialisation order of the modules in 'c', given
the tmp_dependson_s has already been computed. 'main' has been designated
the main program module. If 'showMD=TRUE' warn of mutual dependencies. 
Returns a handle to be used with the iterator. *)

TYPE Iter <: REFANY;

PROCEDURE NewIter(t: T): Iter RAISES {};
(* Return an iterator for the init order in 't'. *)

PROCEDURE Next(
    iter: Iter; 
    VAR (*out*) cu: M3AST_AS.Compilation_Unit
    ): BOOLEAN RAISES {};
(* An iterator which gives the initialisation order as computed by 'Set'. *)

PROCEDURE Force(c: M3Context.T; order: SList.T): T RAISES {};
(* Force the order returned by Next to be that given by the list in 'order',
   which is a list of TextElems.  Returns NIL if module in 'order' 
   cannot be found. *)

END M3LInitOrder.
