(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

INTERFACE AST_Init;

IMPORT AST;

(* This view adds an "init" method to an AST.NODE *)

TYPE
  NODE = OBJECT
    METHODS
      init(): AST.NODE RAISES {} := Null;
      (* performs any specific initialisation that cannot be captured by
         static defaults. The convention is to call NEW(SomeNode).init().
      *)
  END;

REVEAL
  AST.NODE <: NODE;

PROCEDURE Null(n: NODE): AST.NODE RAISES {};
(* does nothing and returns 'n'. *)


END AST_Init.
