INTERFACE ASTCopy;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT AST, ASTWalk;

TYPE
  Closure <: OBJECT  (* this may be subtyped by client to hold state. *)
    METHODS
      callback(n, ncopy: AST.NODE; vm: ASTWalk.VisitMode) RAISES ANY;
      init(): Closure;
  END;
  (* create using "NEW(Closure, callback := YourCallback).init()" *)

PROCEDURE Nodes(
    n: AST.NODE;
    ): AST.NODE RAISES {};
(* The default walk never calls back. This just copies the tree rooted
at 'n' and returns the root of the copy. *)

PROCEDURE ModeNodes(
    n: AST.NODE;
    c: Closure;
    vm : ASTWalk.VisitModeControl;
    ): AST.NODE RAISES ANY;
(* This one supplies a callback, which is called on Entry/Exit according
to 'vm'.  'ncopy' is NIL on Entry. Returns the copied tree as result. *)

PROCEDURE IgnoreChildren(c: Closure) RAISES {};
(* Can be called from an entry visit to suppress visiting the children
   of this node.  Once control moves to another node, the suppression
   is disabled. *)

END ASTCopy.
