INTERFACE M3PPIO;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Text;
IMPORT IO;
IMPORT M3AST_AS;
IMPORT AST_DisplayRep;

(* Output support for pretty-printer. *)

PROCEDURE D(s: Text.T; h: AST_DisplayRep.Handle) RAISES {IO.Error};
(* Display 's' *)

PROCEDURE SD(s: Text.T; h: AST_DisplayRep.Handle) RAISES {IO.Error};
(* Display a space then 's' *)

PROCEDURE DS(s: Text.T; h: AST_DisplayRep.Handle) RAISES {IO.Error};
(* Display 's' then a space *)

PROCEDURE SDS(s: Text.T; h: AST_DisplayRep.Handle) RAISES {IO.Error};
(* Display a space, 's', space *)

(* Variants of above which set node source positions before output *)

PROCEDURE SSP_D(
    n: M3AST_AS.SRC_NODE;
    s: Text.T;
    h: AST_DisplayRep.Handle) RAISES {IO.Error};
(* Display 's' *)

PROCEDURE SSP_SD(
    n: M3AST_AS.SRC_NODE;
    s: Text.T;
    h: AST_DisplayRep.Handle)
    RAISES {IO.Error};
(* Display a space then 's' *)

PROCEDURE SSP_DS(
    n: M3AST_AS.SRC_NODE;
    s: Text.T;
    h: AST_DisplayRep.Handle)
    RAISES {IO.Error};
(* Display 's' then a space *)

PROCEDURE SSP_SDS(
    n: M3AST_AS.SRC_NODE;
    s: Text.T;
    h: AST_DisplayRep.Handle)
    RAISES {IO.Error};
(* Display a space, 's', space *)

PROCEDURE SSP(
    n: M3AST_AS.SRC_NODE;
    h: AST_DisplayRep.Handle)
    RAISES {IO.Error};
(* Just set srcpos *)

PROCEDURE SCNL(h: AST_DisplayRep.Handle) RAISES {IO.Error};
(* Display a ';' then a newline *)

PROCEDURE CS(h: AST_DisplayRep.Handle) RAISES {IO.Error};
(* Display a ',' then a space *)

PROCEDURE SCS(h: AST_DisplayRep.Handle) RAISES {IO.Error};
(* Display space, ',' space *)

PROCEDURE Indent(h: AST_DisplayRep.Handle) RAISES {IO.Error};
(* Display 'current-indent' number of spaces *)

PROCEDURE Indent_SSP(
    n: M3AST_AS.SRC_NODE;
    h: AST_DisplayRep.Handle)
    RAISES {IO.Error};
(* Display 'current-indent' number of spaces, then set source pos of 'an' *)

PROCEDURE NLIncIndent(h: AST_DisplayRep.Handle) RAISES {IO.Error};
(* Display a newline, and increment 'current-indent' *)

PROCEDURE NLDecIndent(h: AST_DisplayRep.Handle) RAISES {IO.Error};
(* Display a newline, then decrement 'current-indent' *)

PROCEDURE IncIndent(h: AST_DisplayRep.Handle) RAISES {IO.Error};
(* Increment 'current-indent' *)

PROCEDURE DecIndent(h: AST_DisplayRep.Handle) RAISES {IO.Error};
(* Decrement 'current-indent' *)

PROCEDURE NL(h: AST_DisplayRep.Handle) RAISES {IO.Error};
(* Display a single newline *)

PROCEDURE NL2(h: AST_DisplayRep.Handle) RAISES {IO.Error};
(* Display two newlines *)


END M3PPIO.
