(* Copyright (C) 1991, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

INTERFACE M3ShowProcTool;

IMPORT Wr;
IMPORT M3Args;
IMPORT M3Context;

CONST
  Explicit_Arg = "Explicit"; (* ignore units compiled implicitly
                                because of IMPORT declarations *)

PROCEDURE Get(): M3Args.T;
(* Return the tool handle *)

PROCEDURE Run(c: M3Context.T; wr: Wr.T);
(* For each AST in "Filter(c)", output the name of the unit, and for
   each "Proc_decl" node in the AST, output "PROCEDURE <name>" to "wr", where 
   "<name>" is the procedure name. If "Explicit" is set, "Filter" removes
   those units that were not explicity named by the user, else it is the
   identify function. The precise interpretation of "explicit" is
   "M3Conventions.PrimarySource IN cu.fe_status", and the compiler
   tool sets this attribute only for the units it is asked to compile. *)


END M3ShowProcTool.
