INTERFACE TimeElapsed;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT OSError;

CONST
  TicksPerSecond = 100;

PROCEDURE CPU(): INTEGER RAISES {OSError.E};
(* a rough way of measuring elapsed CPU time (its accuracy depends on the
underlying system). A call of 'CPU' returns the number of ticks since the
this module was initialised. This is only approximately equal to the startup
time of the program.
  To time an operation call 'CPU' before and after the operation takes place.
The difference between the two calls is the number of ticks taken for the
operation *)

END TimeElapsed.
