INTERFACE TimeDate;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Text;
IMPORT OSError;


(* the basic type representing a date and time. There are several alternative
names for this type (some only look right when qualified with the name of the
interface, i.e. 'Time'). Choose the name you like best! *)
TYPE
  T <: REFANY;
  OfDay = T;
  TimeOfDay = T;
  Stamp = T;


(* the following types represent an expanded representation of the date and
time. Note that no guarantee is made about the 'microSeconds' field being
accurate - it depends on the underlying system. It may well be rounded to the
nearest hundredth or tenth of a second. It may even be always zero.
  It is assumed that all systems at least get the 'second' field right *)
TYPE
  Day = {Sun, Mon, Tue, Wed, Thu, Fri, Sat};
  Month = {Jan, Feb, Mar, Apr, May, Jun, Jul, Aug, Sep, Oct, Nov, Dec};
  Expanded = RECORD
    microSecond: INTEGER;     (* 0..999999 *)
    second: INTEGER;          (* 0..59 *)
    minute: INTEGER;          (* 0..59 *)
    hour: INTEGER;            (* 0..23 *)
    day: Day;
    dayOfMonth: INTEGER;      (* 1..31 *)
    dayOfYear: INTEGER;       (* 0..365 *)
    month: Month;
    year: INTEGER;            (* year A.D. *)
    daylightSavings: INTEGER; (* 0 no, > 0 yes < 0 don't know *)
  END;


(* Useful constants for boring time calculations *)
CONST
  Kilo = 1000;        (* a thousand; for converting milliseconds to seconds *) 
  Mega = Kilo * Kilo; (* a million; for converting microseconds to seconds *)

  SecondsPerMinute = 60;
  MinutesPerHour = 60;
  SecondsPerHour = MinutesPerHour * SecondsPerMinute;
  HoursPerDay = 24;
  MinutesPerDay = HoursPerDay * MinutesPerHour;
  SecondsPerDay = MinutesPerDay * SecondsPerMinute;
  DaysPerWeek = 7;
  HoursPerWeek = DaysPerWeek * HoursPerDay;
  MinutesPerWeek = HoursPerWeek * MinutesPerHour;
  SecondsPerWeek = MinutesPerWeek * SecondsPerMinute;

  ShortDayNames = ARRAY Day OF Text.T
      {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
  DayNames = ARRAY Day OF Text.T
      {"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday",
      "Saturday"};

  DaysInMonth = ARRAY Month OF INTEGER
      {31, 27, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

  ShortMonthNames = ARRAY Month OF Text.T
      {"Jan", "Feb", "Mar", "Apr", "May", "Jun",
      "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
  MonthNames = ARRAY Month OF Text.T
      {"January", "February", "March", "April", "May", "June",
      "July", "August", "September", "October", "November", "December"};  
(* *)

(* Procedures for finding out the current date and time, expanding it and
producing it in a printable form *)

PROCEDURE Current(): TimeOfDay RAISES {OSError.E};
(* current time *)

PROCEDURE Expand(t: TimeOfDay; VAR e: Expanded) RAISES {};
(* convert time into expanded format, local time *)

PROCEDURE ExpandGMT(t: TimeOfDay; VAR e: Expanded) RAISES {};
(* convert time into expanded format, GMT *)

PROCEDURE ToText(t: TimeOfDay): Text.T RAISES {};
(* convert time into text form. A typical result would be:
  "Sun Sep 16 01:03:52 1973"
*)


END TimeDate.

