UNSAFE MODULE OSError_ux EXPORTS OSError, OSError_ux;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Text;
IMPORT Uerror, Ctypes, M3toC;


PROCEDURE CodeToText(error: Ctypes.int): Text.T RAISES {}=
  BEGIN
    IF error >= 0 AND error <= Uerror.sys_nerr THEN
      RETURN M3toC.StoT(Uerror.GetFrom_sys_errlist(error));
    ELSE
      RETURN "unknown error";
    END
  END CodeToText;


PROCEDURE ToText(t: T): Text.T RAISES {}=
  BEGIN
    RETURN CodeToText(t^);
  END ToText;


PROCEDURE Raise() RAISES {E}=
  VAR
    save := Uerror.errno;
  BEGIN
    (* we have saved 'errno' before we call NEW which might conceivably
     overwrite it *)
    WITH t = NEW(T) DO
      t^ := save;
      RAISE E(t);
    END;
  END Raise;


PROCEDURE Return(): T RAISES {}=
  VAR
    save := Uerror.errno;
  BEGIN
    (* we have saved 'errno' before we call NEW which might conceivably
     overwrite it *)
    WITH t = NEW(T) DO
      t^ := save;
      RETURN t;
    END;
  END Return;


BEGIN
END OSError_ux.
