INTERFACE PromptFor;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT IO, Text;

(* Convenience routines for reading numbers and yes/no answers. These are
intended for interactive use (and they are coded for simplicity rather than
efficiency; speed does not usually matter if your input is the  keyboard!).
  All the routines take the arguments 'in' and 'out'. If 'in' is NIL (the
default) input is read from 'StdIO.In', otherwise 'in' is used. If 'out' is
NIL (the default) output is written to 'StdIO.Out', otherwise 'out' is used.
  The routines take their 'prompt' argument, output it and then flush. They
read up to and including the next newline, ignoring leading and trailing 
whitespace.
  If the text that is read is null the 'default' argument is returned,
otherwise it is translated into a number or boolean depending on the routine.
If the translation fails a or if the result is a number which is not within the
given bounds a brief error message is written to the out stream and the routine
repeats the prompting, reading and translation step until a valid result is
obtained.
  The bounds for a number are specified by 'min' and 'max' arguments. If these
have the same value no bounds check is done, otherwise the result returned is
guaranteed to be greater than or equal to 'min' and less than or equal to
'max'. *)


PROCEDURE Int(
    prompt: Text.T;
    default := 0;
    min, max := 0;
    in, out: IO.Stream := NIL)
    : INTEGER
    RAISES {IO.Error, IO.EndOfStream};
(* Read an integer. The translation is done by 'TextTo.BigInt' so the integer
can have a preceding base and can be followed by 'k' or 'm' to scale it by
1024 or 1024 * 1024. *)

PROCEDURE Card(
    prompt: Text.T;
    default: CARDINAL := 0;
    min, max: CARDINAL := 0;
    in, out: IO.Stream := NIL)
    : CARDINAL
    RAISES {IO.Error, IO.EndOfStream};
(* A veneer on 'Int'; only really useful when using the result to type a
variable in a declaration e.g. given the following
  VAR
    c := PromptFor.Card("Give me a cardinal: ");
'c' will have type CARDINAL *)

PROCEDURE Real(
    prompt: Text.T;
    default := 0.0;
    min, max := 0.0;
    in, out: IO.Stream := NIL)
    : REAL
    RAISES {IO.Error, IO.EndOfStream};
(* Read a real. The translation procedure is 'TextTo.Real' *)

PROCEDURE LongReal(
    prompt: Text.T;
    default := 0.0D0;
    min, max := 0.0D0;
    in, out: IO.Stream := NIL)
    : LONGREAL
    RAISES {IO.Error, IO.EndOfStream};
(* Read a long real. The translation procedure is 'TextTo.LongReal' *)

PROCEDURE Answer(
    prompt: Text.T;
    default := FALSE;
    in, out: IO.Stream := NIL)
    : BOOLEAN
    RAISES {IO.Error, IO.EndOfStream};
(* Read a yes/no answer. Accepts "y", "n", "yes" or "no" (case insensitive) *)

END PromptFor.
