UNSAFE MODULE FileOp_ux EXPORTS FileOp, FileOp_ux, FileOp_priv;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Text, Word;
IMPORT Unix, Ustat, Utypes, UnixMutex, Uerror, Ctypes, M3toC;
IMPORT OSError_ux, FileStamp_ux, PathName_ux;
IMPORT OSError, TimeDate;


PROCEDURE MName(i: Info): Text.T RAISES {}=
  BEGIN
    RETURN i.nameText;
  END MName;


PROCEDURE MIsFile(i: Info): BOOLEAN RAISES {}=
  BEGIN
    RETURN i.info.isFile;
  END MIsFile;


PROCEDURE MAccess(i: Info): Access RAISES {}=
  BEGIN
    RETURN i.info.access
  END MAccess;


PROCEDURE MLastModified(i: Info): TimeDate.Stamp RAISES {}=
  BEGIN
    RETURN i.info.lastModified
  END MLastModified;


PROCEDURE MLength(i: Info): CARDINAL RAISES {}=
  BEGIN
    RETURN i.statBuf.st_size;
  END MLength;


PROCEDURE MStat(i: Info): Ustat.struct_stat RAISES {}=
  BEGIN
    RETURN i.statBuf;
  END MStat;


PROCEDURE MINode(i: Info): Utypes.ino_t RAISES {}=
  BEGIN
    RETURN i.statBuf.st_ino;
  END MINode;


PROCEDURE InfoFromStatBuf(
    READONLY statBuf: Ustat.struct_stat;
    VAR r: Rec)
    RAISES {}=
  VAR
    mode := statBuf.st_mode;
    access := Access{};
  BEGIN
    r.isFile := Word.And(mode, Ustat.S_IFDIR) = 0;
    IF Word.And(mode, Ustat.S_IREAD) # 0 THEN
      access := access + Access{AccessBit.Readable};
    END;
    IF Word.And(mode, Ustat.S_IWRITE) # 0 THEN
      access := access + Access{AccessBit.Writeable};
    END;
    IF Word.And(mode, Ustat.S_IEXEC) # 0 THEN
      IF r.isFile THEN
        access := access + Access{AccessBit.Executable};
      ELSE
        access := access + Access{AccessBit.Traversable};
      END;
    END;
    r.access := access;
    r.lastModified := FileStamp_ux.ToStamp(statBuf.st_mtime);
  END InfoFromStatBuf;


<*INLINE*> PROCEDURE UnixName(name: Text.T): Ctypes.char_star RAISES {}=
  VAR
    realName: Text.T;
  BEGIN
    IF Text.Length(name) = 0 THEN
      realName := PathName_ux.CurrentDirText;
    ELSE
      realName := name;
    END;
    RETURN M3toC.TtoS(realName);
  END UnixName;


PROCEDURE GetInfo(name: Text.T; mustExist := TRUE): Info RAISES {OSError.E}=
  VAR
    statBuf: Ustat.struct_stat;
  BEGIN
    LOCK UnixMutex.errno DO
      IF Ustat.stat(UnixName(name), ADR(statBuf)) < 0 THEN
        IF NOT mustExist AND Uerror.errno = Uerror.ENOENT THEN RETURN NIL END;
        OSError_ux.Raise();
      END;
    END;
    WITH new = NEW(Info, nameText := name, statBuf := statBuf) DO
      InfoFromStatBuf(new.statBuf, new.info);
      RETURN new;
    END;
  END GetInfo;


PROCEDURE Same(info1, info2: Info): BOOLEAN RAISES {} =
  BEGIN
    RETURN info1.inode() = info2.inode();
  END Same;


PROCEDURE Accessible(name: Text.T): BOOLEAN RAISES {}=
  BEGIN
    LOCK UnixMutex.errno DO
      RETURN Unix.access(UnixName(name), Unix.F_OK) >= 0;
    END;
  END Accessible;


PROCEDURE Remove(name: Text.T; mustExist := TRUE) RAISES {OSError.E}=
  BEGIN
    LOCK UnixMutex.errno DO
      IF Unix.unlink(UnixName(name)) < 0 THEN
        IF NOT mustExist AND Uerror.errno = Uerror.ENOENT THEN RETURN END;
        OSError_ux.Raise();
      END;
    END;
  END Remove;


PROCEDURE Rename(from, to: Text.T) RAISES {OSError.E}=
  BEGIN
    LOCK UnixMutex.errno DO
      IF Unix.rename(UnixName(from), UnixName(to)) < 0 THEN
        OSError_ux.Raise();
      END;
    END;
  END Rename;


BEGIN
END FileOp_ux.
