UNSAFE INTERFACE FileOp_priv;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Text;
IMPORT Ustat, Utypes;
IMPORT TimeDate;
IMPORT FileOp;

(* This interface reveals the innards of a 'FileOp.Info'. It is a private
interface, intended for use by those who write and extend the library. It
should not be used by normal users of the library *)

TYPE
  Rec = RECORD
    isFile: BOOLEAN;
    access: FileOp.Access;
    lastModified: TimeDate.Stamp;
  END;


REVEAL
  FileOp.Info = FileOp.Info_public OBJECT
  METHODS
    stat(): Ustat.struct_stat RAISES {};
  END
  BRANDED OBJECT
    nameText: Text.T;
    statBuf: Ustat.struct_stat;
    info: Rec;
  METHODS
    inode(): Utypes.ino_t RAISES {} := MINode;
  OVERRIDES
    name := MName;
    isFile := MIsFile;
    access := MAccess;
    lastModified := MLastModified;
    length := MLength;
    stat := MStat;
  END;

PROCEDURE InfoFromStatBuf(
    READONLY statBuf: Ustat.struct_stat;
    VAR r: Rec)
    RAISES {};

PROCEDURE MName(t: FileOp.Info): Text.T RAISES {};
PROCEDURE MIsFile(t: FileOp.Info): BOOLEAN RAISES {};
PROCEDURE MAccess(t: FileOp.Info): FileOp.Access RAISES {};
PROCEDURE MLastModified(t: FileOp.Info): TimeDate.Stamp RAISES {};
PROCEDURE MLength(t: FileOp.Info): CARDINAL RAISES {};
PROCEDURE MStat(t: FileOp.Info): Ustat.struct_stat RAISES {};
PROCEDURE MINode(t: FileOp.Info): Utypes.ino_t RAISES {};

END FileOp_priv.
