(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Thu Nov 12 10:50:07 PST 1992 by muller                   *)

UNSAFE MODULE RTThread;

IMPORT Usignal;

CONST 
  SP_pos = 3;

EXCEPTION InternalError;  <* FATAL InternalError *>

PROCEDURE SP (s: State): ADDRESS =
  BEGIN
    RETURN LOOPHOLE (s [SP_pos], ADDRESS);
  END SP;

PROCEDURE FlushStackCache () =
  BEGIN
  END FlushStackCache;

PROCEDURE UpdateStateForNewSP (VAR s: State; offset: INTEGER) =
  BEGIN
    INC (s [SP_pos], offset);
  END UpdateStateForNewSP;

PROCEDURE UpdateFrameForNewSP (<*UNUSED*> a: ADDRESS; 
                               <*UNUSED*> offset: INTEGER) =
  BEGIN
  END UpdateFrameForNewSP;

PROCEDURE mask_sigvtalrm (VAR i: Usignal.sigset_t) =
  BEGIN
    IF Usignal.SIGVTALRM <= 32 THEN
      i.losigs := Usignal.sigmask (Usignal.SIGVTALRM);
      i.hisigs := 0
    ELSE
      i.losigs := 0;
      i.hisigs := Usignal.sigmask (Usignal.SIGVTALRM-32)
    END
  END mask_sigvtalrm;
  
PROCEDURE setup_sigvtalrm (handler: Usignal.SignalHandler) =
  VAR sa, osa: Usignal.struct_sigaction;
  BEGIN
    sa.sa_handler := handler;
    sa.sa_mask    := Usignal.empty_sigset_t;
    sa.sa_flags   := 0;
    IF Usignal.sigaction (Usignal.SIGVTALRM, sa, osa) #  0 THEN
      RAISE InternalError; END;
  END setup_sigvtalrm;

PROCEDURE allow_sigvtalrm () =
  VAR i : Usignal.sigset_t;
  BEGIN
    EVAL Usignal.sigprocmask(Usignal.SIG_UNBLOCK, ThreadSwitchSignal, i)
  END allow_sigvtalrm;

PROCEDURE disallow_sigvtalrm () =
  VAR i : Usignal.sigset_t;
  BEGIN
    EVAL Usignal.sigprocmask(Usignal.SIG_BLOCK, ThreadSwitchSignal, i)
  END disallow_sigvtalrm;

VAR
  ThreadSwitchSignal: Usignal.sigset_t;

BEGIN
  mask_sigvtalrm(ThreadSwitchSignal);
END RTThread.
