(* Copyright (C) 1992, Xerox                                                 *)
(* All rights reserved.                                                      *)

(* Last modified on Tue Feb 11 15:18:44 PST 1992 by muller                   *)
(*      modified on Wed Sep 25 00:33:01 1991 by goldberg@xerox.parc.com      *)

MODULE LongFloat;

IMPORT SunOsIeee;

PROCEDURE Scalb(x: LONGREAL; n: INTEGER): LONGREAL =
BEGIN
	RETURN(SunOsIeee.scalbn(x, n));
END Scalb;

PROCEDURE ILogb(x: LONGREAL): INTEGER =
BEGIN
	RETURN(SunOsIeee.ilogb(x));
END ILogb;

PROCEDURE Sqrt(x: LONGREAL): LONGREAL =
BEGIN
   RETURN(SunOsIeee.sqrt(x));
END Sqrt;

(*  From ieeefp.h
      enum fp_class_type		/* floating-point classes */
	{
	fp_zero		= 0,
	fp_subnormal	= 1,
	fp_normal	= 2,
	fp_infinity   	= 3,
	fp_quiet	= 4,
	fp_signaling	= 5
	} ;
*)

PROCEDURE Class(x: LONGREAL): IEEEClass =
CONST
  translate = ARRAY[0..5] OF IEEEClass{
	IEEEClass.Zero,
	IEEEClass.Denormal,
	IEEEClass.Normal,
	IEEEClass.Infinity,
	IEEEClass.QuietNaN,
	IEEEClass.SignalingNaN};
BEGIN
	RETURN(translate[SunOsIeee.fp_class(x)]);
END Class;

PROCEDURE Sign(x: LONGREAL): [0..1] =
BEGIN
  RETURN(SunOsIeee.signbit(x));
END Sign;

PROCEDURE Logb(x: T): T = BEGIN
    RETURN(SunOsIeee.logb(x));
END Logb;

PROCEDURE NextAfter(x, y: T): T =
BEGIN
  RETURN(SunOsIeee.nextafter(x, y));
END NextAfter;

PROCEDURE CopySign(x, y: T): T =
BEGIN
  RETURN(SunOsIeee.copysign(x, y));
END CopySign;

PROCEDURE Finite(x: T): BOOLEAN =
BEGIN
  RETURN(SunOsIeee.finite(x));
END Finite;

PROCEDURE IsNaN(x: T): BOOLEAN =
BEGIN
  RETURN(SunOsIeee.isnan(x));
END IsNaN;

PROCEDURE Differs(x, y: T): BOOLEAN =
BEGIN
  RETURN (x < y OR y < x);
END Differs;
    
PROCEDURE Unordered(x, y: T): BOOLEAN =
BEGIN
  RETURN (NOT (x <= y OR y <= x));
END Unordered;

BEGIN
(* start code *)
END LongFloat.
