/* Copyright (C) 1990, Digital Equipment Corporation.         */
/* All rights reserved.                                       */
/* See the file COPYRIGHT for a full description.             */

/* Last modified on Wed Oct 14 13:07:00 PDT 1992 by muller    */
/*      modified on Tue Oct 13 08:32:18 PDT 1992 by kalsow    */
/*      modified on Thu Jun 28 20:07:44 1990 by piet@cs.ruu.nl */

/* for HP-PA */

/* This pragma allows the bitfield storage to most closely
   approximate the structures defined in the Unix interface.  */

#pragma HP_ALIGN NATURAL

/* These are the storage classes and type qualifiers */

#define _VOLATILE

#define _PRIVATE static
#define _IMPORT  extern
#define _EXPORT        

#define _LOCAL_PROC  static
#define _LOCAL       auto


/* #define _STACK_GROWS_DOWN */
/* comment this out if stacks grow up (toward increasing addresses) */


/* A Modula-3 procedure value can be either a C function pointer or a
   pointer to a CLOSURE struct. The first field of CLOSURE structs
   "marker", is always equal to CLOSURE_MARKER.

   To test if a procedure value is a closure or not, we assume is it
   one and look at the marker field. If we don't find CLOSURE_MARKER,
   we have a C function pointer.

   Since a C function pointer is the address of the first instruction,
   we chose the value of CLOSURE_MARKER to be different from any
   instruction that may start a procedure.

   Note that the HP PA-RISC compilers use procedure labels when a module
   is compiled with shared library support.  In this case, a procedure
   pointer is the address of a PLT (Procedure Linkage Table) entry for
   the target procedure rather than the actual procedure address.  In
   this case, the lower 2 bits contain a mask that indicates whether
   the pointer contains the address of the procedure (=0x00) or the
   address of the PLT (=0x02).  Also, note that a _CLOSURE record is
   always aligned on a 4-byte boundary (thus the lower 2-bits =0x00).
   The net result of all this is that we can tell if we have a pointer
   to a PLT entry by looking at the lower two bits.  If they are off,
   then we know that we either have a pointer to a procedure or a
   pointer to a _CLOSURE, and the test can proceed as normal. */

#define _CLOSURE_MARKER (-1)      /* illegal opcode */
#define _IS_CLOSURE(p) ((p != 0) \
                        && ((((unsigned)p) & 0x03) == 0) \
                        && (((_CLOSURE *)p)->marker == _CLOSURE_MARKER))



/* NILCHECKB must evaluate its argument 'e' (a char*) and
   generate a trap if it is NIL (0). */
#define _NILCHKCHAR volatile char
_IMPORT _NILCHKCHAR _M3__nil_check_char;
#define _NILCHECKB(e) _M3__nil_check_char = ((char*)(e))[-1];


/* The type 'signed_char' is 'signed char' in ANSI-C,
   but CC may not like that. Same for 'signed_int'. */
typedef char signed_char;
typedef int  signed_int;
