(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Host.i3                                               *)
(* Last modified on Mon Jun 29 16:36:19 PDT 1992 by kalsow     *)
(*      modified on Sat May 12 07:05:52 1990 by muller         *)

INTERFACE Host;

IMPORT String, Rd, Wr;

VAR
  filename      : String.T := NIL;
  source        : Rd.T;
  errors        : Wr.T;
  output        : Wr.T;
  linkOutput    : Wr.T;
  verbose       : BOOLEAN; (* => diagnostic listing of phases *)
  Clines        : BOOLEAN; (* => don't generate Modula-3 line numbers *)
  errorDie      : INTEGER; (* N>=0 => abort on the Nth error *)
  standard      : BOOLEAN; (* => non-standard Modula-3 is an error *)
  warnings      : INTEGER; (* => ignore warning levels less than this value *)
  coverage      : BOOLEAN; (* => generate coverage counts *)
  inlines       : BOOLEAN; (* => expand inline procedures *)
  versionStamps : BOOLEAN := TRUE; (* do emit version stamps *)
  emitBuiltins  : BOOLEAN := FALSE; (* don't compile, emit the builtins *)
  do_timing     : BOOLEAN := FALSE; (* generate a timing break-down *)

VAR
  doNarrowChk : BOOLEAN := TRUE;
  doRangeChk  : BOOLEAN := TRUE;
  doReturnChk : BOOLEAN := TRUE;
  doCaseChk   : BOOLEAN := TRUE;
  doTCaseChk  : BOOLEAN := TRUE;
  doAsserts   : BOOLEAN := TRUE;
  doNilChk    : BOOLEAN := TRUE;
  doStackChk  : BOOLEAN := TRUE;
  doRaisesChk : BOOLEAN := TRUE;

PROCEDURE OpenUnit (name: String.T; interface, generic: BOOLEAN;
                                          VAR(*OUT*) filename: String.T): Rd.T;

PROCEDURE CloseRd (rd: Rd.T);
PROCEDURE CloseWr (wr: Wr.T);

PROCEDURE Halt (exit: INTEGER);
PROCEDURE Die (a, b, c, d: TEXT := NIL);

PROCEDURE Initialize ();

PROCEDURE Reset (): BOOLEAN;

END Host.
