(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: AdrSize.m3                                            *)
(* Last Modified On Tue Jun 30 08:50:18 PDT 1992 By kalsow     *)
(*      Modified On Tue Apr 10 10:57:13 1990 By muller         *)

MODULE AdrSize;

IMPORT CallExpr, Expr, Type, Procedure, Target, BitSize, Card, Temp;

VAR Z: CallExpr.MethodList;

PROCEDURE Check (<*UNUSED*> proc: Expr.T; VAR args: Expr.List;  <*UNUSED*> VAR cs: Expr.CheckState): Type.T =
  BEGIN
    BitSize.CheckArg ("ADRSIZE", args);
    RETURN Card.T;
  END Check;

PROCEDURE Compile (<*UNUSED*> proc: Expr.T; args: Expr.List): Temp.T =
  BEGIN
    RETURN BitSize.Gen (args[0], Target.ADDRUNIT);
  END Compile;

PROCEDURE Fold (<*UNUSED*> proc: Expr.T; args: Expr.List): Expr.T =
  BEGIN
    RETURN BitSize.GetSize (args[0], Target.ADDRUNIT);
  END Fold;

PROCEDURE Initialize () =
  BEGIN
    Z := CallExpr.NewMethodList (1, 1, TRUE, FALSE, Card.T,
                                 NIL, Check, Compile, Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define ("ADRSIZE", Z, TRUE);
  END Initialize;

BEGIN
END AdrSize.
