(* Copyright (C) 1989, 1990 Digital Equipment Corporation	*)
(* All rights reserved.						*)
(* See the file COPYRIGHT for a full description.		*)

(* File: X.i3							*)
(* Last modified on Wed Jan 29 00:59:22 PST 1992 by muller  	*)
(*      modified on Mon Apr  8 22:18:20 PDT 1991 by gnelson	*)
(*      modified on Thu Mar  8 16:44:51 1990 by jerome  	*)
(*      modified on Sun Feb 18 14:00:55 1990 by harrison	*)


UNSAFE INTERFACE X;

(*==============================================================*)
(*	The X11 R4 Interface for Modula 3			*)
(*								*)
(*	contains:	/usr/include/X11/X.h			*)
(*			/usr/include/X11/Xlib.h			*)
(*			/usr/include/X11/Xutil.h		*)
(*==============================================================*)

(***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************)

FROM Ctypes IMPORT Char, CharStar, CharStarStar, CharStarStarStar,
                   ConstCharStar, ConstUnsignedCharStar, 
                   Int, IntStar, Long, LongStar, Short,
                   UnsignedChar, UnsignedCharStar, UnsignedCharStarStar,
                   UnsignedInt, UnsignedIntStar, UnsignedLong, 
                   UnsignedLongStar, UnsignedShort, Void;
IMPORT M3toC;
IMPORT Word;


(***************************************************************

                /usr/include/X11/X.h

 ***************************************************************)

(* Definitions for the X window system likely to be used by applications *)

CONST
  X_PROTOCOL 		=        11;             (* current protocol version *)
  X_PROTOCOL_REVISION 	=        0;             (* current minor version *)

(* Resources *)

TYPE
  Enumeration		=  Int;

  XID			=  UnsignedLong;

  Window		=  XID;
  WindowStar    	=  UNTRACED REF Window;
  WindowStarStar	=  UNTRACED REF WindowStar;

  Drawable		=  XID;
  Font		  	=  XID;
  Pixmap	  	=  XID;
  PixmapStar		=  UNTRACED REF Pixmap;
  Cursor	  	=  XID;
  Colormap	  	=  XID;
  ColormapStar		=  UNTRACED REF Colormap;
  GContext	  	=  XID;
  KeySym	  	=  XID;
  KeySymStar		=  UNTRACED REF KeySym;

  Mask		  	=  UnsignedLong;

  Atom		  	=  UnsignedLong;
  AtomStar		=  UNTRACED REF Atom;
  AtomStarStar		=  UNTRACED REF AtomStar;

  VisualID		=  UnsignedLong;

  Time			=  UnsignedLong;
  TimeStar		=  UNTRACED REF Time;

  KeyCode		=  UnsignedChar;
  KeyCodeStar		=  UNTRACED REF KeyCode;
  KeyCodeStarStar	=  UNTRACED REF KeyCodeStar;

TYPE
  RetIntProc    	=  PROCEDURE (): Int;
  RetCharStarProc	=  PROCEDURE (): CharStar;


(*****************************************************************
 * RESERVED RESOURCE AND CONSTANT DEFINITIONS
 *****************************************************************)

CONST
  None  =                       0;      (* universal null resource or null atom *)
  ParentRelative  =             1;      (* background pixmap in CreateWindow
                                           and ChangeWindowAttributes *)
  CopyFromParent  =             0;      (* border pixmap in CreateWindow
                                           and ChangeWindowAttributes
                                           special VisualID and special window
                                           class passed to CreateWindow *)
  PointerWindow  =              0;      (* destination window in SendEvent *)
  InputFocus  =                 1;      (* destination window in SendEvent *)
  PointerRoot  =                1;      (* focus window in SetInputFocus *)
  AnyPropertyType  =            0;      (* special Atom, passed to GetProperty *)
  AnyKey  =                     0;      (* special Key Code, passed to GrabKey *)
  AnyButton  =                  0;      (* special Button Code, passed to GrabButton *)
  AllTemporary  =               0;      (* special Resource ID passed to KillClient *)
  CurrentTime  =                0;      (* special Time *)
  NoSymbol  =                   0;      (* special KeySym *)

(***************************************************************** 
 * EVENT DEFINITIONS 
 *****************************************************************)

(* Input Event Masks. Used as event-mask window attribute and as arguments
   to Grab requests.  Not to be confused with event names.  *)

  NoEventMask =                 0 ;
  KeyPressMask =                Word.Shift (1, 0)  ;
  KeyReleaseMask =              Word.Shift (1, 1)  ;
  ButtonPressMask =             Word.Shift (1, 2)  ;
  ButtonReleaseMask =           Word.Shift (1, 3)  ;
  EnterWindowMask =             Word.Shift (1, 4)  ;
  LeaveWindowMask =             Word.Shift (1, 5)  ;
  PointerMotionMask =           Word.Shift (1, 6)  ;
  PointerMotionHintMask =       Word.Shift (1, 7)  ;
  Button1MotionMask =           Word.Shift (1, 8)  ;
  Button2MotionMask =           Word.Shift (1, 9)  ;
  Button3MotionMask =           Word.Shift (1, 10) ;
  Button4MotionMask =           Word.Shift (1, 11) ;
  Button5MotionMask =           Word.Shift (1, 12) ;
  ButtonMotionMask =            Word.Shift (1, 13) ;
  KeymapStateMask =             Word.Shift (1, 14) ;
  ExposureMask =                Word.Shift (1, 15) ;
  VisibilityChangeMask =        Word.Shift (1, 16) ;
  StructureNotifyMask =         Word.Shift (1, 17) ;
  ResizeRedirectMask =          Word.Shift (1, 18) ;
  SubstructureNotifyMask =      Word.Shift (1, 19) ;
  SubstructureRedirectMask =    Word.Shift (1, 20) ;
  FocusChangeMask =             Word.Shift (1, 21) ;
  PropertyChangeMask =          Word.Shift (1, 22) ;
  ColormapChangeMask =          Word.Shift (1, 23) ;
  OwnerGrabButtonMask =         Word.Shift (1, 24) ;

(* Event names.  Used in "type" field in XEvent structures.  Not to be
confused with event masks above.  They start from 2 because 0 and 1
are reserved in the protocol for errors and replies. *)

  KeyPress =                    2;
  KeyRelease =                  3;
  ButtonPress =                 4;
  ButtonRelease =               5;
  MotionNotify =                6;
  EnterNotify =                 7;
  LeaveNotify =                 8;
  FocusIn =                     9;
  FocusOut =                    10;
  KeymapNotify =                11;
  Expose =                      12;
  GraphicsExpose =              13;
  NoExpose =                    14;
  VisibilityNotify =            15;
  CreateNotify =                16;
  DestroyNotify =               17;
  UnmapNotify =                 18;
  MapNotify =                   19;
  MapRequest =                  20;
  ReparentNotify =              21;
  ConfigureNotify =             22;
  ConfigureRequest =            23;
  GravityNotify =               24;
  ResizeRequest =               25;
  CirculateNotify =             26;
  CirculateRequest =            27;
  PropertyNotify =              28;
  SelectionClear =              29;
  SelectionRequest =            30;
  SelectionNotify =             31;
  ColormapNotify =              32;
  ClientMessage =               33;
  MappingNotify =               34;
  LASTEvent =                   35;     (* must be bigger than any event # *)


(* Key masks. Used as modifiers to GrabButton and GrabKey, results of QueryPointer,
   state in various key-, mouse-, and button-related events. *)

  ShiftMask =                   Word.Shift (1, 0);
  LockMask =                    Word.Shift (1, 1);
  ControlMask =                 Word.Shift (1, 2);
  Mod1Mask =                    Word.Shift (1, 3);
  Mod2Mask =                    Word.Shift (1, 4);
  Mod3Mask =                    Word.Shift (1, 5);
  Mod4Mask =                    Word.Shift (1, 6);
  Mod5Mask =                    Word.Shift (1, 7);

(* modifier names.  Used to build a SetModifierMapping request or
   to read a GetModifierMapping request.  These correspond to the
   masks defined above. *)

  ShiftMapIndex =               0;
  LockMapIndex =                1;
  ControlMapIndex =             2;
  Mod1MapIndex =                3;
  Mod2MapIndex =                4;
  Mod3MapIndex =                5;
  Mod4MapIndex =                6;
  Mod5MapIndex =                7;


(* button masks.  Used in same manner as Key masks above. Not to be confused
   with button names below. *)

  Button1Mask =                 Word.Shift (1, 8);
  Button2Mask =                 Word.Shift (1, 9);
  Button3Mask =                 Word.Shift (1, 10);
  Button4Mask =                 Word.Shift (1, 11);
  Button5Mask =                 Word.Shift (1, 12);

  AnyModifier =                 Word.Shift (1, 15)  (* used in GrabButton, GrabKey *);


(* button names. Used as arguments to GrabButton and as detail in ButtonPress
   and ButtonRelease events.  Not to be confused with button masks above.
   Note that 0 is already defined above as "AnyButton".  *)

  Button1 =                     1;
  Button2 =                     2;
  Button3 =                     3;
  Button4 =                     4;
  Button5 =                     5;

(* Notify modes *)

  NotifyNormal =                0;
  NotifyGrab =                  1;
  NotifyUngrab =                2;
  NotifyWhileGrabbed =          3;

  NotifyHint =                  1;      (* for MotionNotify events *)
                       
(* Notify detail *)

  NotifyAncestor =              0;
  NotifyVirtual =               1;
  NotifyInferior =              2;
  NotifyNonlinear =             3;
  NotifyNonlinearVirtual =      4;
  NotifyPointer =               5;
  NotifyPointerRoot =           6;
  NotifyDetailNone =            7;

(* Visibility notify *)

  VisibilityUnobscured =        0;
  VisibilityPartiallyObscured = 1;
  VisibilityFullyObscured =     2;

(* Circulation request *)

  PlaceOnTop =                  0;
  PlaceOnBottom =               1;

(* protocol families *)

  FamilyInternet =              0;
  FamilyDECnet =                1;
  FamilyChaos =                 2;
  FamilyGeneric =               128;

(* Property notification *)

  PropertyNewValue =            0;
  PropertyDelete =              1;

(* Color Map notification *)

  ColormapUninstalled =         0;
  ColormapInstalled =           1;

(* GrabPointer, GrabButton, GrabKeyboard, GrabKey Modes *)

  GrabModeSync =                0;
  GrabModeAsync =               1;

(* GrabPointer, GrabKeyboard reply status *)

  GrabSuccess =                 0;
  AlreadyGrabbed =              1;
  GrabInvalidTime =             2;
  GrabNotViewable =             3;
  GrabFrozen =                  4;

(* AllowEvents modes *)

  AsyncPointer =                0;
  SyncPointer =                 1;
  ReplayPointer =               2;
  AsyncKeyboard =               3;
  SyncKeyboard =                4;
  ReplayKeyboard =              5;
  AsyncBoth =                   6;
  SyncBoth =                    7;

(* Used in SetInputFocus, GetInputFocus *)

  RevertToNone =                None;
  RevertToPointerRoot =         PointerRoot;
  RevertToParent =              2;

(*****************************************************************
 * ERROR CODES 
 *****************************************************************)

  Success =                     0;      (* everything's okay *)
  BadRequest =                  1;      (* bad request code *)
  BadValue =                    2;      (* int parameter out of range *)
  BadWindow =                   3;      (* parameter not a Window *)
  BadPixmap =                   4;      (* parameter not a Pixmap *)
  BadAtom =                     5;      (* parameter not an Atom *)
  BadCursor =                   6;      (* parameter not a Cursor *)
  BadFont =                     7;      (* parameter not a Font *)
  BadMatch =                    8;      (* parameter mismatch *)
  BadDrawable =                 9;      (* parameter not a Pixmap or Window *)
  BadAccess =                   10;     (* depending on context:
                                         - key/button already grabbed
                                         - attempt to free an illegal 
                                           cmap entry 
                                        - attempt to store into a read-only 
                                           color map entry.
                                        - attempt to modify the access control
                                           list from other than the local host.
                                        *)
  BadAlloc =                    11;     (* insufficient resources *)
  BadColor =                    12;     (* no such colormap *)
  BadGC =                       13;     (* parameter not a GC *)
  BadIDChoice =                 14;     (* choice not in range or already used *)
  BadName =                     15;     (* font or color name doesn't exist *)
  BadLength =                   16;     (* Request length incorrect *)
  BadImplementation =           17;     (* server is defective *)

  FirstExtensionError =         128;
  LastExtensionError =          255;

(*****************************************************************
 * WINDOW DEFINITIONS 
 *****************************************************************)

(* Window classes used by CreateWindow *)
(* Note that CopyFromParent is already defined as 0 above *)

  InputOutput =                 1;
  InputOnly =                   2;

(* Window attributes for CreateWindow and ChangeWindowAttributes *)

  CWBackPixmap =                Word.Shift (1, 0);
  CWBackPixel =                 Word.Shift (1, 1);
  CWBorderPixmap =              Word.Shift (1, 2);
  CWBorderPixel =               Word.Shift (1, 3);
  CWBitGravity =                Word.Shift (1, 4);
  CWWinGravity =                Word.Shift (1, 5);
  CWBackingStore =              Word.Shift (1, 6);
  CWBackingPlanes =             Word.Shift (1, 7);
  CWBackingPixel =              Word.Shift (1, 8);
  CWOverrideRedirect =          Word.Shift (1, 9);
  CWSaveUnder =                 Word.Shift (1, 10);
  CWEventMask =                 Word.Shift (1, 11);
  CWDontPropagate =             Word.Shift (1, 12);
  CWColormap =                  Word.Shift (1, 13);
  CWCursor =                    Word.Shift (1, 14);

(* ConfigureWindow structure *)

  CWX =                         Word.Shift (1, 0);
  CWY =                         Word.Shift (1, 1);
  CWWidth =                     Word.Shift (1, 2);
  CWHeight =                    Word.Shift (1, 3);
  CWBorderWidth =               Word.Shift (1, 4);
  CWSibling =                   Word.Shift (1, 5);
  CWStackMode =                 Word.Shift (1, 6);


(* Bit Gravity *)

  ForgetGravity =               0;
  NorthWestGravity =            1;
  NorthGravity =                2;
  NorthEastGravity =            3;
  WestGravity =                 4;
  CenterGravity =               5;
  EastGravity =                 6;
  SouthWestGravity =            7;
  SouthGravity =                8;
  SouthEastGravity =            9;
  StaticGravity =               10;

(* Window gravity + bit gravity above *)

  UnmapGravity =                0;

(* Used in CreateWindow for backing-store hint *)

  NotUseful =                   0;
  WhenMapped =                  1;
  Always =                      2;

(* Used in GetWindowAttributes reply *)

  IsUnmapped =                  0;
  IsUnviewable =                1;
  IsViewable =                  2;

(* Used in ChangeSaveSet *)

  SetModeInsert =               0;
  SetModeDelete =               1;

(* Used in ChangeCloseDownMode *)

  DestroyAll =                  0;
  RetainPermanent =             1;
  RetainTemporary =             2;

(* Window stacking method (in configureWindow) *)

  Above =                       0;
  Below =                       1;
  TopIf =                       2;
  BottomIf =                    3;
  Opposite =                    4;

(* Circulation direction *)

  RaiseLowest =                 0;
  LowerHighest =                1;

(* Property modes *)

  PropModeReplace =             0;
  PropModePrepend =             1;
  PropModeAppend =              2;

(*****************************************************************
 * GRAPHICS DEFINITIONS
 *****************************************************************)

(* graphics functions, as in GC.alu *)

  GXclear =                     16_0;           (* 0 *)
  GXand =                       16_1;           (* src AND dst *)
  GXandReverse =                16_2;           (* src AND NOT dst *)
  GXcopy =                      16_3;           (* src *)
  GXandInverted =               16_4;           (* NOT src AND dst *)
  GXnoop =                      16_5;           (* dst *)
  GXxor =                       16_6;           (* src XOR dst *)
  GXor =                        16_7;           (* src OR dst *)
  GXnor =                       16_8;           (* NOT src AND NOT dst *)
  GXequiv =                     16_9;           (* NOT src XOR dst *)
  GXinvert =                    16_a;           (* NOT dst *)
  GXorReverse =                 16_b;           (* src OR NOT dst *)
  GXcopyInverted =              16_c;           (* NOT src *)
  GXorInverted =                16_d;           (* NOT src OR dst *)
  GXnand =                      16_e;           (* NOT src OR NOT dst *)
  GXset =                       16_f;           (* 1 *)

(* LineStyle *)

  LineSolid =                   0;
  LineOnOffDash =               1;
  LineDoubleDash =              2;

(* capStyle *)

  CapNotLast =                  0;
  CapButt =                     1;
  CapRound =                    2;
  CapProjecting =               3;

(* joinStyle *)

  JoinMiter =                   0;
  JoinRound =                   1;
  JoinBevel =                   2;

(* fillStyle *)

  FillSolid =                   0;
  FillTiled =                   1;
  FillStippled =                2;
  FillOpaqueStippled =          3;

(* fillRule *)

  EvenOddRule =                 0;
  WindingRule =                 1;

(* subwindow mode *)

  ClipByChildren =              0;
  IncludeInferiors =            1;

(* SetClipRectangles ordering *)

  Unsorted =                    0;
  YSorted =                     1;
  YXSorted =                    2;
  YXBanded =                    3;

(* CoordinateMode for drawing routines *)

  CoordModeOrigin =             0;      (* relative to the origin *)
  CoordModePrevious =           1;      (* relative to previous point *)

(* Polygon shapes *)

  Complex =                     0;      (* paths may intersect *)
  Nonconvex =                   1;      (* no paths intersect, but not convex *)
  Convex =                      2;      (* wholly convex *)

(* Arc modes for PolyFillArc *)

  ArcChord =                    0;      (* join endpoints of arc *)
  ArcPieSlice =                 1;      (* join endpoints to center of arc *)

(* GC components: masks used in CreateGC, CopyGC, ChangeGC, OR'ed into
   GC.stateChanges *)

  GCFunction =                  Word.Shift (1, 0);
  GCPlaneMask =                 Word.Shift (1, 1);
  GCForeground =                Word.Shift (1, 2);
  GCBackground =                Word.Shift (1, 3);
  GCLineWidth =                 Word.Shift (1, 4);
  GCLineStyle =                 Word.Shift (1, 5);
  GCCapStyle =                  Word.Shift (1, 6);
  GCJoinStyle =                 Word.Shift (1, 7);
  GCFillStyle =                 Word.Shift (1, 8);
  GCFillRule =                  Word.Shift (1, 9); 
  GCTile =                      Word.Shift (1, 10);
  GCStipple =                   Word.Shift (1, 11);
  GCTileStipXOrigin =           Word.Shift (1, 12);
  GCTileStipYOrigin =           Word.Shift (1, 13);
  GCFont =                      Word.Shift (1, 14);
  GCSubwindowMode =             Word.Shift (1, 15);
  GCGraphicsExposures =         Word.Shift (1, 16);
  GCClipXOrigin =               Word.Shift (1, 17);
  GCClipYOrigin =               Word.Shift (1, 18);
  GCClipMask =                  Word.Shift (1, 19);
  GCDashOffset =                Word.Shift (1, 20);
  GCDashList =                  Word.Shift (1, 21);
  GCArcMode =                   Word.Shift (1, 22);

  GCLastBit =                   22;

(*****************************************************************
 * FONTS 
 *****************************************************************)

(* used in QueryFont -- draw direction *)

  FontLeftToRight =             0;
  FontRightToLeft =             1;

  FontChange =                  255;

(*****************************************************************
 *  IMAGING 
 *****************************************************************)

(* ImageFormat -- PutImage, GetImage *)

  XYBitmap =                    0;      (* depth 1, XYFormat *)
  XYPixmap =                    1;      (* depth == drawable depth *)
  ZPixmap =                     2;      (* depth == drawable depth *)

(*****************************************************************
 *  COLOR MAP STUFF 
 *****************************************************************)

(* For CreateColormap *)

  AllocNone =                   0;      (* create map with no entries *)
  AllocAll =                    1;      (* allocate entire map writeable *)


(* Flags used in StoreNamedColor, StoreColors *)

  DoRed =                       Word.Shift (1, 0);
  DoGreen =                     Word.Shift (1, 1);
  DoBlue =                      Word.Shift (1, 2);

(*****************************************************************
 * CURSOR STUFF
 *****************************************************************)

(* QueryBestSize Class *)

  CursorShape =                 0;      (* largest size that can be displayed *)
  TileShape =                   1;      (* size tiled fastest *)
  StippleShape =                2;      (* size stippled fastest *)

(***************************************************************** 
 * KEYBOARD/POINTER STUFF
 *****************************************************************)

  AutoRepeatModeOff =           0;
  AutoRepeatModeOn =            1;
  AutoRepeatModeDefault =       2;

  LedModeOff =                  0;
  LedModeOn =                   1;

(* masks for ChangeKeyboardControl *)

  KBKeyClickPercent =           Word.Shift (1, 0);
  KBBellPercent =               Word.Shift (1, 1);
  KBBellPitch =                 Word.Shift (1, 2);
  KBBellDuration =              Word.Shift (1, 3);
  KBLed =                       Word.Shift (1, 4);
  KBLedMode =                   Word.Shift (1, 5);
  KBKey =                       Word.Shift (1, 6);
  KBAutoRepeatMode =            Word.Shift (1, 7);

  MappingSuccess =              0;
  MappingBusy =                 1;
  MappingFailed =               2;

  MappingModifier =             0;
  MappingKeyboard =             1;
  MappingPointer =              2;

(*****************************************************************
 * SCREEN SAVER STUFF 
 *****************************************************************)

  DontPreferBlanking =          0;
  PreferBlanking =              1;
  DefaultBlanking =             2;

  DisableScreenSaver =          0;
  DisableScreenInterval =       0;

  DontAllowExposures =          0;
  AllowExposures =              1;
  DefaultExposures =            2;

(* for ForceScreenSaver *)

  ScreenSaverReset =            0;
  ScreenSaverActive =           1;

(*****************************************************************
 * HOSTS AND CONNECTIONS
 *****************************************************************)

(* for ChangeHosts *)

  HostInsert =                  0;
  HostDelete =                  1;

(* for ChangeAccessControl *)

  EnableAccess =                1;      
  DisableAccess =               0;

(* Display classes  used in opening the connection 
 * Note that the statically allocated ones are even numbered and the
 * dynamically changeable ones are odd numbered *)

  StaticGray =                  0;
  GrayScale =                   1;
  StaticColor =                 2;
  PseudoColor =                 3;
  TrueColor =                   4;
  DirectColor =                 5;


(* Byte order  used in imageByteOrder and bitmapBitOrder *)

  LSBFirst =                    0;
  MSBFirst =                    1;

(* For users of XMultiplexInput.  This routine is VMS only *)

  XMINoBlock =                  1;
  XMINewInput =                 2;


(***************************************************************

                /usr/include/X11/Xlib.h

 ***************************************************************)

(* $XConsortium: Xlib.h,v 11.179 89/12/12 13:57:19 jim Exp $ *)
(* 
 * Copyright 1985, 1986, 1987 by the Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided 
 * that the above copyright notice appear in all copies and that both that 
 * copyright notice and this permission notice appear in supporting 
 * documentation, and that the name of M.I.T. not be used in advertising
 * or publicity pertaining to distribution of the software without specific, 
 * written prior permission. M.I.T. makes no representations about the 
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * The X Window System is a Trademark of MIT.
 *
 *)


(*
 *      Xlib.h - Header definition and support file for the C subroutine
 *      interface library (Xlib) to the X Window System Protocol (V11).
 *      Structures and symbols starting with "_" are private to the library.
 *)

TYPE
  Bool		= Int;
  BoolStar	= UNTRACED REF Bool;
  Status	= Int;

CONST
  True   	= 1;
  False  	= 0;

CONST
  QueuedAlready        = 0;
  QueuedAfterReading   = 1;
  QueuedAfterFlush     = 2;


(* ?!?!?!?!
#define ConnectionNumber(dpy)   ((dpy)->fd)
#define RootWindow(dpy, scr)    (((dpy)->screens[(scr)]).root)
#define DefaultScreen(dpy)      ((dpy)->default_screen)
#define DefaultRootWindow(dpy)  (((dpy)->screens[(dpy)->default_screen]).root)
#define DefaultVisual(dpy, scr) (((dpy)->screens[(scr)]).root_visual)
#define DefaultGC(dpy, scr)     (((dpy)->screens[(scr)]).default_gc)
#define BlackPixel(dpy, scr)    (((dpy)->screens[(scr)]).black_pixel)
#define WhitePixel(dpy, scr)    (((dpy)->screens[(scr)]).white_pixel)
#define AllPlanes               (~0)
#define QLength(dpy)            ((dpy)->qlen)
#define DisplayWidth(dpy, scr)  (((dpy)->screens[(scr)]).width)
#define DisplayHeight(dpy, scr) (((dpy)->screens[(scr)]).height)
#define DisplayWidthMM(dpy, scr)(((dpy)->screens[(scr)]).mwidth)
#define DisplayHeightMM(dpy, scr)(((dpy)->screens[(scr)]).mheight)
#define DisplayPlanes(dpy, scr) (((dpy)->screens[(scr)]).root_depth)
#define DisplayCells(dpy, scr)  (DefaultVisual((dpy), (scr))->map_entries)
#define ScreenCount(dpy)        ((dpy)->nscreens)
#define ServerVendor(dpy)       ((dpy)->vendor)
#define ProtocolVersion(dpy)    ((dpy)->proto_major_version)
#define ProtocolRevision(dpy)   ((dpy)->proto_minor_version)
#define VendorRelease(dpy)      ((dpy)->release)
#define DisplayString(dpy)      ((dpy)->display_name)
#define DefaultDepth(dpy, scr)  (((dpy)->screens[(scr)]).root_depth)
#define DefaultColormap(dpy, scr)(((dpy)->screens[(scr)]).cmap)
#define BitmapUnit(dpy)         ((dpy)->bitmap_unit)
#define BitmapBitOrder(dpy)     ((dpy)->bitmap_bit_order)
#define BitmapPad(dpy)          ((dpy)->bitmap_pad)
#define ImageByteOrder(dpy)     ((dpy)->byte_order)
#define NextRequest(dpy)        ((dpy)->request + 1)
#define LastKnownRequestProcessed(dpy)  ((dpy)->last_request_read)

(* macros for screen oriented applications (toolkit) *)
#define ScreenOfDisplay(dpy, scr)(&((dpy)->screens[(scr)]))
#define DefaultScreenOfDisplay(dpy) (&((dpy)->screens[(dpy)->default_screen]))
#define DisplayOfScreen(s)      ((s)->display)
#define RootWindowOfScreen(s)   ((s)->root)
#define BlackPixelOfScreen(s)   ((s)->black_pixel)
#define WhitePixelOfScreen(s)   ((s)->white_pixel)
#define DefaultColormapOfScreen(s)((s)->cmap)
#define DefaultDepthOfScreen(s) ((s)->root_depth)
#define DefaultGCOfScreen(s)    ((s)->default_gc)
#define DefaultVisualOfScreen(s)((s)->root_visual)
#define WidthOfScreen(s)        ((s)->width)
#define HeightOfScreen(s)       ((s)->height)
#define WidthMMOfScreen(s)      ((s)->mwidth)
#define HeightMMOfScreen(s)     ((s)->mheight)
#define PlanesOfScreen(s)       ((s)->root_depth)
#define CellsOfScreen(s)        (DefaultVisualOfScreen((s))->map_entries)
#define MinCmapsOfScreen(s)     ((s)->min_maps)
#define MaxCmapsOfScreen(s)     ((s)->max_maps)
#define DoesSaveUnders(s)       ((s)->save_unders)
#define DoesBackingStore(s)     ((s)->backing_store)
#define EventMaskOfScreen(s)    ((s)->root_input_mask)
?!?!?! *)

(*
 * Extensions need a way to hang private data on some structures.
 *)

TYPE
  XExtData = RECORD
        number: Int;              (* number returned by XRegisterExtension *)
        next: XExtDataStar;	  (* next item on list of data for structure *)
        free_private: RetIntProc; (* called to free private storage *)
        private_data: CharStar;   (* data private to this extension. *)
  END;
  XExtDataStar     =  UNTRACED REF XExtData;
  XExtDataStarStar =  UNTRACED REF XExtDataStar;

(*
 * This file contains structures used by the extension mechanism.
 *)

TYPE
  XExtCodes = RECORD
        extension: Int;           (* extension number *)
        major_opcode: Int;        (* major op-code assigned by server *)
        first_event: Int;         (* first event number for the extension *)
        first_error: Int;         (* first error number for the extension *)
  END;
  XExtCodesStar  =  UNTRACED REF XExtCodes;

(*
 * This structure is private to the library.
 *)

TYPE
  XExtension = RECORD             (* private to extension mechanism *)
        next: XExtensionStar;     (* next in list *)
        codes: XExtCodes;         (* public information, all extension told *)
        create_GC: RetIntProc;    (* routine to call when GC created *)
        copy_GC: RetIntProc;      (* routine to call when GC copied *)
        flush_GC: RetIntProc;     (* routine to call when GC flushed *)
        free_GC: RetIntProc;      (* routine to call when GC freed *)
        create_Font: RetIntProc;  (* routine to call when Font created *)
        free_Font: RetIntProc;    (* routine to call when Font freed *)
        close_display: RetIntProc;(* routine to call when connection closed *)
        error: RetIntProc;        (* who to call when an error occurs *)
        error_string: RetCharStarProc;  (* routine to supply error string *)
        name: CharStar;           (* name of this extension *)
  END;
  XExtensionStar = UNTRACED REF XExtension;

(*
 * Data structure for retrieving info about pixmap formats.
 *)

TYPE
  XPixmapFormatValues = RECORD
    depth: Int;
    bits_per_pixel: Int;
    scanline_pad: Int;
  END;    
  XPixmapFormatValuesStar  =  UNTRACED REF XPixmapFormatValues;


(*
 * Data structure for setting graphics context.
 *)
TYPE
  XGCValues = RECORD
        function: Int;           (* logical operation *)
        plane_mask: UnsignedLong;(* plane mask *)
        foreground: UnsignedLong;(* foreground pixel *)
        background: UnsignedLong;(* background pixel *)
        line_width: Int;         (* line width *)
        line_style: Int;         (* LineSolid, LineOnOffDash, LineDoubleDash *)
        cap_style: Int;          (* CapNotLast, CapButt, 
                                   CapRound, CapProjecting *)
        join_style: Int;         (* JoinMiter, JoinRound, JoinBevel *)
        fill_style: Int;         (* FillSolid, FillTiled, 
                                   FillStippled, FillOpaeueStippled *)
        fill_rule: Int;          (* EvenOddRule, WindingRule *)
        arc_mode: Int;           (* ArcChord, ArcPieSlice *)
        tile: Pixmap;            (* tile pixmap for tiling operations *)
        stipple: Pixmap;         (* stipple 1 plane pixmap for stipping *)
        ts_x_origin: Int;        (* offset for tile or stipple operations *)
        ts_y_origin: Int;
        font: Font;              (* default text font for text operations *)
        subwindow_mode: Int;     (* ClipByChildren, IncludeInferiors *)
        graphics_exposures: Bool;(* boolean, should exposures be generated *)
        clip_x_origin: Int;      (* origin for clipping *)
        clip_y_origin: Int;
        clip_mask: Pixmap;       (* bitmap clipping; other calls for rects *)
        dash_offset: Int;        (* patterned/dashed line information *)
        dashes: Char;
  END;

TYPE
  XGCValuesStar  =  UNTRACED REF XGCValues;

(*
 * Graphics context.  All Xlib routines deal in this rather than
 * in raw protocol GContext ID's.  This is so that the library can keep
 * a "shadow" set of values, and thus avoid passing values over the
 * wire which are not in fact changing. 
 *)

TYPE
  GC = UNTRACED REF RECORD
    ext_data: XExtDataStar;      (* hook for extension to hang data *)
    gid: GContext;               (* protocol ID for graphics context *)
    rects: Bool;          (* boolean: TRUE if clipmask is list of rectangles *)
    dashes: Bool;             (* boolean: TRUE if dash-list is really a list *)
    dirty: UnsignedLong;         (* cache dirty bits *)
    values: XGCValues;           (* shadow structure of values *)
  END;

(*
 * Visual structure; contains information about colormapping possible.
 *)

TYPE
  Visual = RECORD
        ext_data: XExtDataStar;  (* hook for extension to hang data *)
        visualid: VisualID;      (* visual id of this visual *)
        class: Int;              (* class of screen (monochrome, etc.) *)
        red_mask, green_mask, blue_mask: UnsignedLong;  (* mask values *)
        bits_per_rgb: Int;       (* log base 2 of distinct color values *)
        map_entries: Int;        (* color map entries *)
  END;
  VisualStar   =  UNTRACED REF Visual;


(*
 * Depth structure; contains information for each possible depth.
 *)     

TYPE
  Depth = RECORD
        depth: Int;              (* this depth (Z) of the depth *)
        nvisuals: Int;           (* number of Visual types at this depth *)
        visuals: VisualStar;     (* list of visuals possible at this depth *)
  END;
  DepthStar    =  UNTRACED REF Depth;


(*
 * Information about the screen.
 *)

TYPE Screen = RECORD
        ext_data: XExtDataStar;  (* hook for extension to hang data *)
        display: DisplayStar;    (* back pointer to display structure *)
        root: Window;            (* Root window id. *)
        width, height: Int;      (* width and height of screen *)
        mwidth, mheight: Int;    (* width and height of  in millimeters *)
        ndepths: Int;            (* number of depths possible *)
        depths: DepthStar;       (* list of allowable depths on the screen *)
        root_depth: Int;         (* bits per pixel *)
        root_visual: VisualStar; (* root visual *)
        default_gc: GC;          (* GC for the root root visual *)
        cmap: Colormap;          (* default color map *)
        white_pixel: UnsignedLong;
        black_pixel: UnsignedLong; (* White and Black pixel values *)
        max_maps, min_maps: Int; (* max and min color maps *)
        backing_store: Int;      (* Never, WhenMapped, Always *)
        save_unders: Bool;       
        root_input_mask: Long;   (* initial root input mask *)
  END;
  ScreenStar    =  UNTRACED REF Screen;

(*
 * Format structure; describes ZFormat data the screen will understand.
 *)

TYPE
  ScreenFormat = RECORD
        ext_data: XExtDataStar;  (* hook for extension to hang data *)
        depth: Int;              (* depth of this image format *)
        bits_per_pixel: Int;     (* bits/pixel at this depth *)
        scanline_pad: Int;       (* scanline must padded to this multiple *)
  END;
  ScreenFormatStar     =  UNTRACED REF ScreenFormat;


(*
 * Data structure for setting window attributes.
 *)

TYPE
  XSetWindowAttributes = RECORD
    background_pixmap: Pixmap;   (* background or None or ParentRelative *)
    background_pixel: UnsignedLong;     (* background pixel *)
    border_pixmap: Pixmap;       (* border of the window *)
    border_pixel: UnsignedLong;  (* border pixel value *)
    bit_gravity: Int;            (* one of bit gravity values *)
    win_gravity: Int;            (* one of the window gravity values *)
    backing_store: Int;          (* NotUseful, WhenMapped, Always *)
    backing_planes: UnsignedLong;(* planes to be preseved if possible *)
    backing_pixel: UnsignedLong; (* value to use in restoring planes *)
    save_under: Bool;            (* should bits under be saved? (popups) *)
    event_mask: Long;            (* set of events that should be saved *)
    do_not_propagate_mask: Long; (* set of events that should not propagate *)
    override_redirect: Bool;     (* boolean value for override-redirect *)
    colormap: Colormap;          (* color map to be associated with window *)
    cursor: Cursor;              (* cursor to be displayed (or None) *)
  END;

  XWindowAttributes = RECORD
    x, y: Int;                   (* location of window *)
    width, height: Int;          (* width and height of window *)
    border_width: Int;           (* border width of window *)
    depth: Int;                  (* depth of window *)
    visual: VisualStar;          (* the associated visual structure *)
    root: Window;                (* root of screen containing window *)
    class: Int;                  (* InputOutput, InputOnly*)
    bit_gravity: Int;            (* one of bit gravity values *)
    win_gravity: Int;            (* one of the window gravity values *)
    backing_store: Int;          (* NotUseful, WhenMapped, Always *)
    backing_planes: UnsignedLong;(* planes to be preserved if possible *)
    backing_pixel: UnsignedLong; (* value to be used when restoring planes *)
    save_under: Bool;            (* boolean, should bits under be saved? *)
    colormap: Colormap;          (* color map to be associated with window *)
    map_installed: Bool;         (* boolean, is color map currently installed*)
    map_state: Int;              (* IsUnmapped, IsUnviewable, IsViewable *)
    all_event_masks: Long;       (* set of events all people have interest in*)
    your_event_mask: Long;       (* my event mask *)
    do_not_propagate_mask: Long; (* set of events that should not propagate *)
    override_redirect: Bool;     (* boolean value for override-redirect *)
    screen: ScreenStar;          (* back pointer to correct screen *)
  END;

TYPE
  XSetWindowAttributesStar    =  UNTRACED REF XSetWindowAttributes;
  XWindowAttributesStar       =  UNTRACED REF XWindowAttributes;

(*
 * Data structure for host setting; getting routines.
 *
 *)

TYPE
  XHostAddress = RECORD
        family: Int;             (* for example AF_DNET *)
        length: Int;             (* length of address, in bytes *)
        address: CharStar;       (* pointer to where to find the bytes *)
  END;
  XHostAddressStar   =  UNTRACED REF XHostAddress;

(*
 * Data structure for "image" data, used by image manipulation routines.
 *)

TYPE
  CreateImageProc = PROCEDURE (): XImageStar;
  DestroyImageProc = PROCEDURE (i: XImageStar): Int;
  GetPixelProc = PROCEDURE (i: XImageStar; x, y: Int): UnsignedLong;
  PutPixelProc = PROCEDURE (i: XImageStar; x, y: Int; p: UnsignedLong): Int;
  SubImageProc = PROCEDURE (i: XImageStar; 
                            x, y: Int; w, h: UnsignedInt): XImageStar;
  AddPixelProc = PROCEDURE(i: XImageStar): Int;

  XImage = RECORD
    width, height: Int;          (* size of image *)
    xoffset: Int;                (* number of pixels offset in X direction *)
    format: Int;                 (* XYBitmap, XYPixmap, ZPixmap *)
    data: CharStar;              (* pointer to image data *)
    byte_order: Int;             (* data byte order, LSBFirst, MSBFirst *)
    bitmap_unit: Int;            (* quant. of scanline 8, 16, 32 *)
    bitmap_bit_order: Int;       (* LSBFirst, MSBFirst *)
    bitmap_pad: Int;             (* 8, 16, 32 either XY or ZPixmap *)
    depth: Int;                  (* depth of image *)
    bytes_per_line: Int;         (* accelarator to next line *)
    bits_per_pixel: Int;         (* bits per pixel (ZPixmap) *)
    red_mask: UnsignedLong;      (* bits in z arrangment *)
    green_mask: UnsignedLong;
    blue_mask: UnsignedLong;
    obdata: CharStar;            (* hook for the object routines to hang on *)
    f: RECORD                    (* image manipulation routines *)
        create_image: CreateImageProc;
        destroy_image: DestroyImageProc;
        get_pixel: GetPixelProc;
        put_pixel: PutPixelProc;
        sub_image: SubImageProc;
        add_pixel: AddPixelProc;
    END;
  END;
  XImageStar  =  UNTRACED REF XImage;

(* 
 * Data structure for XReconfigureWindow
 *)

TYPE
  XWindowChanges = RECORD
    x, y: Int;
    width, height: Int;
    border_width: Int;
    sibling: Window;
    stack_mode: Int;
  END;
  XWindowChangesStar  =  UNTRACED REF XWindowChanges;

(*
 * Data structure used by color operations
 *)

TYPE
  XColor = RECORD
    pixel: UnsignedLong;
    red, green, blue: UnsignedShort;
    flags: Char;               (* do_red, do_green, do_blue *)
    pad: Char;
  END;
  XColorStar = UNTRACED REF XColor;

(* 
 * Data structures for graphics operations.  On most machines, these are
 * congruent with the wire protocol structures, so reformatting the data
 * can be avoided on these architectures.
 *)

TYPE

  XSegment	=  RECORD
		     x1, y1, x2, y2: Short;
		   END;
  XSegmentStar	=  UNTRACED REF XSegment;

  XPoint	=  RECORD
		     x, y: Short;
		   END;
  XPointStar	=  UNTRACED REF XPoint;
    
  XRectangle	=  RECORD
		     x, y: Short;
		     width, height: UnsignedShort;
		   END;
  XRectangleStar=  UNTRACED REF XRectangle;

  XArc		=  RECORD
		     x, y: Short;
		     width, height: UnsignedShort;
		     angle1, angle2: Short;
		   END;
  XArcStar	=  UNTRACED REF XArc;


(* Data structure for XChangeKeyboardControl *)

TYPE
  XKeyboardControl = RECORD
        key_click_percent: Int;
        bell_percent: Int;
        bell_pitch: Int;
        bell_duration: Int;
        led: Int;
        led_mode: Int;
        key: Int;
        auto_repeat_mode: Int;   (* On, Off, Default *)
  END;
  XKeyboardControlStar = UNTRACED REF XKeyboardControl;

(* Data structure for XGetKeyboardControl *)

TYPE
  XKeyboardState = RECORD
        key_click_percent: Int;
        bell_percent: Int;
        bell_pitch, bell_duration: UnsignedInt;
        led_mask: UnsignedLong;
        global_auto_repeat: Int;
        auto_repeats: ARRAY [0 .. 31] OF Char;
  END;
  XKeyboardStateStar  =  UNTRACED REF XKeyboardState;

(* Data structure for XGetMotionEvents.  *)

TYPE
  XTimeCoord = RECORD
        time: Time;
        x, y: Short;
  END;
  XTimeCoordStar  = UNTRACED REF XTimeCoord;

(* Data structure for X{Set,Get}ModifierMapping *)

TYPE
  XModifierKeymap = RECORD
        max_keypermod: Int;      (* The server's max # of keys per modifier *)
        modifiermap: KeyCodeStar;(* An 8 by max_keypermod array of modifiers *)
  END;
  XModifierKeymapStar  =  UNTRACED REF XModifierKeymap;

(*
 * internal atoms used for ICCCM things; not to be used by client
 *)

TYPE
  DisplayAtoms = RECORD
    text: Atom;
    wm_state: Atom;
    wm_protocols: Atom;
    wm_save_yourself: Atom;
    wm_change_state: Atom;
    wm_colormap_windows: Atom;
    (* add new atoms to end of list *)
  END;
  DisplayAtomsStar = UNTRACED REF DisplayAtoms;

(*
 * Display datatype maintaining display specific data.
 *)

TYPE
  Display = RECORD
        ext_data: XExtDataStar;  (* hook for extension to hang data *)
        next: DisplayStar;       (* next open Display on list *)
        fd: Int;                 (* Network socket. *)
        lock: Int;               (* is someone in critical section? *)
        proto_major_version: Int;(* maj. version of server's X protocol *)
        proto_minor_version: Int;(* minor version of servers X protocol *)
        vendor: CharStar;        (* vendor of the server hardware *)
        resource_base: Long;     (* resource ID base *)
        resource_mask: Long;     (* resource ID mask bits *)
        resource_id: Long;       (* allocator current ID *)
        resource_shift: Int;     (* allocator shift to correct bits *)
        resource_alloc: PROCEDURE(): XID; (* allocator function *)
        byte_order: Int;         (* screen byte order, LSBFirst, MSBFirst *)
        bitmap_unit: Int;        (* padding and data requirements *)
        bitmap_pad: Int;         (* padding requirements on bitmaps *)
        bitmap_bit_order: Int;   (* LeastSignificant or MostSignificant *)
        nformats: Int;           (* number of pixmap formats in list *)
        pixmap_format: ScreenFormatStar;    (* pixmap format list *)
        vnumber: Int;            (* Xlib's X protocol version number. *)
        release: Int;            (* release of the server *)
        head, tail: XQEventStar; (* Input event queue. *)
        qlen: Int;               (* Length of input event queue *)
        last_request_read: UnsignedLong; (* seq number of last event read *)
        request: UnsignedLong;   (* sequence number of last request. *)
        last_req: CharStar;      (* beginning of last request, or dummy *)
        buffer: CharStar;        (* Output buffer starting address. *)
        bufptr: CharStar;        (* Output buffer index pointer. *)
        bufmax: CharStar;        (* Output buffer maximum+1 address. *)
        max_request_size: UnsignedLong; (* max number 32 bit words in request*)
        db: ADDRESS;		 (*?!? wrong ?!?*)
        synchandler: XSynchronize;(* Synchronization handler *)
        display_name: CharStar; (* "host:display" string used on this connect*)
        default_screen: Int;     (* default screen for operations *)
        nscreens: Int;           (* number of screens on this server*)
        screens: ScreenStar;     (* pointer to list of screens *)
        motion_buffer: UnsignedLong;    (* size of motion buffer *)
        current: Window;         (* for use internally for Keymap notify *)
        min_keycode: Int;        (* minimum defined keycode *)
        max_keycode: Int;        (* maximum defined keycode *)
        keysyms: KeySymStar;     (* This server's keysyms *)
        modifiermap: XModifierKeymapStar;   (* This server's modifier keymap *)
        keysyms_per_keycode: Int;(* number of rows *)
        xdefaults: CharStar;     (* contents of defaults from server *)
        scratch_buffer: CharStar;(* place to hang scratch buffer *)
        scratch_length: UnsignedLong;   (* length of scratch buffer *)
        ext_number: Int;         (* extension number on this display *)
        ext_procs: XExtensionStar; (* extensions initialized on this display *)
        (*
         * the following can be fixed size, as the protocol defines how
         * much address space is available. 
         * While this could be done using the extension vector, there
         * may be MANY events processed, so a search through the extension
         * list to find the right procedure for each event might be
         * expensive if many extensions are being used.
         *)
        event_vec: ARRAY [0 .. 127] OF PROCEDURE(): Bool;
        wire_vec: ARRAY [0 .. 127] OF PROCEDURE(): Status;
        lock_meaning: KeySym;       (* for XLookupString *)
        key_bindings: ADDRESS;      (* for XLookupString *) (*?!? wrong ?!?*)
        cursor_font: Font;          (* for XCreateFontCursor *)
        (*
         * ICCCM information, version 1
         *)
        atoms: DisplayAtomsStar;
        reconfigure_wm_window: RECORD (* for XReconfigureWMWindow *)
            sequence_number: Long;
            old_handler: PROCEDURE(): Int;
            succeeded: Bool;
        END;
        (*
         * additional connection info
         *)
        flags: UnsignedLong;       (* internal connection flags *)
        mode_switch: UnsignedInt;  (* keyboard group modifiers *)
  END;
  DisplayStar   =   UNTRACED REF Display;


(*
 * A "XEvent" structure always  has type as the first entry.  This 
 * uniquely identifies what  kind of event it is.  The second entry
 * is always a pointer to the display the event was read from.
 * The third entry is always a window of one type or another,
 * carefully selected to be useful to toolkit dispatchers.  (Except
 * for keymap events, which have no window.) You
 * must not change the order of the three elements or toolkits will
 * break! The pointer to the generic event must be cast before use to 
 * access any other information in the structure.
 *)

(*
 * Definitions of specific events.
 *)
TYPE
  XKeyEvent = RECORD
     type: Int;                (* of event *)
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;           (* "event" window it is reported relative to *)
     root: Window;             (* root window that the event occured on *)
     subwindow: Window;        (* child window *)
     time: Time;               (* milliseconds *)
     x, y: Int;                (* pointer x, y coordinates in event window *)
     x_root, y_root: Int;      (* coordinates relative to root *)
     state: UnsignedInt;       (* key or button mask *)
     keycode: UnsignedInt;     (* detail *)
     same_screen: Bool         (* same screen flag *)
              END;

  XKeyEventStar			= UNTRACED REF XKeyEvent;
  XKeyPressedEvent		= XKeyEvent;
  XKeyPressedEventStar		= UNTRACED REF XKeyPressedEvent;
  XKeyReleasedEvent		= XKeyEvent;
  XKeyReleasedEventStar		= UNTRACED REF XKeyReleasedEvent;

TYPE
  XButtonEvent = RECORD
     type: Int;                (* of event *)
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;           (* "event" window it is reported relative to *)
     root: Window;             (* root window that the event occured on *)
     subwindow: Window;        (* child window *)
     time: Time;               (* milliseconds *)
     x, y: Int;                (* poInter x, y coordinates in event window *)
     x_root, y_root: Int;      (* coordinates relative to root *)
     state: UnsignedInt;       (* key or button mask *)
     button: UnsignedInt;      (* detail *)
     same_screen: Bool         (* same screen flag *)
              END;

  XButtonEventStar		= UNTRACED REF   XButtonEvent;
  XButtonPressedEvent		= XButtonEvent;
  XButtonPressedEventStar	= UNTRACED REF  XButtonPressedEvent;
  XButtonReleasedEvent		= XButtonEvent;
  XButtonReleasedEventStar	= UNTRACED REF  XButtonReleasedEvent;

TYPE
  XMotionEvent = RECORD
     type: Int;                (* of event *)
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;           (* "event" window reported relative to *)
     root: Window;             (* root window that the event occured on *)
     subwindow: Window;        (* child window *)
     time: Time;               (* milliseconds *)
     x, y: Int;                (* pointer x, y coordinates in event window *)
     x_root, y_root: Int;      (* coordinates relative to root *)
     state: UnsignedInt;       (* key or button mask *)
     is_hint: Char;            (* detail *)
     same_screen: Bool         (* same screen flag *)
              END;

  XMotionEventStar		= UNTRACED REF   XMotionEvent;
  XPointerMovedEvent		= XMotionEvent ;
  XPointerMovedEventStar	= UNTRACED REF  XPointerMovedEvent;

TYPE
  XCrossingEvent = RECORD
     type: Int;                (* of event *)
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;           (* "event" window reported relative to *)
     root: Window;             (* root window that the event occured on *)
     subwindow: Window;        (* child window *)
     time: Time;               (* milliseconds *)
     x, y: Int;                (* pointer x, y coordinates in event window *)
     x_root, y_root: Int;      (* coordinates relative to root *)
     mode: Int;                (* NotifyNormal, NotifyGrab, NotifyUngrab *)
     detail: Int;
    (*
     * NotifyAncestor, NotifyVirtual, NotifyInferior, 
     * NotifyNonLinear,NotifyNonLinearVirtual
     *)
     same_screen: Bool;        (* same screen flag *)
     focus: Bool;              (* boolean focus *)
     state: UnsignedInt        (* key or button mask *)
              END;

  XCrossingEventStar		= UNTRACED REF   XCrossingEvent;
  XEnterWindowEvent		= XCrossingEvent;
  XEnterWindowEventStar		= UNTRACED REF XEnterWindowEvent;
  XLeaveWindowEvent		= XCrossingEvent;
  XLeaveWindowEventStar		= UNTRACED REF XLeaveWindowEvent;

TYPE
  XFocusChangeEvent = RECORD
     type: Int;                (* FocusIn or FocusOut *)
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;           (* window of event *)
     mode: Int;                (* NotifyNormal, NotifyGrab, NotifyUngrab *)
     detail: Int
    (*
     * NotifyAncestor, NotifyVirtual, NotifyInferior, 
     * NotifyNonLinear,NotifyNonLinearVirtual, NotifyPointer,
     * NotifyPointerRoot, NotifyDetailNone 
     *)
              END;

  XFocusChangeEventStar		= UNTRACED REF   XFocusChangeEvent;
  XFocusInEvent			= XFocusChangeEvent;
  XFocusInEventStar		= UNTRACED REF XFocusInEvent;
  XFocusOutEvent		= XFocusChangeEvent;
  XFocusOutEventStar		= UNTRACED REF XFocusOutEvent;

(* generated on EnterWindow and FocusIn  when KeyMapState selected *)

TYPE
  XKeymapEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;
     key_vector: ARRAY [0..31] OF Char
              END;

  XKeymapEventStar		= UNTRACED REF   XKeymapEvent;

TYPE
  XExposeEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;
     x, y: Int;
     width, height: Int;
     count: Int                (* if non-zero, at least this many more *)
              END;

  XExposeEventStar		= UNTRACED REF   XExposeEvent;

TYPE
  XGraphicsExposeEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     drawable: Drawable;
     x, y: Int;
     width, height: Int;
     count: Int;               (* if non-zero, at least this many more *)
     major_code: Int;          (* core is CopyArea or CopyPlane *)
     minor_code: Int           (* not defined in the core *)
              END;

  XGraphicsExposeEventStar	= UNTRACED REF   XGraphicsExposeEvent;

TYPE
  XNoExposeEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     drawable: Drawable;
     major_code: Int;          (* core is CopyArea or CopyPlane *)
     minor_code: Int           (* not defined in the core *)
              END;

  XNoExposeEventStar		= UNTRACED REF   XNoExposeEvent;

TYPE
  XVisibilityEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;
     state: Int                (* Visibility state *)
              END;

  XVisibilityEventStar		= UNTRACED REF   XVisibilityEvent;

TYPE
  XCreateWindowEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     parent: Window;           (* parent of the window *)
     window: Window;           (* window id of window created *)
     x, y: Int;                (* window location *)
     width, height: Int;       (* size of window *)
     border_width: Int;        (* border width *)
     override_redirect: Bool   (* creation should be overridden *)
              END;

  XCreateWindowEventStar	= UNTRACED REF   XCreateWindowEvent;

TYPE
  XDestroyWindowEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     event: Window;
     window: Window
              END;

  XDestroyWindowEventStar	= UNTRACED REF   XDestroyWindowEvent;

TYPE
  XUnmapEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     event: Window;
     window: Window;
     from_configure: Bool
              END;

  XUnmapEventStar		= UNTRACED REF   XUnmapEvent;

TYPE
  XMapEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     event: Window;
     window: Window;
     override_redirect: Bool (* boolean, is override set... *)
              END;

  XMapEventStar			= UNTRACED REF   XMapEvent;

TYPE
  XMapRequestEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     parent: Window;
     window: Window
              END;

  XMapRequestEventStar		= UNTRACED REF   XMapRequestEvent;

TYPE
  XReparentEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     event: Window;
     window: Window;
     parent: Window;
     x, y: Int;
     override_redirect: Bool
              END;

  XReparentEventStar		= UNTRACED REF   XReparentEvent;

TYPE
  XConfigureEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     event: Window;
     window: Window;
     x, y: Int;
     width, height: Int;
     border_width: Int;
     above: Window;
     override_redirect: Bool
              END;

  XConfigureEventStar		= UNTRACED REF   XConfigureEvent;

TYPE
  XGravityEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     event: Window;
     window: Window;
     x, y: Int
              END;

  XGravityEventStar		= UNTRACED REF   XGravityEvent;

TYPE
  XResizeRequestEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;
     width, height: Int
              END;

  XResizeRequestEventStar	= UNTRACED REF   XResizeRequestEvent;

TYPE
  XConfigureRequestEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     parent: Window;
     window: Window;
     x, y: Int;
     width, height: Int;
     border_width: Int;
     above: Window;
     detail: Int;              (* Above, Below, TopIf, BottomIf, Opposite *)
     value_mask: UnsignedLong
              END;

  XConfigureRequestEventStar	= UNTRACED REF   XConfigureRequestEvent;

TYPE
  XCirculateEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     event: Window;
     window: Window;
     place: Int                (* PlaceOnTop, PlaceOnBottom *)
              END;

  XCirculateEventStar		= UNTRACED REF   XCirculateEvent;

TYPE
  XCirculateRequestEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     parent: Window;
     window: Window;
     place: Int                (* PlaceOnTop, PlaceOnBottom *)
              END;

  XCirculateRequestEventStar	= UNTRACED REF   XCirculateRequestEvent;

TYPE
  XPropertyEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;
     atom: Atom;
     time: Time;
     state: Int                (* NewValue, Deleted *)
              END;

  XPropertyEventStar		= UNTRACED REF   XPropertyEvent;

TYPE
  XSelectionClearEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;
     selection: Atom;
     time: Time
              END;

  XSelectionClearEventStar	= UNTRACED REF   XSelectionClearEvent;

TYPE
  XSelectionRequestEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     owner: Window;
     requestor: Window;
     selection: Atom;
     target: Atom;
     property: Atom;
     time: Time
              END;

  XSelectionRequestEventStar	= UNTRACED REF   XSelectionRequestEvent;

TYPE
  XSelectionEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     requestor: Window;
     selection: Atom;
     target: Atom;
     property: Atom;           (* ATOM or None *)
     time: Time
              END;

  XSelectionEventStar		= UNTRACED REF   XSelectionEvent;

TYPE
  XColormapEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;
     colormap: Colormap;       (* COLORMAP or None *)
     new: Bool;
     state: Int                (* ColormapInstalled, ColormapUninstalled *)
              END;

  XColormapEventStar		= UNTRACED REF   XColormapEvent;

TYPE
  XClientMessageEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;
     message_type: Atom;
     format: Int;
     data: ARRAY [0..19] OF CHAR
              END;

  XClientMessageEventStar	= UNTRACED REF   XClientMessageEvent;

TYPE
  XMappingEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;           (* unused *)
     request: Int;             (* one of MappingModifier, MappingKeyboard,
                                  MappingPointer *)
     first_keycode: Int;       (* first keycode *)
     count: Int                (* defines range of change w. first_keycode*)
              END;

  XMappingEventStar		= UNTRACED REF   XMappingEvent;

TYPE
  XErrorEvent = RECORD
     type: Int;
     display: DisplayStar;      (* Display the event was read from *)
     resourceid: XID;           (* resource id *)
     serial: UnsignedLong;      (* serial number of failed request *)
     error_code: UnsignedChar;  (* error code of failed request *)
     request_code: UnsignedChar;(* Major op-code of failed request *)
     minor_code: UnsignedChar   (* Minor op-code of failed request *)
                 END;

   XErrorEventStar		=  UNTRACED REF XErrorEvent;

TYPE
  XAnyEvent = RECORD
     type: Int;
     serial: UnsignedLong;     (* # of last request processed by server *)
     send_event: Bool;	       (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window	(* window on which event was requested in event mask *)
              END;

  XAnyEventStar			= UNTRACED REF   XAnyEvent;


(*
 * This type is defined so Xlib can always use the same sized
 * event structure internally, to avoid memory fragmentation.
 *)

CONST XEventSize = 
  MAX (BYTESIZE (Int),
  MAX (BYTESIZE (XAnyEvent),
  MAX (BYTESIZE (XKeyEvent),
  MAX (BYTESIZE (XButtonEvent),
  MAX (BYTESIZE (XMotionEvent),
  MAX (BYTESIZE (XCrossingEvent),
  MAX (BYTESIZE (XFocusChangeEvent),
  MAX (BYTESIZE (XExposeEvent),
  MAX (BYTESIZE (XGraphicsExposeEvent),
  MAX (BYTESIZE (XNoExposeEvent),
  MAX (BYTESIZE (XVisibilityEvent),
  MAX (BYTESIZE (XCreateWindowEvent),
  MAX (BYTESIZE (XDestroyWindowEvent),
  MAX (BYTESIZE (XUnmapEvent),
  MAX (BYTESIZE (XMapEvent),
  MAX (BYTESIZE (XMapRequestEvent),
  MAX (BYTESIZE (XReparentEvent),
  MAX (BYTESIZE (XConfigureEvent),
  MAX (BYTESIZE (XGravityEvent),
  MAX (BYTESIZE (XResizeRequestEvent),
  MAX (BYTESIZE (XConfigureRequestEvent),
  MAX (BYTESIZE (XCirculateEvent),
  MAX (BYTESIZE (XCirculateRequestEvent),
  MAX (BYTESIZE (XPropertyEvent),
  MAX (BYTESIZE (XSelectionClearEvent),
  MAX (BYTESIZE (XSelectionRequestEvent),
  MAX (BYTESIZE (XSelectionEvent),
  MAX (BYTESIZE (XColormapEvent),
  MAX (BYTESIZE (XClientMessageEvent),
  MAX (BYTESIZE (XMappingEvent),
  MAX (BYTESIZE (XErrorEvent),
  MAX (BYTESIZE (XKeymapEvent),
       BYTESIZE (ARRAY [1..24] OF Long)))))))))))))))))))))))))))))))));

TYPE
  XEvent = ARRAY [0 .. XEventSize - 1] OF Char;
  XEventStar  =  UNTRACED REF XEvent;


(*
 * _QEvent datatype for use in input queueing.
 *)

TYPE
  XQEvent = RECORD
    next: XQEventStar;
    event: XEvent
  END;
  XQEventStar = UNTRACED REF XQEvent;

(* ?!?!?!
#define XAllocID(dpy) (( *(dpy)->resource_alloc)((dpy)))
?!?!?! *)

(*
 * per character font metric information.
 *)

TYPE
  XCharStruct = RECORD
    lbearing: Short;            (* origin to left edge of raster *)
    rbearing: Short;            (* origin to right edge of raster *)
    width: Short;               (* advance to next char's origin *)
    ascent: Short;              (* baseline to top edge of raster *)
    descent: Short;             (* baseline to bottom edge of raster *)
    attributes: UnsignedShort;  (* per char flags (not predefined) *)
  END;
  XCharStructStar  =  UNTRACED REF XCharStruct;

(*
 * To allow arbitrary information with fonts, there are additional properties
 * returned.
 *)

TYPE
  XFontProp = RECORD
    name: Atom;
    card32: UnsignedLong;
  END;
  XFontPropStar = UNTRACED REF XFontProp;

  XFontStruct = RECORD
    ext_data: XExtDataStar;      (* hook for extension to hang data *)
    fid: Font;            (* Font id for this font *)
    direction: UnsignedLong;      (* hint about direction the font is painted *)
    min_char_or_byte2: UnsignedLong;(* first character *)
    max_char_or_byte2: UnsignedLong;(* last character *)
    min_byte1: UnsignedLong;      (* first row that exists *)
    max_byte1: UnsignedLong;      (* last row that exists *)
    all_chars_exist: Bool;(* flag if all characters have non-zero size*)
    default_char: UnsignedLong;   (* char to print for undefined character *)
    n_properties: Int;   (* how many properties there are *)
    properties: XFontPropStar;    (* pointer to array of additional properties*)
    min_bounds: XCharStruct;     (* minimum bounds over all existing char *)
    max_bounds: XCharStruct;     (* maximum bounds over all existing char *)
    per_char: XCharStructStar;      (* first_char to last_char information *)
    ascent: Int;         (* log. extent above baseline for spacing *)
    descent: Int;        (* log. descent below baseline for spacing *)
  END;
  XFontStructStar      =  UNTRACED REF XFontStruct;
  XFontStructStarStar  =  UNTRACED REF XFontStructStar;

(*
 * PolyText routines take these as arguments.
 *)

TYPE
  XTextItem = RECORD
    chars: CharStar;                (* pointer to string *)
    nchars: Int;                 (* number of characters *)
    delta: Int;                  (* delta between strings *)
    font: Font;                  (* font to print it in, None don't change *)
  END;

  XChar2b = RECORD
    byte1: UnsignedChar;
    byte2: UnsignedChar;
  END;

  XTextItem16 = RECORD
    chars: XChar2bStar;             (* two byte characters *)
    nchars: Int;                 (* number of characters *)
    delta: Int;                  (* delta between strings *)
    font: Font;                  (* font to print it in, None don't change *)
  END;

TYPE
  XTextItemStar    =  UNTRACED REF XTextItem;
  XChar2bStar      =  UNTRACED REF XChar2b;
  XTextItem16Star  =  UNTRACED REF XTextItem16;

(* ?!?!?!
typedef union { DisplayStar display;
                GC gc;
                VisualStar visual;
                ScreenStar screen;
                ScreenFormatStar pixmap_format;
                XFontStructStar font; } XEDataObject;
?!?!?! *)

TYPE
  XEDataObject  =  ADDRESS;


<*EXTERNAL*> PROCEDURE XLoadQueryFont(
        display:          DisplayStar;
        name:             ConstCharStar
): XFontStructStar;

<*EXTERNAL*> PROCEDURE XQueryFont(
        display:          DisplayStar;
        font:             XID
): XFontStructStar;

<*EXTERNAL*> PROCEDURE XGetMotionEvents(
        display:          DisplayStar;
        w:                Window;
        start:            Time;
        stop:             Time;
        nevents:          IntStar
): XTimeCoordStar;

<*EXTERNAL*> PROCEDURE XDeleteModifiermapEntry(
        modmap:           XModifierKeymapStar;
        keycode:          UnsignedInt
): XModifierKeymapStar;

<*EXTERNAL*> PROCEDURE XGetModifierMapping(
        display:          DisplayStar
): XModifierKeymapStar;

<*EXTERNAL*> PROCEDURE XInsertModifiermapEntry(
        modmap:           XModifierKeymapStar;
        keycode:          KeyCode
): XModifierKeymapStar;

<*EXTERNAL*> PROCEDURE XNewModifiermap(
        max:              Int
): XModifierKeymapStar;

<*EXTERNAL*> PROCEDURE XCreateImage(
        display:          DisplayStar;
        visual:           VisualStar;
        depth:            UnsignedInt;
        format:           Int;
        offset:           Int;
        data:             CharStar;
        width:            UnsignedInt;
        height:           UnsignedInt;
        bitmap:           Int;
        bytes:            Int
): XImageStar;

<*EXTERNAL*> PROCEDURE XGetImage(
        display:          DisplayStar;
        d:                Drawable;
        x:                Int;
        y:                Int;
        width:            UnsignedInt;
        height:           UnsignedInt;
        plane:            UnsignedLong;
        format:           Int
): XImageStar;

<*EXTERNAL*> PROCEDURE XGetSubImage(
        display:          DisplayStar;
        d:                Drawable;
        x:                Int;
        y:                Int;
        width:            UnsignedInt;
        height:           UnsignedInt;
        plane:            UnsignedLong;
        format:           Int;
        dest_image:       XImageStar;
        dest_x:           Int;
        dest_y:           Int
): XImageStar;

(* 
 * X function declarations.
 *)

<*EXTERNAL*> PROCEDURE XOpenDisplay(
        display:          ConstCharStar;
): DisplayStar;

<*EXTERNAL*> PROCEDURE XrmInitialize(
);

<*EXTERNAL*> PROCEDURE XFetchBytes(
        display:          DisplayStar;
        nbytes:           IntStar
): CharStar;

<*EXTERNAL*> PROCEDURE XFetchBuffer(
        display:          DisplayStar;
        nbytes:           IntStar;
        buffer:           Int
): CharStar;

<*EXTERNAL*> PROCEDURE XGetAtomName(
        display:          DisplayStar;
        atom:             Atom
): CharStar;

<*EXTERNAL*> PROCEDURE XGetDefault(
        display:          DisplayStar;
        program:          ConstCharStar;
        option:           ConstCharStar
): CharStar;

<*EXTERNAL*> PROCEDURE XDisplayName(
        string:           ConstCharStar;
): CharStar;

<*EXTERNAL*> PROCEDURE XKeysymToString(
        keysym:           KeySym;
): CharStar;


TYPE
  XSynchronize   =  PROCEDURE (
        display:    DisplayStar;
        onoff:      Bool
): Int;


TYPE
  XSetLocalProc      =  PROCEDURE (display: DisplayStar): Int;
  XSetAfterFunction  =  PROCEDURE (
			        display:    DisplayStar;
			        procedure:  XSetLocalProc
): Int;


<*EXTERNAL*> PROCEDURE XInternAtom(
        display:          DisplayStar;
        atom:             ConstCharStar;
        only:             Bool
): Atom;

<*EXTERNAL*> PROCEDURE XCopyColormapAndFree(
        display:          DisplayStar;
        colormap:         Colormap
): Colormap;

<*EXTERNAL*> PROCEDURE XCreateColormap(
        display:          DisplayStar;
        w:                Window;
        visual:           VisualStar;
        alloc:            Int
): Colormap;

<*EXTERNAL*> PROCEDURE XCreatePixmapCursor(
        display:          DisplayStar;
        source:           Pixmap;
        mask:             Pixmap;
        foreground:       XColorStar;
        background:       XColorStar;
        x:                UnsignedInt;
        y:                UnsignedInt
): Cursor;

<*EXTERNAL*> PROCEDURE XCreateGlyphCursor(
        display:          DisplayStar;
        source_font:      Font;
        mask_font:        Font;
        source_char:      UnsignedInt;
        mask_char:        UnsignedInt;
        foreground:       XColorStar;
        background:       XColorStar
): Cursor;

<*EXTERNAL*> PROCEDURE XCreateFontCursor(
        display:          DisplayStar;
        shape:            UnsignedInt
): Cursor;

<*EXTERNAL*> PROCEDURE XLoadFont(
        display:          DisplayStar;
        name:             ConstCharStar
): Font;

<*EXTERNAL*> PROCEDURE XCreateGC(
        display:          DisplayStar;
        d:                Drawable;
        valuemask:        UnsignedLong;
        values:           XGCValuesStar
): GC;

<*EXTERNAL*> PROCEDURE XGContextFromGC(
        gc:               GC
): GContext;

<*EXTERNAL*> PROCEDURE XCreatePixmap(
        display:          DisplayStar;
        d:                Drawable;
        width:            UnsignedInt;
        height:           UnsignedInt;
        depth:            UnsignedInt
): Pixmap;

<*EXTERNAL*> PROCEDURE XCreateBitmapFromData(
        display:          DisplayStar;
        d:                Drawable;
        data:             ConstCharStar;
        width:            UnsignedInt;
        height:           UnsignedInt
): Pixmap;

<*EXTERNAL*> PROCEDURE XCreatePixmapFromBitmapData(
        display:          DisplayStar;
        d:                Drawable;
        data:             CharStar;
        width:            UnsignedInt;
        height:           UnsignedInt;
        fg:               UnsignedLong;
        bg:               UnsignedLong;
        depth:            UnsignedInt
): Pixmap;

<*EXTERNAL*> PROCEDURE XCreateSimpleWindow(
        display:          DisplayStar;
        parent:           Window;
        x:                Int;
        y:                Int;
        width:            UnsignedInt;
        height:           UnsignedInt;
        border_width:     UnsignedInt;
        border:           UnsignedLong;
        background:       UnsignedLong
): Window;

<*EXTERNAL*> PROCEDURE XGetSelectionOwner(
        display:          DisplayStar;
        selection:        Atom
): Window;

<*EXTERNAL*> PROCEDURE XCreateWindow(
        display:          DisplayStar;
        parent:           Window;
        x:                Int;
        y:                Int;
        width:            UnsignedInt;
        height:           UnsignedInt;
        border:           UnsignedInt;
        depth:            Int;
        class:            UnsignedInt;
        visual:           VisualStar;
        valuemask:        UnsignedLong;
        attributes:       XSetWindowAttributesStar
): Window; 

<*EXTERNAL*> PROCEDURE XListInstalledColormaps(
        display:          DisplayStar;
        w:                Window;
        num:              IntStar
): ColormapStar;

<*EXTERNAL*> PROCEDURE XListFonts(
        display:          DisplayStar;
        pattern:          ConstCharStar;
        maxnames:         Int;
        actual:           IntStar
): CharStarStar;

<*EXTERNAL*> PROCEDURE XListFontsWithInfo(
        display:          DisplayStar;
        pattern:          ConstCharStar;
        maxnames:         Int;
        count:            IntStar;
        info:             XFontStructStarStar
): CharStarStar;

<*EXTERNAL*> PROCEDURE XGetFontPath(
        display:          DisplayStar;
        npaths:           IntStar
): CharStarStar;

<*EXTERNAL*> PROCEDURE XListExtensions(
        display:          DisplayStar;
        nextensions:      IntStar
): CharStarStar;

<*EXTERNAL*> PROCEDURE XListProperties(
        display:          DisplayStar;
        w:                Window;
        num:              IntStar
): AtomStar;

<*EXTERNAL*> PROCEDURE XListHosts(
        display:          DisplayStar;
        nhosts:           IntStar;
        state:            BoolStar;
): XHostAddressStar;

<*EXTERNAL*> PROCEDURE XKeycodeToKeysym(
        display:          DisplayStar;
        keycode:          KeyCode
): KeySym;

<*EXTERNAL*> PROCEDURE XLookupKeysym(
        key:              XKeyEventStar;
        index:            Int
): KeySym;

<*EXTERNAL*> PROCEDURE XGetKeyboardMapping(
        display:          DisplayStar;
        first:            KeyCode;
        keycode:          Int;
        keysyms:          IntStar
): KeySymStar;

<*EXTERNAL*> PROCEDURE XStringToKeysym(
        string:           ConstCharStar
): KeySym;

<*EXTERNAL*> PROCEDURE XMaxRequestSize(
        display:          DisplayStar
): Long;

<*EXTERNAL*> PROCEDURE XResourceManagerString(
        display:          DisplayStar
): CharStar;

<*EXTERNAL*> PROCEDURE XDisplayMotionBufferSize(
        display:          DisplayStar
): UnsignedLong;

<*EXTERNAL*> PROCEDURE XVisualIDFromVisual(
        visual:           VisualStar
): VisualID;

(* routines for dealing with extensions *)

<*EXTERNAL*> PROCEDURE XInitExtension(
        display:          DisplayStar;
        name:             ConstCharStar
): XExtCodesStar;

<*EXTERNAL*> PROCEDURE XAddExtension(
        display:          DisplayStar
): XExtCodesStar;

<*EXTERNAL*> PROCEDURE XFindOnExtensionList(
        structure:        XExtDataStarStar;
        number:           Int
): XExtDataStar;

<*EXTERNAL*> PROCEDURE XEHeadOfExtensionList(
        object:           XEDataObject
): XExtDataStarStar;

(* these are routines for which there are also macros *)

<*EXTERNAL*> PROCEDURE XRootWindow(
        display:          DisplayStar;
        screen:           Int
): Window;

<*EXTERNAL*> PROCEDURE XDefaultRootWindow(
        display:          DisplayStar
): Window;

<*EXTERNAL*> PROCEDURE XRootWindowOfScreen(
        screen:           ScreenStar
): Window;

<*EXTERNAL*> PROCEDURE XDefaultVisual(
        display:          DisplayStar;
        screen:           Int
): VisualStar;

<*EXTERNAL*> PROCEDURE XDefaultVisualOfScreen(
        screen:           ScreenStar
): VisualStar;

<*EXTERNAL*> PROCEDURE XDefaultGC(
        display:          DisplayStar;
        screen:           Int
): GC;

<*EXTERNAL*> PROCEDURE XDefaultGCOfScreen(
        screen:           ScreenStar
): GC;

<*EXTERNAL*> PROCEDURE XBlackPixel(
        display:          DisplayStar;
        screen:           Int
): UnsignedLong;

<*EXTERNAL*> PROCEDURE XWhitePixel(
        display:          DisplayStar;
        screen:           Int
): UnsignedLong;

<*EXTERNAL*> PROCEDURE XAllPlanes(
): UnsignedLong;

<*EXTERNAL*> PROCEDURE XBlackPixelOfScreen(
        screen:           ScreenStar
): UnsignedLong;

<*EXTERNAL*> PROCEDURE XWhitePixelOfScreen(
        screen:           ScreenStar
): UnsignedLong;

<*EXTERNAL*> PROCEDURE XNextRequest(
        display:          DisplayStar
): UnsignedLong;


(* ---- double definition ------
<*EXTERNAL*> PROCEDURE XLastKnownRequestProcessed(
        display:          DisplayStar
): UnsignedLong;  *)

<*EXTERNAL*> PROCEDURE XServerVendor(
        display:          DisplayStar
): CharStar;

<*EXTERNAL*> PROCEDURE XDisplayString(
        display:          DisplayStar
): CharStar;

<*EXTERNAL*> PROCEDURE XDefaultColormap(
        display:          DisplayStar;
        screen:           Int
): Colormap;

<*EXTERNAL*> PROCEDURE XDefaultColormapOfScreen(
        screen:           ScreenStar
): Colormap;

<*EXTERNAL*> PROCEDURE XDisplayOfScreen(
        screen:           ScreenStar
): DisplayStar;

<*EXTERNAL*> PROCEDURE XScreenOfDisplay(
        display:          DisplayStar;
        screen:           Int
): ScreenStar;

<*EXTERNAL*> PROCEDURE XDefaultScreenOfDisplay(
        display:          DisplayStar
): ScreenStar;

<*EXTERNAL*> PROCEDURE XEventMaskOfScreen(
        screen:           ScreenStar
): Long;

<*EXTERNAL*> PROCEDURE XScreenNumberOfScreen(
        screen:           ScreenStar
): Int;

TYPE XErrorHandler = PROCEDURE (      (* WARNING, this type not in Xlib spec *)
        display:          DisplayStar;
        error:            XErrorEventStar
): Int;

<*EXTERNAL*> PROCEDURE XSetErrorHandler (
        handler:          XErrorHandler
): XErrorHandler;

TYPE XIOErrorHandler = PROCEDURE (    (* WARNING, this type not in Xlib spec *)
        display:          DisplayStar
): Int;

<*EXTERNAL*> PROCEDURE XSetIOErrorHandler (
        handler:          XIOErrorHandler
): XIOErrorHandler;


<*EXTERNAL*> PROCEDURE XListPixmapFormats(
        display:          DisplayStar;
        count:            IntStar
): XPixmapFormatValuesStar;

<*EXTERNAL*> PROCEDURE XListDepths(
        display:          DisplayStar;
        screen:           Int;
        count:            IntStar
): IntStar;

(* ICCCM routines for things that don't require special include files; *)
(* other declarations are given in Xutil.h                             *)

<*EXTERNAL*> PROCEDURE XReconfigureWMWindow(
        display:          DisplayStar;
        w:                Window;
        screen:           Int;
        mask:             UnsignedInt;
        changes:          XWindowChangesStar
): Status;

<*EXTERNAL*> PROCEDURE XGetWMProtocols(
        display:          DisplayStar;
        w:                Window;
        protocols:        AtomStarStar;
        count:            IntStar
): Status;

<*EXTERNAL*> PROCEDURE XSetWMProtocols(
        display:          DisplayStar;
        w:                Window;
        protocols:        AtomStar;
        count:            Int
): Status;

<*EXTERNAL*> PROCEDURE XIconifyWindow(
        display:          DisplayStar;
        w:                Window;
        screen:           Int
): Status;

<*EXTERNAL*> PROCEDURE XWithdrawWindow(
        display:          DisplayStar;
        w:                Window;
        screen:           Int
): Status;

<*EXTERNAL*> PROCEDURE XGetCommand(
        display:          DisplayStar;
        w:                Window;
        argv:             M3toC.Argv;
        argc:             IntStar
): Status;

<*EXTERNAL*> PROCEDURE XGetWMColormapWindows(
        display:          DisplayStar;
        w:                Window;
        windows:          WindowStarStar;
        count:            IntStar
): Status;

<*EXTERNAL*> PROCEDURE XSetWMColormapWindows(
        display:          DisplayStar;
        w:                Window;
        colormap:         WindowStar;
        count:            Int
): Status;

<*EXTERNAL*> PROCEDURE XFreeStringList(
        list:             CharStarStar
): Void ;

<*EXTERNAL*> PROCEDURE XSetTransientForHint(
        display:          DisplayStar;
        w:                Window;
        prop:             Window
);

(* The following are given in alphabetical order *)

<*EXTERNAL*> PROCEDURE XActivateScreenSaver(
        display:          DisplayStar
);

<*EXTERNAL*> PROCEDURE XAddHost(
        display:          DisplayStar;
        host:             XHostAddressStar
);

<*EXTERNAL*> PROCEDURE XAddHosts(
        display:          DisplayStar;
        hosts:            XHostAddressStar;
        num:              Int
);

<*EXTERNAL*> PROCEDURE XAddToExtensionList(
        structure:        ADDRESS;
        ext:              XExtDataStar
);

<*EXTERNAL*> PROCEDURE XAddToSaveSet(
        display:          DisplayStar;
        w:                Window
);

<*EXTERNAL*> PROCEDURE XAllocColor(
        display:          DisplayStar;
        colormap:         Colormap;
        color:            XColorStar
): Status;

<*EXTERNAL*> PROCEDURE XAllocColorCells(
        display:          DisplayStar;
        colormap:         Colormap;
        contig:           Bool;
        plane:            UnsignedLongStar;
        nplanes:          UnsignedInt;
        pixels:           UnsignedLongStar;
        npixels:          UnsignedInt
): Status;

<*EXTERNAL*> PROCEDURE XAllocColorPlanes(
        display:          DisplayStar;
        colormap:         Colormap;
        contig:           Bool;
        pixels:           UnsignedLongStar;
        ncolors:          Int;
        nreds:            Int;
        ngreens:          Int;
        nblues:           Int;
        rmask:            UnsignedLongStar;
        gmask:            UnsignedLongStar;
        bmask:            UnsignedLongStar
): Status;

<*EXTERNAL*> PROCEDURE XAllocNamedColor(
        display:          DisplayStar;
        colormap:         Colormap;
        color:            ConstCharStar;
        screen:           XColorStar;
        exact:            XColorStar
): Status;

<*EXTERNAL*> PROCEDURE XAllowEvents(
        display:          DisplayStar;
        event:            Int;
        time:             Time
);

<*EXTERNAL*> PROCEDURE XAutoRepeatOff(
        display:          DisplayStar
);

<*EXTERNAL*> PROCEDURE XAutoRepeatOn(
        display:          DisplayStar
);

<*EXTERNAL*> PROCEDURE XBell(
        display:          DisplayStar;
        percent:          Int
);

<*EXTERNAL*> PROCEDURE XBitmapBitOrder(
        display:          DisplayStar
): Int;

<*EXTERNAL*> PROCEDURE XBitmapPad(
        display:          DisplayStar
): Int;

<*EXTERNAL*> PROCEDURE XBitmapUnit(
        display:          DisplayStar
): Int;

<*EXTERNAL*> PROCEDURE XCellsOfScreen(
        screen:           ScreenStar
): Int;

<*EXTERNAL*> PROCEDURE XChangeActivePointerGrab(
        display:          DisplayStar;
        event:            UnsignedInt;
        cursor:           Cursor;
        time:             Time
);

<*EXTERNAL*> PROCEDURE XChangeGC(
        display:          DisplayStar;
        gc:               GC;
        valuemask:        UnsignedLong;
        values:           XGCValuesStar
);

<*EXTERNAL*> PROCEDURE XChangeKeyboardControl(
        display:          DisplayStar;
        value:            UnsignedLong;
        values:           XKeyboardControlStar
);

<*EXTERNAL*> PROCEDURE XChangeKeyboardMapping(
        display:          DisplayStar;
        first:            Int;
        keysyms_per_key:  Int;
        keysyms:          KeySymStar;
        num:              Int
);

<*EXTERNAL*> PROCEDURE XChangePointerControl(
        display:          DisplayStar;
        do_accel:         Bool;
        do_threshold:     Bool;
        accel_num:        Int;
        accel_den:        Int;
        threshold:        Int
);

<*EXTERNAL*> PROCEDURE XChangeProperty(
        display:          DisplayStar;
        w:                Window;
        property:         Atom;
        type:             Atom;
        format:           Int;
        mode:             Int;
        data:             ConstUnsignedCharStar;
        nelements:        Int
);

<*EXTERNAL*> PROCEDURE XChangeSaveSet(
        display:          DisplayStar;
        w:                Window;
        change:           Int
);

<*EXTERNAL*> PROCEDURE XChangeWindowAttributes(
        display:          DisplayStar;
        w:                Window;
        valuemask:        UnsignedLong;
        attributes:       XSetWindowAttributesStar
);


TYPE XIfEventProc = PROCEDURE (
        display:          DisplayStar;
        event:            XEventStar;
        arg:              CharStar
  ): Bool;

<*EXTERNAL*> PROCEDURE XCheckIfEvent(
        display:          DisplayStar;
        event:            XEventStar;
        predicate:        XIfEventProc;
        arg:              CharStar;
):  Bool;

<*EXTERNAL*> PROCEDURE XCheckMaskEvent(
        display:          DisplayStar;
        event_mask:       Long;
        event_return:     XEventStar
): Bool;

<*EXTERNAL*> PROCEDURE XCheckTypedEvent(
        display:          DisplayStar;
        event_type:       Int;
        event_return:     XEventStar
): Bool;

<*EXTERNAL*> PROCEDURE XCheckTypedWindowEvent(
        display:          DisplayStar;
        w:                Window;
        event_type:       Int;
        event_return:     XEventStar
): Bool;

<*EXTERNAL*> PROCEDURE XCheckWindowEvent(
        display:          DisplayStar;
        w:                Window;
        event_mask:       Long;
        event_return:     XEventStar
): Bool;

<*EXTERNAL*> PROCEDURE XCirculateSubwindows(
        display:          DisplayStar;
        w:                Window;
        direction:        Int
);

<*EXTERNAL*> PROCEDURE XCirculateSubwindowsDown(
        display:          DisplayStar;
        w:                Window
);

<*EXTERNAL*> PROCEDURE XCirculateSubwindowsUp(
        display:          DisplayStar;
        w:                Window
);

<*EXTERNAL*> PROCEDURE XClearArea(
        display:          DisplayStar;
        w:                Window;
        x:                Int;
        y:                Int;
        width:            UnsignedInt;
        height:           UnsignedInt;
        exposures:        Bool
);

<*EXTERNAL*> PROCEDURE XClearWindow(
        display:          DisplayStar;
        w:                Window
);

<*EXTERNAL*> PROCEDURE XCloseDisplay(
        display:          DisplayStar
);

<*EXTERNAL*> PROCEDURE XConfigureWindow(
        display:          DisplayStar;
        w:                Window;
        value:            UnsignedInt;
        values:           XWindowChangesStar
);

<*EXTERNAL*> PROCEDURE XConnectionNumber(
        display:          DisplayStar
): Int;

<*EXTERNAL*> PROCEDURE XConvertSelection(
        display:          DisplayStar;
        selection:        Atom;
        target:           Atom;
        property:         Atom;
        requestor:        Window;
        time:             Time
);

<*EXTERNAL*> PROCEDURE XCopyArea(
        display:          DisplayStar;
        src:              Drawable;
        dest:             Drawable;
        gc:               GC;
        src_x:            Int;
        src_y:            Int;
        width:            UnsignedInt;
        height:           UnsignedInt;
        dest_x:           Int;
        dest_y:           Int
);

<*EXTERNAL*> PROCEDURE XCopyGC(
        display:          DisplayStar;
        src:              GC;
        valuemask:        UnsignedLong;
        dest:             GC
);

<*EXTERNAL*> PROCEDURE XCopyPlane(
        display:          DisplayStar;
        src:              Drawable;
        dest:             Drawable;
        gc:               GC;
        src_x:            Int;
        src_y:            Int;
        width:            UnsignedInt;
        height:           UnsignedInt;
        dest_x:           Int;
        dest_y:           Int;
        plane:            UnsignedLong
);

<*EXTERNAL*> PROCEDURE XDefaultDepth(
        display:          DisplayStar;
        screen:           Int
): Int;

<*EXTERNAL*> PROCEDURE XDefaultDepthOfScreen(
        screen:           ScreenStar
): Int;

<*EXTERNAL*> PROCEDURE XDefaultScreen(
        display:          DisplayStar
): Int;

<*EXTERNAL*> PROCEDURE XDefineCursor(
        display:          DisplayStar;
        w:                Window;
        cursor:           Cursor
);

<*EXTERNAL*> PROCEDURE XDeleteProperty(
        display:          DisplayStar;
        w:                Window;
        property:         Atom
);

<*EXTERNAL*> PROCEDURE XDestroyWindow(
        display:          DisplayStar;
        w:                Window
);

<*EXTERNAL*> PROCEDURE XDestroySubwindows(
        display:          DisplayStar;
        w:                Window
);

<*EXTERNAL*> PROCEDURE XDoesBackingStore(
        screen:           ScreenStar
): Int;

<*EXTERNAL*> PROCEDURE XDoesSaveUnders(
        screen:           ScreenStar
): Bool;

<*EXTERNAL*> PROCEDURE XDisableAccessControl(
        display:          DisplayStar
);

<*EXTERNAL*> PROCEDURE XDisplayCells(
        display:          DisplayStar;
        screen:           Int
): Int;

<*EXTERNAL*> PROCEDURE XDisplayHeight(
        display:          DisplayStar;
        screen:           Int
): Int;

<*EXTERNAL*> PROCEDURE XDisplayHeightMM(
        display:          DisplayStar;
        screen:           Int
): Int;

<*EXTERNAL*> PROCEDURE XDisplayKeycodes(
        display:          DisplayStar;
        min:              IntStar;
        max:              IntStar
);

<*EXTERNAL*> PROCEDURE XDisplayPlanes(
        display:          DisplayStar;
        screen:           Int
): Int;

<*EXTERNAL*> PROCEDURE XDisplayWidth(
        display:          DisplayStar;
        screen:           Int
): Int;

<*EXTERNAL*> PROCEDURE XDisplayWidthMM(
        display:          DisplayStar;
        screen:           Int
): Int;

<*EXTERNAL*> PROCEDURE XDrawArc(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        x:                Int;
        y:                Int;
        width:            UnsignedInt;
        height:           UnsignedInt;
        angle1:           Int;
        angle2:           Int
);

<*EXTERNAL*> PROCEDURE XDrawArcs(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        arcs:             XArcStar;
        narcs:            Int
);

<*EXTERNAL*> PROCEDURE XDrawImageString(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        x:                Int;
        y:                Int;
        string:           ConstCharStar;
        length:           Int
);

<*EXTERNAL*> PROCEDURE XDrawImageString16(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        x:                Int;
        y:                Int;
        string:           XChar2bStar;
        length:           Int
);

<*EXTERNAL*> PROCEDURE XDrawLine(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        x1:               Int;
        x2:               Int;
        y1:               Int;
        y2:               Int
);

<*EXTERNAL*> PROCEDURE XDrawLines(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        points:           XPointStar;
        npoints:          Int;
        mode:             Int
);

<*EXTERNAL*> PROCEDURE XDrawPoint(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        x:                Int;
        y:                Int
);

<*EXTERNAL*> PROCEDURE XDrawPoints(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        points:           XPointStar;
        npoints:          Int;
        mode:             Int
);

<*EXTERNAL*> PROCEDURE XDrawRectangle(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        x:                Int;
        y:                Int;
        width:            UnsignedInt;
        height:           UnsignedInt
);

<*EXTERNAL*> PROCEDURE XDrawRectangles(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        rectangles:       XRectangleStar;
        nrectangles:      Int
);

<*EXTERNAL*> PROCEDURE XDrawSegments(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        segments:         XSegmentStar;
        nsegments:        Int
);

<*EXTERNAL*> PROCEDURE XDrawString(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        x:                Int;
        y:                Int;
        string:           ConstCharStar;
        length:           Int
);

<*EXTERNAL*> PROCEDURE XDrawString16(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        x:                Int;
        y:                Int;
        string:           XChar2bStar;
        length:           Int
);

<*EXTERNAL*> PROCEDURE XDrawText(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        x:                Int;
        y:                Int;
        items:            XTextItemStar;
        nitems:           Int
);

<*EXTERNAL*> PROCEDURE XDrawText16(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        x:                Int;
        y:                Int;
        items:            XTextItem16Star;
        nitems:           Int
);

<*EXTERNAL*> PROCEDURE XEnableAccessControl(
        display:          DisplayStar
);

<*EXTERNAL*> PROCEDURE XEventsQueued(
        display:          DisplayStar;
        mode:             Int
): Int;

<*EXTERNAL*> PROCEDURE XFetchName(
        display:          DisplayStar;
        w:                Window;
        window:           CharStarStar
): Status;

<*EXTERNAL*> PROCEDURE XFillArc(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        x:                Int;
        y:                Int;
        width:            UnsignedInt;
        height:           UnsignedInt;
        angle1:           Int;
        angle2:           Int
);

<*EXTERNAL*> PROCEDURE XFillArcs(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        arcs:             XArcStar;
        narcs:            Int
);

<*EXTERNAL*> PROCEDURE XFillPolygon(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        points:           XPointStar;
        npoints:          Int;
        shape:            Int;
        mode:             Int
);

<*EXTERNAL*> PROCEDURE XFillRectangle(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        x:                Int;
        y:                Int;
        width:            UnsignedInt;
        height:           UnsignedInt
);

<*EXTERNAL*> PROCEDURE XFillRectangles(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        rectangles:       XRectangleStar;
        nrectangles:      Int
);

<*EXTERNAL*> PROCEDURE XFlush(
        display:          DisplayStar
);

<*EXTERNAL*> PROCEDURE XForceScreenSaver(
        display:          DisplayStar;
        mode:             Int
);

<*EXTERNAL*> PROCEDURE XFree(
        data:             CharStar
);

<*EXTERNAL*> PROCEDURE XFreeColormap(
        display:          DisplayStar;
        colormap:         Colormap
);

<*EXTERNAL*> PROCEDURE XFreeColors(
        display:          DisplayStar;
        colormap:         Colormap;
        pixels:           UnsignedLongStar;
        npixels:          Int;
        planes:           UnsignedLong
);

<*EXTERNAL*> PROCEDURE XFreeCursor(
        display:          DisplayStar;
        cursor:           Cursor
);

<*EXTERNAL*> PROCEDURE XFreeExtensionList(
        list:             CharStarStar
);

<*EXTERNAL*> PROCEDURE XFreeFont(
        display:          DisplayStar;
        font:             XFontStructStar
);

<*EXTERNAL*> PROCEDURE XFreeFontInfo(
        names:            CharStarStar;
        free:             XFontStructStar;
        actual:           Int
);

<*EXTERNAL*> PROCEDURE XFreeFontNames(
        list:             CharStarStar
);

<*EXTERNAL*> PROCEDURE XFreeFontPath(
        list:             CharStarStar
);

<*EXTERNAL*> PROCEDURE XFreeGC(
        display:          DisplayStar;
        gc:               GC
);

<*EXTERNAL*> PROCEDURE XFreeModifiermap(
        modmap:           XModifierKeymapStar
);

<*EXTERNAL*> PROCEDURE XFreePixmap(
        display:          DisplayStar;
        pixmap:           Pixmap
);

<*EXTERNAL*> PROCEDURE XGeometry(
        display:          DisplayStar;
        screen:           Int;
        position:         ConstCharStar;
        default:          ConstCharStar;
        bwidth:           UnsignedInt;
        fwidth:           UnsignedInt;
        fheight:          UnsignedInt;
        xadder:           Int;
        yadder:           Int;
        x:                IntStar;
        y:                IntStar;
        width:            IntStar;
        height:           IntStar
): Int;

<*EXTERNAL*> PROCEDURE XGetErrorDatabaseText(
        display:          DisplayStar;
        name:             ConstCharStar;
        message:          ConstCharStar;
        default:          ConstCharStar;
        buffer:           CharStar;
        length:           Int
);

<*EXTERNAL*> PROCEDURE XGetErrorText(
        display:          DisplayStar;
        code:             Int;
        buffer:           CharStar;
        length:           Int
);

<*EXTERNAL*> PROCEDURE XGetFontProperty(
        font:             XFontStructStar;
        atom:             Atom;
        value:            UnsignedLongStar
): Bool;

<*EXTERNAL*> PROCEDURE XGetGCValues(
        display:          DisplayStar;
        gc:               GC;
        valuemask:        UnsignedLong;
        values:           XGCValuesStar
): Status;

<*EXTERNAL*> PROCEDURE XGetGeometry(
        display:          DisplayStar;
        d:                Drawable;
        root:             WindowStar;
        x:                IntStar;
        y:                IntStar;
        width:            UnsignedIntStar;
        height:           UnsignedIntStar;
        border:           UnsignedIntStar;
        depth:            UnsignedIntStar
): Status;

<*EXTERNAL*> PROCEDURE XGetIconName(
        display:          DisplayStar;
        w:                Window;
        icon:             CharStarStar
): Status;

<*EXTERNAL*> PROCEDURE XGetInputFocus(
        display:          DisplayStar;
        focus:            WindowStar;
        revert:           IntStar
);

<*EXTERNAL*> PROCEDURE XGetKeyboardControl(
        display:          DisplayStar;
        values:           XKeyboardStateStar
);

<*EXTERNAL*> PROCEDURE XGetPointerControl(
        display:          DisplayStar;
        accel_num_ret:    IntStar;
        accel_den_ret:    IntStar;
        threshold_ret:    IntStar
);

<*EXTERNAL*> PROCEDURE XGetPointerMapping(
        display:          DisplayStar;
        map:              UnsignedCharStar;
        nmap:             Int
): Int;

<*EXTERNAL*> PROCEDURE XGetScreenSaver(
        display:          DisplayStar;
        timeout:          IntStar;
        interval:         IntStar;
        prefer:           IntStar;
        allow:            IntStar
);

<*EXTERNAL*> PROCEDURE XGetTransientForHint(
        display:          DisplayStar;
        w:                Window;
        prop:             WindowStar
): Status;

<*EXTERNAL*> PROCEDURE XGetWindowProperty(
        display:          DisplayStar;
        w:                Window;
        property:         Atom;
        long_offset:      Long;
        long_length:      Long;
        delete:           Bool;
        req:              Atom;
        actual_type:      AtomStar;
        actual_format:    IntStar;
        nitems:           UnsignedLongStar;
        bytes:            UnsignedLongStar;
        prop:             UnsignedCharStarStar
): Int;

<*EXTERNAL*> PROCEDURE XGetWindowAttributes(
        display:          DisplayStar;
        w:                Window;
        window:           XWindowAttributesStar
): Status;

<*EXTERNAL*> PROCEDURE XGrabButton(
        display:          DisplayStar;
        button:           UnsignedInt;
        modifiers:        UnsignedInt;
        grab:             Window;
        owner:            Bool;
        event:            UnsignedInt;
        pointer:          Int;
        keyboard:         Int;
        confine:          Window;
        cursor:           Cursor
);

<*EXTERNAL*> PROCEDURE XGrabKey(
        display:          DisplayStar;
        keycode:          Int;
        modifiers:        UnsignedInt;
        grab:             Window;
        owner:            Bool;
        pointer:          Int;
        keyboard:         Int
);

<*EXTERNAL*> PROCEDURE XGrabKeyboard(
        display:          DisplayStar;
        grab:             Window;
        owner:            Bool;
        pointer:          Int;
        keyboard:         Int;
        time:             Time
): Int;

<*EXTERNAL*> PROCEDURE XGrabPointer(
        display:          DisplayStar;
        grab:             Window;
        owner:            Bool;
        event:            UnsignedInt;
        pointer:          Int;
        keyboard:         Int;
        confine:          Window;
        cursor:           Cursor;
        time:             Time
): Int;

<*EXTERNAL*> PROCEDURE XGrabServer(
        display:          DisplayStar
);

<*EXTERNAL*> PROCEDURE XHeightMMOfScreen(
        screen:           ScreenStar
): Int;

<*EXTERNAL*> PROCEDURE XHeightOfScreen(
        screen:           ScreenStar
): Int;

<*EXTERNAL*> PROCEDURE XIfEvent(
        display:          DisplayStar;
        event:            XEventStar;
        predicate:        XIfEventProc;
        arg:              CharStar
);

<*EXTERNAL*> PROCEDURE XImageByteOrder(
        display:          DisplayStar
): Int;

<*EXTERNAL*> PROCEDURE XInstallColormap(
        display:          DisplayStar;
        colormap:         Colormap
);

<*EXTERNAL*> PROCEDURE XKeysymToKeycode(
        display:          DisplayStar;
        keysym:           KeySym
): KeyCode;

<*EXTERNAL*> PROCEDURE XKillClient(
        display:          DisplayStar;
        resource:         XID
);

<*EXTERNAL*> PROCEDURE XLastKnownRequestProcessed(
        display:          DisplayStar
): UnsignedLong ;

<*EXTERNAL*> PROCEDURE XLookupColor(
        display:          DisplayStar;
        colormap:         Colormap;
        color:            ConstCharStar;
        exact:            XColorStar;
        screen:           XColorStar
): Status;

<*EXTERNAL*> PROCEDURE XLowerWindow(
        display:          DisplayStar;
        w:                Window
);

<*EXTERNAL*> PROCEDURE XMapRaised(
        display:          DisplayStar;
        w:                Window
);

<*EXTERNAL*> PROCEDURE XMapSubwindows(
        display:          DisplayStar;
        w:                Window
);

<*EXTERNAL*> PROCEDURE XMapWindow(
        display:          DisplayStar;
        w:                Window
);

<*EXTERNAL*> PROCEDURE XMaskEvent(
        display:          DisplayStar;
        event_mask:       Long;
        event_return:     XEventStar
);

<*EXTERNAL*> PROCEDURE XMaxCmapsOfScreen(
        screen:           ScreenStar
): Int;

<*EXTERNAL*> PROCEDURE XMinCmapsOfScreen(
        screen:           ScreenStar
): Int;

<*EXTERNAL*> PROCEDURE XMoveResizeWindow(
        display:          DisplayStar;
        w:                Window;
        x:                Int;
        y:                Int;
        width:            UnsignedInt;
        height:           UnsignedInt
);

<*EXTERNAL*> PROCEDURE XMoveWindow(
        display:          DisplayStar;
        w:                Window;
        x:                Int;
        y:                Int
);

<*EXTERNAL*> PROCEDURE XNextEvent(
        display:          DisplayStar;
        event:            XEventStar
);

<*EXTERNAL*> PROCEDURE XNoOp(
        display:          DisplayStar
);

<*EXTERNAL*> PROCEDURE XParseColor(
        display:          DisplayStar;
        colormap:         Colormap;
        spec:             ConstCharStar;
        exact:            XColorStar
): Status;

<*EXTERNAL*> PROCEDURE XParseGeometry(
        parsestring:      ConstCharStar;
        x:                IntStar;
        y:                IntStar;
        width:            UnsignedIntStar;
        height:           UnsignedIntStar
): Int;

<*EXTERNAL*> PROCEDURE XPeekEvent(
        display:          DisplayStar;
        event:            XEventStar
);


<*EXTERNAL*> PROCEDURE XPeekIfEvent(
        display:          DisplayStar;
        event:            XEventStar;
        predicate:        XIfEventProc;
        arg:              CharStar
);

<*EXTERNAL*> PROCEDURE XPending(
        display:          DisplayStar
): Int;

<*EXTERNAL*> PROCEDURE XPlanesOfScreen(
        screen:           ScreenStar
): Int;

<*EXTERNAL*> PROCEDURE XProtocolRevision(
        display:          DisplayStar
): Int;

<*EXTERNAL*> PROCEDURE XProtocolVersion(
        display:          DisplayStar
): Int;

<*EXTERNAL*> PROCEDURE XPutBackEvent(
        display:          DisplayStar;
        event:            XEventStar
);

<*EXTERNAL*> PROCEDURE XPutImage(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        image:            XImageStar;
        src_x:            Int;
        src_y:            Int;
        dest_x:           Int;
        dest_y:           Int;
        width:            UnsignedInt;
        height:           UnsignedInt
);

<*EXTERNAL*> PROCEDURE XQLength(
        display:          DisplayStar
): Int;

<*EXTERNAL*> PROCEDURE XQueryBestCursor(
        display:          DisplayStar;
        d:                Drawable;
        width:            UnsignedInt;
        height:           UnsignedInt;
        width_return:     UnsignedIntStar;
        height_return:    UnsignedIntStar
): Status;

<*EXTERNAL*> PROCEDURE XQueryBestSize(
        display:          DisplayStar;
        class:            Int;
        which:            Drawable;
        width:            UnsignedInt;
        height:           UnsignedInt;
        width_return:     UnsignedIntStar;
        height_return:    UnsignedIntStar
): Status;

<*EXTERNAL*> PROCEDURE XQueryBestStipple(
        display:          DisplayStar;
        which:            Drawable;
        width:            UnsignedInt;
        height:           UnsignedInt;
        width_return:     UnsignedIntStar;
        height_return:    UnsignedIntStar
): Status;

<*EXTERNAL*> PROCEDURE XQueryBestTile(
        display:          DisplayStar;
        which:            Drawable;
        width:            UnsignedInt;
        height:           UnsignedInt;
        width_return:     UnsignedIntStar;
        height_return:    UnsignedIntStar
): Status;

<*EXTERNAL*> PROCEDURE XQueryColor(
        display:          DisplayStar;
        colormap:         Colormap;
        def:              XColorStar
);

<*EXTERNAL*> PROCEDURE XQueryColors(
        display:          DisplayStar;
        colormap:         Colormap;
        defs:             XColorStar;
        ncolors:          Int
);

<*EXTERNAL*> PROCEDURE XQueryExtension(
        display:          DisplayStar;
        name:             ConstCharStar;
        major_opcode:     IntStar;
        first_event:      IntStar;
        first_error:      IntStar
): Bool;

<*EXTERNAL*> PROCEDURE XQueryKeymap(
        display:          DisplayStar;
        keys:             Char
);

<*EXTERNAL*> PROCEDURE XQueryPointer(
        display:          DisplayStar;
        w:                Window;
        root:             WindowStar;
        child:            WindowStar;
        root_x:           IntStar;
        root_y:           IntStar;
        win_x:            IntStar;
        win_y:            IntStar;
        mask:             UnsignedIntStar
): Bool;

<*EXTERNAL*> PROCEDURE XQueryTextExtents(
        display:          DisplayStar;
        font_ID:          XID;
        string:           ConstCharStar;
        nchars:           Int;
        direction:        IntStar;
        font_ascent:      IntStar;
        font_descent:     IntStar;
        overall:          XCharStructStar
);

<*EXTERNAL*> PROCEDURE XQueryTextExtents16(
        display:          DisplayStar;
        font_ID:          XID;
        string:           XChar2bStar;
        nchars:           Int;
        direction:        IntStar;
        font_ascent:      IntStar;
        font_descent:     IntStar;
        overall:          XCharStructStar
);

<*EXTERNAL*> PROCEDURE XQueryTree(
        display:          DisplayStar;
        w:                Window;
        root:             WindowStar;
        parent:           WindowStar;
        children:         WindowStarStar;
        nchildren:        UnsignedIntStar
): Status;

<*EXTERNAL*> PROCEDURE XRaiseWindow(
        display:          DisplayStar;
        w:                Window
);

<*EXTERNAL*> PROCEDURE XReadBitmapFile(
        display:          DisplayStar;
        d:                Drawable;
        filename:         ConstCharStar;
        width:            UnsignedIntStar;
        height:           UnsignedIntStar;
        bitmap:           PixmapStar;
        x:                IntStar;
        y:                IntStar
): Int;

<*EXTERNAL*> PROCEDURE XRebindKeysym(
        display:          DisplayStar;
        keysym:           KeySym;
        list:             KeySymStar;
        mod:              Int;
        string:           ConstUnsignedCharStar;
        bytes:            Int
);

<*EXTERNAL*> PROCEDURE XRecolorCursor(
        display:          DisplayStar;
        cursor:           Cursor;
        foreground:       XColorStar;
        background:       XColorStar
);

<*EXTERNAL*> PROCEDURE XRefreshKeyboardMapping(
        event:            XMappingEventStar
);

<*EXTERNAL*> PROCEDURE XRemoveFromSaveSet(
        display:          DisplayStar;
        w:                Window
);

<*EXTERNAL*> PROCEDURE XRemoveHost(
        display:          DisplayStar;
        host:             XHostAddressStar
);

<*EXTERNAL*> PROCEDURE XRemoveHosts(
        display:          DisplayStar;
        hosts:            XHostAddressStar;
        num:              Int
);

<*EXTERNAL*> PROCEDURE XReparentWindow(
        display:          DisplayStar;
        w:                Window;
        parent:           Window;
        x:                Int;
        y:                Int
);

<*EXTERNAL*> PROCEDURE XResetScreenSaver(
        display:          DisplayStar
);

<*EXTERNAL*> PROCEDURE XResizeWindow(
        display:          DisplayStar;
        w:                Window;
        width:            UnsignedInt;
        height:           UnsignedInt
);

<*EXTERNAL*> PROCEDURE XRestackWindows(
        display:          DisplayStar;
        windows:          WindowStar;
        nwindows:         Int
);

<*EXTERNAL*> PROCEDURE XRotateBuffers(
        display:          DisplayStar;
        rotate:           Int
);

<*EXTERNAL*> PROCEDURE XRotateWindowProperties(
        display:          DisplayStar;
        w:                Window;
        properties:       AtomStar;
        num:              Int;
        npositions:       Int
);

<*EXTERNAL*> PROCEDURE XScreenCount(
        display:          DisplayStar
): Int;

<*EXTERNAL*> PROCEDURE XSelectInput(
        display:          DisplayStar;
        w:                Window;
        event:            Long
);

<*EXTERNAL*> PROCEDURE XSendEvent(
        display:          DisplayStar;
        w:                Window;
        propagate:        Bool;
        event_mask:       Long;
        event_send:       XEventStar
): Status;

<*EXTERNAL*> PROCEDURE XSetAccessControl(
        display:          DisplayStar;
        mode:             Int
);

<*EXTERNAL*> PROCEDURE XSetArcMode(
        display:          DisplayStar;
        gc:               GC;
        arc:              Int
);

<*EXTERNAL*> PROCEDURE XSetBackground(
        display:          DisplayStar;
        gc:               GC;
        background:       UnsignedLong
);

<*EXTERNAL*> PROCEDURE XSetClipMask(
        display:          DisplayStar;
        gc:               GC;
        pixmap:           Pixmap
);

<*EXTERNAL*> PROCEDURE XSetClipOrigin(
        display:          DisplayStar;
        gc:               GC;
        clip_x:           Int;
        clip_y:           Int
);

<*EXTERNAL*> PROCEDURE XSetClipRectangles(
        display:          DisplayStar;
        gc:               GC;
        clip_x:           Int;
        clip_y:           Int;
        rectangles:       XRectangleStar;
        n:                Int;
        ordering:         Int
);

<*EXTERNAL*> PROCEDURE XSetCloseDownMode(
        display:          DisplayStar;
        close:            Int
);

<*EXTERNAL*> PROCEDURE XSetCommand(
        display:          DisplayStar;
        w:                Window;
        argv:             M3toC.Argv;
        argc:             Int
);

<*EXTERNAL*> PROCEDURE XSetDashes(
        display:          DisplayStar;
        gc:               GC;
        dash_offset:      Int;
        dash_list:        ConstCharStar;
        n:                Int
);

<*EXTERNAL*> PROCEDURE XSetFillRule(
        display:          DisplayStar;
        gc:               GC;
        fill:             Int
);

<*EXTERNAL*> PROCEDURE XSetFillStyle(
        display:          DisplayStar;
        gc:               GC;
        fill:             Int
);

<*EXTERNAL*> PROCEDURE XSetFont(
        display:          DisplayStar;
        gc:               GC;
        font:             Font
);

<*EXTERNAL*> PROCEDURE XSetFontPath(
        display:          DisplayStar;
        directories:      CharStarStar;
        ndirs:            Int
);

<*EXTERNAL*> PROCEDURE XSetForeground(
        display:          DisplayStar;
        gc:               GC;
        foreground:       UnsignedLong
);

<*EXTERNAL*> PROCEDURE XSetFunction(
        display:          DisplayStar;
        gc:               GC;
        function:         Int
);

<*EXTERNAL*> PROCEDURE XSetGraphicsExposures(
        display:          DisplayStar;
        gc:               GC;
        graphics:         Bool
);

<*EXTERNAL*> PROCEDURE XSetIconName(
        display:          DisplayStar;
        w:                Window;
        icon:             ConstCharStar
);

<*EXTERNAL*> PROCEDURE XSetInputFocus(
        display:          DisplayStar;
        focus:            Window;
        revert_to:        Int;
        time:             Time
);

<*EXTERNAL*> PROCEDURE XSetLineAttributes(
        display:          DisplayStar;
        gc:               GC;
        line_width:       UnsignedInt;
        line_style:       Int;
        cap_style:        Int;
        join_style:       Int
);

<*EXTERNAL*> PROCEDURE XSetModifierMapping(
        display:          DisplayStar;
        modmap:           XModifierKeymapStar
): Int;

<*EXTERNAL*> PROCEDURE XSetPlaneMask(
        display:          DisplayStar;
        gc:               GC;
        plane:            UnsignedLong
);

<*EXTERNAL*> PROCEDURE XSetPointerMapping(
        display:          DisplayStar;
        map:              ConstUnsignedCharStar;
        nmap:             Int
): Int;

<*EXTERNAL*> PROCEDURE XSetScreenSaver(
        display:          DisplayStar;
        timeout:          Int;
        interval:         Int;
        prefer:           Int;
        allow:            Int
);

<*EXTERNAL*> PROCEDURE XSetSelectionOwner(
        display:          DisplayStar;
        selection:        Atom;
        owner:            Window;
        time:             Time
);

<*EXTERNAL*> PROCEDURE XSetState(
        display:          DisplayStar;
        gc:               GC;
        foreground:       UnsignedLong;
        background:       UnsignedLong;
        function:         Int;
        plane:            UnsignedLong
);

<*EXTERNAL*> PROCEDURE XSetStipple(
        display:          DisplayStar;
        gc:               GC;
        stipple:          Pixmap
);

<*EXTERNAL*> PROCEDURE XSetSubwindowMode(
        display:          DisplayStar;
        gc:               GC;
        subwindow:        Int
);

<*EXTERNAL*> PROCEDURE XSetTSOrigin(
        display:          DisplayStar;
        gc:               GC;
        ts_x_origin:      Int;
        ts_y_origin:      Int
);

<*EXTERNAL*> PROCEDURE XSetTile(
        display:          DisplayStar;
        gc:               GC;
        tile:             Pixmap
);

<*EXTERNAL*> PROCEDURE XSetWindowBackground(
        display:          DisplayStar;
        w:                Window;
        background:       UnsignedLong
);

<*EXTERNAL*> PROCEDURE XSetWindowBackgroundPixmap(
        display:          DisplayStar;
        w:                Window;
        background:       Pixmap
);

<*EXTERNAL*> PROCEDURE XSetWindowBorder(
        display:          DisplayStar;
        w:                Window;
        border:           UnsignedLong
);

<*EXTERNAL*> PROCEDURE XSetWindowBorderPixmap(
        display:          DisplayStar;
        w:                Window;
        border:           Pixmap
);

<*EXTERNAL*> PROCEDURE XSetWindowBorderWidth(
        display:          DisplayStar;
        w:                Window;
        width:            UnsignedInt
);

<*EXTERNAL*> PROCEDURE XSetWindowColormap(
        display:          DisplayStar;
        w:                Window;
        colormap:         Colormap
);

<*EXTERNAL*> PROCEDURE XStoreBuffer(
        display:          DisplayStar;
        bytes:            ConstCharStar;
        nbytes:           Int;
        buffer:           Int
);

<*EXTERNAL*> PROCEDURE XStoreBytes(
        display:          DisplayStar;
        bytes:            ConstCharStar;
        nbytes:           Int
);

<*EXTERNAL*> PROCEDURE XStoreColor(
        display:          DisplayStar;
        colormap:         Colormap;
        color:            XColorStar
);

<*EXTERNAL*> PROCEDURE XStoreColors(
        display:          DisplayStar;
        colormap:         Colormap;
        color:            XColorStar;
        ncolors:          Int
);

<*EXTERNAL*> PROCEDURE XStoreName(
        display:          DisplayStar;
        w:                Window;
        window:           ConstCharStar
);

<*EXTERNAL*> PROCEDURE XStoreNamedColor(
        display:          DisplayStar;
        colormap:         Colormap;
        color:            ConstCharStar;
        pixel:            UnsignedLong;
        flags:            Int
);

<*EXTERNAL*> PROCEDURE XSync(
        display:          DisplayStar;
        discard:          Bool
);

<*EXTERNAL*> PROCEDURE XTextExtents(
        font:             XFontStructStar;
        string:           ConstCharStar;
        nchars:           Int;
        direction_ret:    IntStar;
        font_ascent_ret:  IntStar;
        font_descent_ret: IntStar;
        overall_ret:      XCharStructStar
);

<*EXTERNAL*> PROCEDURE XTextExtents16(
        font:             XFontStructStar;
        string:           XChar2bStar;
        nchars:           Int;
        direction:        IntStar;
        font_ascent:      IntStar;
        font_descent:     IntStar;
        overall:          XCharStructStar
);

<*EXTERNAL*> PROCEDURE XTextWidth(
        font:             XFontStructStar;
        string:           ConstCharStar;
        count:            Int
): Int;

<*EXTERNAL*> PROCEDURE XTextWidth16(
        font:             XFontStructStar;
        string:           XChar2bStar;
        count:            Int
): Int;

<*EXTERNAL*> PROCEDURE XTranslateCoordinates(
        display:          DisplayStar;
        src_w:            Window;
        dest_w:           Window;
        src_x:            Int;
        src_y:            Int;
        dest_x_return:    IntStar;
        dest_y_return:    IntStar;
        child_return:     WindowStar
): Bool;

<*EXTERNAL*> PROCEDURE XUndefineCursor(
        display:          DisplayStar;
        w:                Window
);

<*EXTERNAL*> PROCEDURE XUngrabButton(
        display:          DisplayStar;
        button:           UnsignedInt;
        modifiers:        UnsignedInt;
        grab:             Window
);

<*EXTERNAL*> PROCEDURE XUngrabKey(
        display:          DisplayStar;
        keycode:          Int;
        modifiers:        UnsignedInt;
        grab:             Window
);

<*EXTERNAL*> PROCEDURE XUngrabKeyboard(
        display:          DisplayStar;
        time:             Time
);

<*EXTERNAL*> PROCEDURE XUngrabPointer(
        display:          DisplayStar;
        time:             Time
);

<*EXTERNAL*> PROCEDURE XUngrabServer(
        display:          DisplayStar
);

<*EXTERNAL*> PROCEDURE XUninstallColormap(
        display:          DisplayStar;
        colormap:         Colormap
);

<*EXTERNAL*> PROCEDURE XUnloadFont(
        display:          DisplayStar;
        font:             Font
);

<*EXTERNAL*> PROCEDURE XUnmapSubwindows(
        display:          DisplayStar;
        w:                Window
);

<*EXTERNAL*> PROCEDURE XUnmapWindow(
        display:          DisplayStar;
        w:                Window
);

<*EXTERNAL*> PROCEDURE XVendorRelease(
        display:          DisplayStar
): Int;

<*EXTERNAL*> PROCEDURE XWarpPointer(
        display:          DisplayStar;
        src_w:            Window;
        dest_w:           Window;
        src_x:            Int;
        src_y:            Int;
        src_width:        UnsignedInt;
        src_height:       UnsignedInt;
        dest_x:           Int;
        dest_y:           Int
);

<*EXTERNAL*> PROCEDURE XWidthMMOfScreen(
        screen:           ScreenStar
): Int;

<*EXTERNAL*> PROCEDURE XWidthOfScreen(
        screen:           ScreenStar
): Int;

<*EXTERNAL*> PROCEDURE  XWindowEvent(
        display:          DisplayStar;
        w:                Window;
        event_mask:       Long;
        event_return:     XEventStar
);

<*EXTERNAL*> PROCEDURE XWriteBitmapFile(
        display:          DisplayStar;
        filename:         CharStar;
        bitmap:           Pixmap;
        width:            UnsignedInt;
        height:           UnsignedInt;
        x_hot:            Int;
        y_hot:            Int
): Int;

(***************************************************************

                /usr/include/X11/Xutil.h

/* $XConsortium: Xutil.h,v 11.58 89/12/12 20:15:40 jim Exp $ */
 ***************************************************************)


(* 
 * Bitmask returned by XParseGeometry().  Each bit tells if the corresponding
 * value (x, y, width, height) was found in the parsed string.
 *)

CONST
  NoValue =		16_0000;
  XValue = 	 	16_0001;
  YValue =		16_0002;
  WidthValue =  	16_0004;
  HeightValue =  	16_0008;
  AllValues = 		16_000F;
  XNegative = 		16_0010;
  YNegative = 		16_0020;

(*
 * new version containing base_width, base_height, and win_gravity fields;
 * used with WM_NORMAL_HINTS.
 *)

TYPE
  XSizeHints = RECORD
    	flags: Long;	(* marks which fields in this structure are defined *)
	x, y: Int;		(* obsolete for new window mgrs, but clients *)
	width, height: Int;	(* should set so old wm's don't mess up *)
	min_width, min_height: Int;
	max_width, max_height: Int;
    	width_inc, height_inc: Int;
	min_aspect, max_aspect: RECORD
		x: Int;	(* numerator *)
		y: Int;	(* denominator *)
	END;
	base_width, base_height: Int;		(* added by ICCCM version 1 *)
	win_gravity: Int;			(* added by ICCCM version 1 *)
  END;
  XSizeHintsStar = UNTRACED REF XSizeHints;


(*
 * The next block of definitions are for window manager properties that
 * clients and applications use for communication.
 *)

(* flags argument in size hints *)
CONST
  USPosition =	Word.Shift(1, 0); (* user specified x, y *)
  USSize =	Word.Shift(1, 1); (* user specified width, height *)

  PPosition =	Word.Shift(1, 2); (* program specified position *)
  PSize	=	Word.Shift(1, 3); (* program specified size *)
  PMinSize =	Word.Shift(1, 4); (* program specified minimum size *)
  PMaxSize =	Word.Shift(1, 5); (* program specified maximum size *)
  PResizeInc =	Word.Shift(1, 6); (* program specified resize increments *)
  PAspect =	Word.Shift(1, 7); (* program specified min and max aspect ratios *)
  PBaseSize =	Word.Shift(1, 8); (* program specified base for incrementing *)
  PWinGravity =	Word.Shift(1, 9); (* program specified window gravity *)

(*?!?!?!
(* obsolete *)
#define PAllHints (PPosition|PSize|PMinSize|PMaxSize|PResizeInc|PAspect)
?!?!?!?!*)

TYPE
  XWMHints = RECORD
	flags: Long;	(* marks which fields in this structure are defined *)
	input: Bool;	(* does this application rely on the window manager to
			get keyboard input? *)
	initial_state: Int;	(* see below *)
	icon_pixmap: Pixmap;	(* pixmap to be used as icon *)
	icon_window: Window; 	(* window to be used as icon *)
	icon_x, icon_y: Int; 	(* initial position of icon *)
	icon_mask: Pixmap;	(* icon mask bitmap *)
	window_group: XID;	(* id of related window group *)
	(* this structure may be extended in the future *)
  END;
  XWMHintsStar = UNTRACED REF XWMHints;

(* definition for flags of XWMHints *)

CONST
  InputHint = 		Word.Shift(1, 0);
  StateHint =		Word.Shift(1, 1);
  IconPixmapHint =	Word.Shift(1, 2);
  IconWindowHint =	Word.Shift(1, 3);
  IconPositionHint = 	Word.Shift(1, 4);
  IconMaskHint =	Word.Shift(1, 5);
  WindowGroupHint =	Word.Shift(1, 6);
  AllHints = 		Word.Or(InputHint, Word.Or(StateHint, Word.Or(IconPixmapHint, Word.Or(IconWindowHint, Word.Or(IconPositionHint, Word.Or(IconMaskHint, WindowGroupHint))))));

(* definitions for initial window state *)
  WithdrawnState = 0;	(* for windows that are not mapped *)
  NormalState = 1;	(* most applications want to start this way *)
  IconicState = 3;	(* application wants to start as an icon *)

(*
 * Obsolete states no longer defined by ICCCM
 *)
  DontCareState = 0;	(* don't know or care *)
  ZoomState = 2;	(* application wants to start zoomed *)
  InactiveState = 4;	(* application believes it is seldom used; *)
			(* some wm's may put it on inactive menu *)


(*
 * new structure for manipulating TEXT properties; used with WM_NAME, 
 * WM_ICON_NAME, WM_CLIENT_MACHINE, and WM_COMMAND.
 *)
TYPE
  XTextProperty = RECORD
    value: UnsignedCharStar;		(* same as Property routines *)
    encoding: Atom;			(* prop type *)
    format: Int;			(* prop data format: 8, 16, or 32 *)
    nitems: UnsignedLong;		(* number of data items in value *)
  END;
  XTextPropertyStar = UNTRACED REF XTextProperty;

  XIconSize = RECORD
	        min_width, min_height: Int;
	        max_width, max_height: Int;
	        width_inc, height_inc: Int
              END;
  XIconSizeStar		= UNTRACED REF XIconSize; 
  XIconSizeStarStar	= UNTRACED REF XIconSizeStar; 

  XClassHint = RECORD  
	         res_name: CharStar;
	         res_class: CharStar
               END;

  XClassHintStar	= UNTRACED REF XClassHintStar;


(* ?!?!?!
(*
 * These macros are used to give some sugar to the image routines so that
 * naive people are more comfortable with them.
 *)
#define XDestroyImage(ximage) \
	(( *((ximage)->f.destroy_image))((ximage)))
#define XGetPixel(ximage, x, y) \
	(( *((ximage)->f.get_pixel))((ximage), (x), (y)))
#define XPutPixel(ximage, x, y, pixel) \
	(( *((ximage)->f.put_pixel))((ximage), (x), (y), (pixel)))
#define XSubImage(ximage, x, y, width, height)  \
	(( *((ximage)->f.sub_image))((ximage), (x), (y), (width), (height)))
#define XAddPixel(ximage, value) \
	(( *((ximage)->f.add_pixel))((ximage), (value)))

?!?!?! *)

(*
 * Compose sequence status structure, used in calling XLookupString.
 *)

TYPE
  XComposeStatus = RECORD
    compose_ptr: CharStar;	(* state table pointer *)
    chars_matched: Int;		(* match state *)
  END;
  XComposeStatusStar = UNTRACED REF XComposeStatus;

(* ?!?!?!
(*
 * Keysym macros, used on Keysyms to test for classes of symbols
 *)
#define IsKeypadKey(keysym) \
  (((unsigned)(keysym) >= XK_KP_Space) && ((unsigned)(keysym) <= XK_KP_Equal))

#define IsCursorKey(keysym) \
  (((unsigned)(keysym) >= XK_Home)     && ((unsigned)(keysym) <  XK_Select))

#define IsPFKey(keysym) \
  (((unsigned)(keysym) >= XK_KP_F1)     && ((unsigned)(keysym) <= XK_KP_F4))

#define IsFunctionKey(keysym) \
  (((unsigned)(keysym) >= XK_F1)       && ((unsigned)(keysym) <= XK_F35))

#define IsMiscFunctionKey(keysym) \
  (((unsigned)(keysym) >= XK_Select)   && ((unsigned)(keysym) <  XK_KP_Space))

#define IsModifierKey(keysym) \
  (((unsigned)(keysym) >= XK_Shift_L)  && ((unsigned)(keysym) <= XK_Hyper_R))

(*
 * opaque reference to Region data type 
 *)
typedef struct _XRegion *Region; 
?!?!? *)

TYPE
  Region = ADDRESS;

(* Return values from XRectInRegion() *)
 
CONST
  RectangleOut = 0;
  RectangleIn =  1;
  RectanglePart = 2;
 

(*
 * Information used by the visual utility routines to find desired visual
 * type from the many visuals a display may support.
 *)

TYPE
  XVisualInfo = RECORD
    visual: VisualStar;
    visualid: VisualID;
    screen: Int;
    depth: Int;
    class: Int;
    red_mask: UnsignedLong;
    green_mask: UnsignedLong;
    blue_mask: UnsignedLong;
    colormap_size: Int;
    bits_per_rgb: Int;
  END;
  XVisualInfoStar = UNTRACED REF XVisualInfo;

CONST
  VisualNoMask =		16_0;
  VisualIDMask = 		16_1;
  VisualScreenMask =		16_2;
  VisualDepthMask =		16_4;
  VisualClassMask =		16_8;
  VisualRedMaskMask =		16_10;
  VisualGreenMaskMask =		16_20;
  VisualBlueMaskMask =		16_40;
  VisualColormapSizeMask =	16_80;
  VisualBitsPerRGBMask =	16_100;
  VisualAllMask =		16_1FF;

(*
 * This defines a window manager property that clients may use to
 * share standard color maps of type RGB_COLOR_MAP:
 *)

TYPE
  XStandardColormap = RECORD
	colormap: Colormap;
	red_max: UnsignedLong;
	red_mult: UnsignedLong;
	green_max: UnsignedLong;
	green_mult: UnsignedLong;
	blue_max: UnsignedLong;
	blue_mult: UnsignedLong;
	base_pixel: UnsignedLong;
	visualid: VisualID;		(* added by ICCCM version 1 *)
	killid: XID;			(* added by ICCCM version 1 *)
  END;
  XStandardColormapStar   = UNTRACED REF XStandardColormap;
  XStandardColormapStarStar   = UNTRACED REF XStandardColormapStar;

CONST
  ReleaseByFreeingColormap: XID = 1;  (* for killid field above *)

(*
 * return codes for XReadBitmapFile and XWriteBitmapFile
 *)

CONST
  BitmapSuccess =		0;
  BitmapOpenFailed = 		1;
  BitmapFileInvalid = 		2;
  BitmapNoMemory =		3;

(*
 * Declare the routines that don't return int.
 *)

(****************************************************************
 *
 * Context Management
 *
 ****************************************************************)


(* Associative lookup table return codes *)

CONST
  XCSUCCESS = 0;	(* No error. *)
  XCNOMEM =   1;	(* Out of memory *)
  XCNOENT =   2;    	(* No entry in table *)

TYPE
  XContext = Int;

(* ?!?!?!?
#define XUniqueContext()       ((XContext) XrmUniqueQuark())
#define XStringToContext(string)   ((XContext) XrmStringToQuark(string))
?!?!?! *)

<*EXTERNAL*> PROCEDURE XSaveContext (
        display:                    DisplayStar;
        w:                          Window;
        context:                    XContext;
        data:                       ADDRESS
): Int;

<*EXTERNAL*> PROCEDURE XFindContext (
        display:                    DisplayStar;
        w:                          Window;
        context:                    XContext;
        data_return:                ADDRESS
): Int;

<*EXTERNAL*> PROCEDURE XDeleteContext (
        display:                    DisplayStar;
        w:                          Window;
        context:                    XContext
): Int;


<*EXTERNAL*> PROCEDURE XGetWMHints (
        display:                    DisplayStar;
        w:                          Window
): XWMHintsStar;

<*EXTERNAL*> PROCEDURE XCreateRegion (): Region;

<*EXTERNAL*> PROCEDURE XPolygonRegion (
        points:                     XPointStar;
        n:                          Int;
        fill_rule:                  Int
): Region;

<*EXTERNAL*> PROCEDURE XGetVisualInfo (
        display:                    DisplayStar;
        vinfo_mask:                 Long;
        vinfo_template:             XVisualInfoStar;
        nitems_return:              IntStar
): XVisualInfoStar;

(* Allocation routines for properties that may get longer *)

<*EXTERNAL*> PROCEDURE XAllocSizeHints  (): XSizeHintsStar;

<*EXTERNAL*> PROCEDURE XAllocStandardColormap (): XStandardColormapStar;

<*EXTERNAL*> PROCEDURE XAllocWMHints  (): XWMHintsStar;

<*EXTERNAL*> PROCEDURE XAllocClassHint  (): XClassHintStar;

<*EXTERNAL*> PROCEDURE XAllocIconSize  (): XIconSizeStar;

(* ICCCM routines for data structures defined in this file *)
<*EXTERNAL*> PROCEDURE XGetWMSizeHints (
        display:                    DisplayStar;
        w:                          Window;
        hints_return:               XSizeHintsStar;
        supplied_return:            LongStar;
        property:                   Atom
): Status;

<*EXTERNAL*> PROCEDURE XGetWMNormalHints (
        display:                    DisplayStar;
        w:                          Window;
        hints_return:               XSizeHintsStar;
        supplied_return:            LongStar
): Status;

<*EXTERNAL*> PROCEDURE XGetRGBColormaps (
        display:                    DisplayStar;
        w:                          Window;
        stdcmap_return:             XStandardColormapStarStar;
        count_return:               IntStar;
        property:                   Atom
): Status;

<*EXTERNAL*> PROCEDURE XGetTextProperty (
        display:                    DisplayStar;
        window:                     Window;
        text_prop_return:           XTextPropertyStar;
        property:                   Atom
): Status;

<*EXTERNAL*> PROCEDURE XGetWMName (
        display:                    DisplayStar;
        w:                          Window;
        text_prop_return:           XTextPropertyStar
): Status;

<*EXTERNAL*> PROCEDURE XGetWMIconName (
        display:                    DisplayStar;
        w:                          Window;
        text_prop_return:           XTextPropertyStar
): Status;

<*EXTERNAL*> PROCEDURE XGetWMClientMachine (
        display:                    DisplayStar;
        w:                          Window;
        text_prop_return:           XTextPropertyStar
): Status;

<*EXTERNAL*> PROCEDURE XSetWMProperties (
        display:                    DisplayStar;
        w:                          Window;
        window_name:                XTextPropertyStar;
        icon_name:                  XTextPropertyStar;
        argv:                       M3toC.Argv;
        argc:                       Int;
        normal_hints:               XSizeHintsStar;
        wm_hints:                   XWMHintsStar;
        class_hints:                XClassHintStar
);

<*EXTERNAL*> PROCEDURE XSetWMSizeHints (
        display:                    DisplayStar;
        w:                          Window;
        hints:                      XSizeHintsStar;
        property:                   Atom
);

<*EXTERNAL*> PROCEDURE XSetWMNormalHints (
        display:                    DisplayStar;
        w:                          Window;
        hints:                      XSizeHintsStar
);

<*EXTERNAL*> PROCEDURE XSetRGBColormaps (
        display:                    DisplayStar;
        w:                          Window;
        stdcmaps:                   XStandardColormapStar;
        count:                      Int;
        property:                   Atom
);

<*EXTERNAL*> PROCEDURE XSetTextProperty (
        display:                    DisplayStar;
        w:                          Window;
        text_prop:                  XTextPropertyStar;
        property:                   Atom
);

<*EXTERNAL*> PROCEDURE XSetWMName (
        display:                    DisplayStar;
        w:                          Window;
        text_prop:                  XTextPropertyStar
);

<*EXTERNAL*> PROCEDURE XSetWMIconName (
        display:                    DisplayStar;
        w:                          Window;
        text_prop:                  XTextPropertyStar
);

<*EXTERNAL*> PROCEDURE XSetWMClientMachine (
        display:                    DisplayStar;
        w:                          Window;
        text_prop:                  XTextPropertyStar
);

<*EXTERNAL*> PROCEDURE XStringListToTextProperty (
        list:                       CharStarStar;
        count:                      Int;
        text_prop_return:           XTextPropertyStar
): Status;

<*EXTERNAL*> PROCEDURE XTextPropertyToStringList (
        text_prop:                  XTextPropertyStar;
        list_return:                CharStarStarStar;
        count_return:               IntStar
): Status;

(* The following declarations are alphabetized. *)

<*EXTERNAL*> PROCEDURE XClipBox (
        r:                          Region;
        rect_return:                XRectangleStar
);

<*EXTERNAL*> PROCEDURE XDestroyRegion (
        r:                          Region
);

<*EXTERNAL*> PROCEDURE XEmptyRegion (
        r:                          Region
);

<*EXTERNAL*> PROCEDURE XEqualRegion (
        r1:                         Region;
        r2:                         Region
);

<*EXTERNAL*> PROCEDURE XGetClassHint (
        display:                    DisplayStar;
        w:                          Window;
        class_hints_return:         XClassHintStar
): Status;

<*EXTERNAL*> PROCEDURE XGetIconSizes (
        display:                    DisplayStar;
        w:                          Window;
        size_list_return:           XIconSizeStarStar;
        count_return:               IntStar
): Status;

<*EXTERNAL*> PROCEDURE XGetNormalHints (
        display:                    DisplayStar;
        w:                          Window;
        hints_return:               XSizeHintsStar
): Status;

<*EXTERNAL*> PROCEDURE XGetSizeHints (
        display:                    DisplayStar;
        w:                          Window;
        hints_return:               XSizeHintsStar;
        property:                   Atom
): Status;

<*EXTERNAL*> PROCEDURE XGetStandardColormap (
        display:                    DisplayStar;
        w:                          Window;
        colormap_return:            XStandardColormapStar;
        property:                   Atom
): Status;

<*EXTERNAL*> PROCEDURE XGetZoomHints (
        display:                    DisplayStar;
        w:                          Window;
        zhints_return:              XSizeHintsStar
): Status;

<*EXTERNAL*> PROCEDURE XIntersectRegion (
        sra:                        Region;
        srb:                        Region;
        dr_return:                  Region
);

<*EXTERNAL*> PROCEDURE XLookupString (
        event_struct:               XKeyEventStar;
        buffer_return:              CharStar;
        bytes_buffer:               Int;
        keysym_return:              KeySymStar;
        status_in_out:              XComposeStatusStar
): Int;

<*EXTERNAL*> PROCEDURE XMatchVisualInfo (
        display:                    DisplayStar;
        screen:                     Int;
        depth:                      Int;
        class:                      Int;
        vinfo_return:               XVisualInfoStar
): Status;

<*EXTERNAL*> PROCEDURE XOffsetRegion (
        r:                          Region;
        dx:                         Int;
        dy:                         Int
);

<*EXTERNAL*> PROCEDURE XPointInRegion (
        r:                          Region;
        x:                          Int;
        y:                          Int
): Bool;

<*EXTERNAL*> PROCEDURE XRectInRegion (
        r:                          Region;
        x:                          Int;
        y:                          Int;
        width:                      UnsignedInt;
        height:                     UnsignedInt
): Int;

<*EXTERNAL*> PROCEDURE XSetClassHint (
        display:                    DisplayStar;
        w:                          Window;
        class_hints:                XClassHintStar
);

<*EXTERNAL*> PROCEDURE XSetIconSizes (
        display:                    DisplayStar;
        w:                          Window;
        size_list:                  XIconSizeStar;
        count:                      Int
);

<*EXTERNAL*> PROCEDURE XSetNormalHints (
        display:                    DisplayStar;
        w:                          Window;
        hints:                      XSizeHintsStar
);

<*EXTERNAL*> PROCEDURE XSetSizeHints (
        display:                    DisplayStar;
        w:                          Window;
        hints:                      XSizeHintsStar;
        property:                   Atom
);

<*EXTERNAL*> PROCEDURE XSetStandardProperties (
        display:                    DisplayStar;
        w:                          Window;
        window_name:                ConstCharStar;
        icon_name:                  ConstCharStar;
        icon_pixmap:                Pixmap;
        argv:                       M3toC.Argv;
        argc:                       Int;
        hints:                      XSizeHintsStar
);

<*EXTERNAL*> PROCEDURE XSetWMHints (
        display:                    DisplayStar;
        w:                          Window;
        wm_hints:                   XWMHintsStar
);

<*EXTERNAL*> PROCEDURE XSetRegion (
        display:                    DisplayStar;
        gc:                         GC;
        r:                          Region
);

<*EXTERNAL*> PROCEDURE XSetStandardColormap (
        display:                    DisplayStar;
        w:                          Window;
        colormap:                   XStandardColormapStar;
        property:                   Atom
);

<*EXTERNAL*> PROCEDURE XSetZoomHints (
        display:                    DisplayStar;
        w:                          Window;
        zhints:                     XSizeHintsStar
);

<*EXTERNAL*> PROCEDURE XShrinkRegion (
        r:                          Region;
        dx:                         Int;
        dy:                         Int
);

<*EXTERNAL*> PROCEDURE XSubtractRegion (
        sra:                        Region;
        srb:                        Region;
        dr_return:                  Region
);

<*EXTERNAL*> PROCEDURE XUnionRectWithRegion (
        rectangle:                  XRectangleStar;
        src_region:                 Region;
        dest_region_return:         Region
);

<*EXTERNAL*> PROCEDURE XUnionRegion (
        sra:                        Region;
        srb:                        Region;
        dr_return:                  Region
);

<*EXTERNAL*> PROCEDURE XWMGeometry (
        display:                    DisplayStar;
        screen_number:              Int;
        user_geometry:              ConstCharStar;
        default_geometry:           ConstCharStar;
        border_width:               UnsignedInt;
        hints:                      XSizeHintsStar;
        x_return:                   IntStar;
        y_return:                   IntStar;
        width_return:               IntStar;
        height_return:              IntStar;
        gravity_return:             IntStar
): Int;

<*EXTERNAL*> PROCEDURE XXorRegion (
        sra:                        Region;
        srb:                        Region;
        dr_return:                  Region
);


END X.




