10 CLS : REM IRMASUBS SAMPLES 26 July 83
20 PRINT "IRMASUBS Programming Guide and Samples - IRMASUBS SAMPLE 1.20"
22 PRINT
24 PRINT "This program is intended as a programming and study guide only."
26 PRINT "     Do not attempt to continue execution of this program."
28 PRINT
30 PRINT "This program, if executed in interpreted BASICA requires a"
32 PRINT "specific IBM test screen initially and more than ONE HOUR to"
34 PRINT "complete execution."
36 PRINT
40 END
50 DEFINT A-Z
52 PRINT "IRMA BASIC SUBROUTINES DEMONSTRATION - IRMASUBS DEMO 1.01
54 PRINT : PRINT "Initializing IRMASUBS variables & tables
100 DIM I.TAB%(1279),I.BUF%(1920)               '*Dimension IRMA's tables
102 GOSUB 50000                                 '*Initialize IRMA's variables
110 PRINT
200 REM Field Report                            '*Field Report
202 I.VFL%=1                                    ' Start with the first field
204 PRINT "Field Row Column Length Contents"    ' Print field info header
206   FH$=" ####  ##   ##    ####  &"           ' Print using definition
210 GOSUB 50700                                 ' Find the first field
212 WHILE I.VER%=0                              ' Until no fields found
214   GOSUB 50900                               ' Read field contents
216   I.VOO%=1                                  ' Get string from buffer start
218   GOSUB 51100                               ' Read string I.VST$
220   I.VST$=LEFT$(I.VST$,40)                   ' Limit the length to screen
222   PRINT USING FH$;I.VFL%,I.VRO%,I.VCL%,I.VFS%,I.VST$
230   GOSUB 50800                               ' Find next field
240 WEND
300 REM Modify a few fields                     '*Modify field
302 I.VFL%=2                                    ' Second screen field
310 GOSUB 50700                                 ' Find the first field
320 I.VST$="Two"                                ' A simple string
322 I.VOO%=1                                    ' Beginning of data area
324 GOSUB 51200                                 ' Put string in buffer
326 GOSUB 51000                                 ' Write the field
328 IF I.VER%<>0 THEN PRINT "Error: ";I.VER%    ' Report possible error
330 GOSUB 50800                                 ' Point to next field
332 I.VST$="Three"                              ' More nice data
334 I.VOO%=1                                    ' Buffer start
336 GOSUB 51200                                 ' Put new string in buffer
338 IF I.VFS%>LEN(I.VST$) THEN I.VFS%=LEN(I.VST$) ' Shorten write length
340 GOSUB 51000                                 ' Write the field
345 STOP
400 REM Display part of the screen              '*Display
402 I.VCL%=1 : I.VRR%=40                        ' Column one
404 FOR I.VRO%=1 TO 5                           ' Top five lines
406   GOSUB 51300                               ' Read a short line
410   PRINT I.VST$                              ' Print the line
412 NEXT I.VRO%                                 ' Again, with feeling
500 REM General status info                     '*Status info
502 GOSUB 51400                                 ' Read cursor postion
504 PRINT "Buffer pointer ROW:";I.VRO%;"  COLUMN:";I.VCL%
510 GOSUB 50200                                 ' Get slave status
520 GOSUB 900                                   ' Display status
600 REM Send some keystrokes                    '*Keystrokes
602 I.VST$=CHR$(0)+CHR$(15)+"AAA"               ' Back tab character w/ string
604 GOSUB 50600                                 ' Send keystrokes
612 I.VST$=CHR$(9)+"bbb"                        ' Forward tab
614 GOSUB 50600                                 ' Send keystrokes
620 STOP
700 REM Clear any status                        '*Clear status
702 GOSUB 50200                                 ' Read current status
706 GOSUB 900                                   ' Display current status
710 GOSUB 50300                                 ' Clear all set bits
712 GOSUB 50200                                 ' Get the status again
714 GOSUB 900                                   ' Display the new status
800 REM Trigger stuffs                          '*Trigger tests
802 I.VRO%=1 : I.VCL%=1                         ' Upper left corner
804 I.VMS%=0 : I.VVL%=0                         ' Any change is a trigger
806 GOSUB 50400                                 ' Set trigger data & addr
808 PRINT "Waiting for any change in row 1, column 1"
820 WHILE LEN(INKEY$)=0                         ' Until a key is pressed
822   I.VTO%=2                                  ' 2 second timeout
824   GOSUB 50500                               ' Wait for trigger event
826   IF I.VTO%<0 THEN PRINT "."; : GOTO 840
830   PRINT "Trigger! "
836   GOTO 842
840 WEND
842 I.VST%=64                                   ' Clear trigger bit
844 GOSUB 50300                                 '
848 PRINT "Waiting for an upper case A in row 1, column 1"
850 I.VMS%=255 : I.VVL%=160                     ' Specific Upper case A
852 GOSUB 50400                                 ' Set the trigger again
860 WHILE LEN(INKEY$)=0                         ' Until a key is pressed
862   I.VTO%=2                                  ' 2 second timeout
864   GOSUB 50500                               ' Wait for trigger event
866   IF I.VTO%<0 THEN PRINT "."; : GOTO 870
867   PRINT "Trigger! "
868   GOTO 872
870 WEND
872 I.VST%=64                                   ' Clear trigger bit
874 GOSUB 50300                                 '
899 END
900 REM Display status words                    '!Status display
912 PRINT
918 PRINT "Main status word:"
920 IF (I.VST% AND I.MAX%) THEN PRINT "  Aux status change"
922 IF (I.VST% AND I.MTG%) THEN PRINT "  Trigger occurred"
924 IF (I.VST% AND I.MKY%) THEN PRINT "  Key buffer empty"
926 IF (I.VST% AND I.MPR%) THEN PRINT "  Controller issued reset"
928 IF (I.VST% AND I.MCC%) THEN PRINT "  Last command complete"
930 IF (I.VST% AND I.MDI%) THEN PRINT "  Buffer dirty (modified)"
932 IF (I.VST% AND I.MCM%) THEN PRINT "  Buffer pointer moved"
938 PRINT "Aux status word:"
940 IF (I.VAX% AND I.MPO%) THEN PRINT "  Poll occurred
942 IF (I.VAX% AND I.MAL%) THEN PRINT "  Alarm requested"
944 IF (I.VAX% AND I.MDD%) THEN PRINT "  Display disabled (Inhibited)"
946 IF (I.VAX% AND I.MCI%) THEN PRINT "  Cursor inhibited"
948 IF (I.VAX% AND I.MRC%) THEN PRINT "  Reverse video cursor"
950 IF (I.VAX% AND I.MBC%) THEN PRINT "  Blinking cursor"
952 IF (I.VAX% AND I.MCK%) THEN PRINT "  Keyboard clicker enabled"
980 RETURN
50000 REM Initialize IRMA interface variables   '!INIT - IRMASUBS Rev 1.01
50002 RESTORE 50036                             ' Point to initial values
50004 READ I.CRD%,I.CWR%,I.CAC%,I.CCL%,I.CKY%   ' Load command numbers
50006 READ I.CSP%,I.CXP%,I.CMD%,I.CTA%,I.CIM%
50008 READ I.MAX%,I.MTG%,I.MKY%,I.MXX%,I.MPR%   ' Main status masks
50010 READ I.MCC%,I.MDI%,I.MCM%
50012 READ I.MXX%,I.MPO%,I.MAL%,I.MDD%,I.MCI%   ' Aux status masks
50014 READ I.MRC%,I.MBC%,I.MCK%
50016 READ I.RG0%,I.RG1%,I.RG2%,I.RG3%          ' Communication registers
50018 READ I.RST%,I.RAK%,I.RAF%
50020 READ I.MAT%,I.MBS%                        ' Handshake masks
50022 READ I.VER%,I.VST%,I.VRO%,I.VCL%,I.VMS%   ' General variables
50024 READ I.VVL%,I.VFG%,I.VST$,I.VFL%,I.VT0%
50026 READ I.VT1%,I.VT2%,I.VT3%,I.VS0$,I.VS1$
50028 READ I.VAX%,I.VS2$,I.VS3$,I.VS4$,I.VS5$
50030 READ I.VS6$,I.VS7$,I.VS8$,I.VS9$,I.VT4%
50032 READ I.VT5%,I.VCB%,I.VCE%,I.VT8%,I.VT9%
50034 READ I.VOO%,I.VRR%,I.VFS%,I.VTO%
50036 DATA 0,1,2,3,4,5,6,7,8,9
50038 DATA 128,64,32,16,8,4,2,1
50040 DATA 128,64,32,16,8,4,2,1
50042 DATA &H220,&H221,&H222,&H223
50044 DATA &H226,&H227,&H227
50046 DATA 128,64
50048 DATA 0,0,0,0,0,0,0,"",0,0,0,0,0,"",""
50050 DATA 0,"","","","","","","","",0
50052 DATA 0,0,0,0,0,0,0,0,5
50058 DEF SEG
50060 BLOAD "IRMATABS.OVR",VARPTR(I.TAB%(0))
50062 RETURN
50100 REM Power on reset simulation             '*XPOR ( I.VER% )
50102 I.VER%=0                                  ' Reset error flag
50104 OUT I.RG0%,I.CXP%                         ' Set commmand in place
50106 GOSUB 58000                               ' Start & wait for slave
50108 RETURN
50200 REM Get slave status                      '*GSTAT ( I.VST%, I.VER% )
50202 I.VER%=0                                  ' Reset error flag
50204 OUT I.RG0%,I.CAC%                         ' Get aux status & cursor
50206 GOSUB 58000                               ' Start & wait for slave
50208 I.VAX%=INP(I.RG3%)                        ' Get aux
50210 I.VST%=INP(I.RG0%)                        ' Get main
50212 RETURN                                    ' Exit!
50300 REM Reset slave status bits               '*RSTAT ( I.VST%, I.VER% )
50302 I.VER%=0                                  ' Reset error flag
50304 OUT I.RG0%,I.CCL%                         ' Clear status command
50306 OUT I.RG3%,I.VST%                         ' Status bits to clear
50308 GOSUB 58000                               ' Start & wait for slave
50310 RETURN                                    ' Exit!
50400 REM Set trigger event & address           '*STDNM ( I.VRO%, I.VCL% )
50401 I.VER%=0                                  '         I.VMS%, I.VVL%
50402 GOSUB 58200                               ' Check row and column values
50403 IF I.VER%<>0 THEN RETURN                  ' Error if bad input
50404 OUT I.RG0%,I.CTA%                         '         I.VER%         )
50406 I.VT0%=(I.VCL%-1)+(I.VRO%*80)             ' Compute address
50408 OUT I.RG2%,I.VT0%\&H100                   ' High part of address
50410 OUT I.RG1%,I.VT0% AND &HFF                ' Low part of address
50411 GOSUB 58000                               ' Start slave
50412 IF ((I.VVL% OR I.VMS% ) AND &HFF00)<>0 THEN I.VER%=4 : RETURN ' Bad byte
50417 IF I.VER%<>0 THEN RETURN                  ' Give up if dead slave
50418 OUT I.RG0%,I.CMD%                         ' Setup mask & data
50419 OUT I.RG1%,I.VVL%                         ' Data
50420 OUT I.RG2%,I.VMS%                         ' Mask
50422 GOSUB 58000                               ' Set trigger.
50424 RETURN                                    ' Exit!
50500 REM Wait for trigger event                '*WTRIG ( I.VT0%, I.VER% )
50502 I.VER%=0                                  ' Reset error flag
50504 I.VS0$=TIME$                              ' Set the stopwatch
50506 IF (INP(I.RG0%) AND I.MTG%)<>0 THEN RETURN' All done!
50508 I.VER%=10                                 ' Potential timeout.
50510 IF I.VTO%<0 THEN RETURN                   ' Time has run out.
50512 IF I.VS0$=TIME$ THEN 50502                ' Still time, try again
50514 I.VTO%=I.VTO%-1                           ' Drop a grain of sand.
50516 GOTO 50502                                ' Do it some more.
50600 REM Send keystrokes from I.VST$           '*KEYS ( I.VST$, I.VER% ))
50602 I.VER%=0                                  ' Reset error flag
50604 I.VT0%=LEN(I.VST$)                        ' Count of remaining chars
50606 I.VT1%=1                                  ' Current pointer
50608 WHILE I.VT0%>0                            ' Only until none remain...
50610   I.VT2%=ASC(MID$(I.VST$,I.VT1%,1))       ' Get character value
50612   IF I.VT2%>0 THEN 50620                  ' Not an extended code...
50614     I.VT0%=I.VT0%-1 : I.VT1%=I.VT1%+1     ' Get set to eat next char
50616     IF I.VT0%<1 THEN 50658                ' EXIT if partial char
50618     I.VT2%=ASC(MID$(I.VST$,I.VT1%,1))+256 ' Offset into extended table
50620   I.VT2%=I.TAB%(I.VT2%+&H200)             ' Look up key codes
50622   IF (I.VT2% AND &HFF)=0 THEN 50634       ' Skip shift key
50624     I.VT3%=I.TAB%((I.VT2% AND &HFF)+&H400)' Get scan code of shift
50626     I.VT3%=I.VT3% AND &H7F                ' Strip up/dn control bit
50628     GOSUB 58100                           ' Transmit scan code
50630     IF I.VER%=0 THEN 50634                ' Skip error exit
50632       I.VT0%=-1 : GOTO 50658              ' Error on key attempt ABORT!
50634   IF (I.VT2% AND &HFF00)=0 THEN 50644     ' Handle possible lone shift
50636     I.VT3%=I.TAB%((I.VT2%\&H100)+&H400)   ' Get scan code
50638     GOSUB 58100                           ' Transmit it.
50640     IF I.VER%=0 THEN 50644                ' Skip error exit
50642       I.VT0%=-1 : GOTO 50658              ' PUNT.
50644   IF (I.VT2% AND &HFF)=0 THEN 50654       ' Skip shift key
50646     I.VT3%=I.TAB%((I.VT2% AND &HFF)+&H400)' Get scan code of shift
50648     GOSUB 58100                           ' Transmit scan code
50650     IF I.VER%=0 THEN 50654                ' Skip error exit
50652       I.VT0%=-1 : GOTO 50658              ' Error on key attempt ABORT!
50654   I.VT0%=I.VT0%-1                         ' One less character to send
50656   I.VT1%=I.VT1%+1                         ' Point to next character
50658 WEND                                      ' Do until done or error
50660 RETURN
50700 REM Find field I.VFL%                     '*FIND ( I.VFL%, I.VCL% ))
50702 I.VER%=0                                  '        I.VRO%, I.VER% )
50703 IF (I.VFL%<1) OR (I.VFL%>1920) THEN I.VER%=7 : RETURN
50704 I.VCE%=80 : I.VCB%=80 : I.BUF%(0)=&HC0    ' Start at upper left
50706 OUT I.RG0%,I.CRD%                         ' Preset the read command
50708 IF I.VFL%=1 THEN 50738                    ' Default screen condition
50710 I.VT1%=1                                  ' Current field number
50712 OUT I.RG1%,I.VCE% AND &HFF                ' Low order address
50714 OUT I.RG2%,I.VCE%\&H100                   ' High order address
50716 GOSUB 58000                               ' Start slave & wait
50718 IF I.VER%<>0 THEN RETURN                  ' PUNT if read error.
50720 I.VT2%=INP(I.RG3%)                        ' Get data
50722 IF I.VT2%<&HC0 THEN 50730                 ' Skip if not attribute
50724   IF (I.VT2% AND &H20)>0 THEN 50730       ' Skip if protected
50725     I.VCB%=I.VCE%                         ' Save start position
50726     I.VT1%=I.VT1%+1                       ' We've found the next field!
50727     I.BUF%(0)=I.VT2%                      ' Init buffer attribute
50728     IF I.VT1%=I.VFL% THEN 50736           ' Exit the search loop
50730 I.VCE%=I.VCE%+1                           ' Try next location
50732 IF I.VCE%>=2000 THEN I.VER%=7 : RETURN    ' Field not found anywhere!
50734 GOTO 50712                                ' Read the next character
50736 I.VCE%=I.VCE%+1                           ' Point to first char of field
50738 IF I.VCE%>=2000 THEN I.VER%=7 : RETURN    ' Field at last col/row
50740 I.VRO%=I.VCE%\80                          ' Make the row number
50742 I.VCL%=(I.VCE% MOD 80)+1                  ' And column number
50744 I.VFS%=0                                  ' Length of field
50746 OUT I.RG1%,I.VCE% AND &HFF                ' Low order address
50748 OUT I.RG2%,I.VCE%\&H100                   ' High order address
50750 GOSUB 58000                               ' Start read operation
50752 IF I.VER%<>0 THEN RETURN                  ' Quit if slave is dead
50754 I.VT2%=INP(I.RG3%)                        ' Get data
50756 IF I.VT2%>=&HC0 THEN RETURN               ' Next attribute found
50758 I.VFS%=I.VFS%+1                           ' Count the chars in field
50760 I.VCE%=I.VCE%+1                           ' Point to next char
50762 IF I.VCE%>=2000 THEN RETURN               ' Ran off end of screen!
50764 GOTO 50746                                ' Continue eating chars
50800 REM Find NEXT field I.VFL%+1              '*FNEXT ( I.VFL%, I.VCL%,)
50801 I.VER%=0                                  '       ( I.VRO%, I.VER% )
50802 I.VT1%=I.VFL% : I.VFL%=I.VFL%+1           ' Next field
50804 IF I.VCE%<80 THEN I.VER%=11 : RETURN      ' Illegal cursor value
50806 IF I.VCE%>=2000 THEN I.VER%=7 : RETURN    ' No next field.
50808 OUT I.RG0%,I.CRD%                         ' Set read command in place
50810 OUT I.RG1%,I.VCE% AND &HFF                ' Low order address
50812 OUT I.RG2%,I.VCE%\&H100                   ' High order address
50814 GOSUB 58000                               ' Get data at current position
50816 IF I.VER%>0 THEN RETURN                   ' Give up if slave dead
50820 I.VT9%=INP(I.RG3%)                        ' This should be attribute
50822 IF I.VT9%<&HC0 THEN I.VER%=11 : RETURN    ' Invalid cursor position
50830 GOTO 50712                                ' Enter general FIND code
50900 REM Read field                            '*RDFLD ( I.VER% )I.VCL%,)
50902 I.VER%=0 : I.VT2%=0                       ' Reset error flag & buffer ptr
50904 IF I.VCB%=80 THEN 50924                   ' Special case of upper corner
50906 IF I.VCB%<80 THEN I.VER%=11               ' Invalid start address
50908 IF I.VCB%>=2000 THEN I.VER%=11            ' Beyond end of screen
50910 OUT I.RG0%,I.CRD%                         ' Set read command
50912 OUT I.RG1%,I.VCB% AND &HFF                ' Low order address
50914 OUT I.RG2%,I.VCB%\&H100                   ' High order address
50916 GOSUB 58000                               ' Read the leading attribute
50918 I.VT3%=INP(I.RG3%)                        ' Data word
50920 IF (I.VT3% AND &HE0)<>&HC0 THEN I.VER%=5  : RETURN ' Bad field type
50922 GOTO 50930                                ' Scan and eat field
50924 I.VT2%=1                                  ' Increment buffer pointer
50926 I.BUF%(0)=&HC0                            ' Fake attribute
50930 OUT I.RG0%,I.CRD%                         ' Setup the read command
50934 WHILE I.VT2%<=I.VFS%                      ' Until out of characters
50936   I.VT9%=I.VT2%+I.VCB%                    ' Offset to character
50938   IF I.VT9%>=2000 THEN I.VER%=11 : GOTO 50950 ' bad field specs
50940   OUT I.RG1%,I.VT9% AND &HFF              ' Set low address
50942   OUT I.RG2%,I.VT9%\&H100                 ' High address
50946   GOSUB 58000                             ' Xecute read operation
50948   IF I.VER%=0 THEN 50960                  ' Abort if slave dead
50950     I.VT2%=9999                           ' Exit loop
50952     GOTO 50970                            '
50960   I.BUF%(I.VT2%)=CVI(CHR$(INP(I.RG3%))+CHR$(INP(I.RG2%)))
50962   I.VT2%=I.VT2%+1                         ' Point to next location
50970 WEND
50972 RETURN                                    ' All done
51000 REM Write field                           '*WRFLD ( I.VER% )I.VCL%,)
51002 I.VER%=0                                  ' Reset error flag
51004 IF I.VCB%<80 THEN I.VER%=11               ' Illegal address
51006 IF I.VCB%>=2000 THEN I.VER%=11            ' Too large
51008 IF I.VCB%+I.VT1%>2000 THEN I.VER%=12      ' Field too long for screen
51010 IF I.VER%<>0 THEN RETURN                  ' Quit if bad parameters
51012 OUT I.RG0%,I.CRD%                         ' Read attribute from screen
51014 OUT I.RG1%,I.VCB% AND &HFF                ' Low address
51016 OUT I.RG2%,I.VCB%\&H100                   ' High address
51018 GOSUB 58000                                ' Xecute!
51020 IF I.VER%<>0 THEN RETURN                  ' Abandon if dead slave
51022 IF (INP(I.RG3%) AND &HFE)<>(I.BUF%(0) AND &HFE) THEN I.VER%=13 : RETURN
51024 I.BUF%(0)=I.BUF%(0) OR 1                  ' Set the MDT flag
51026 I.VT2%=0                                  ' First byte of buffer to write
51028 IF (I.BUF%(0) AND &H10)=0 THEN 51052      ' Check for numeric only
51030   I.VT2%=1                                ' First buffer location to chk
51032   WHILE I.VT2%<=I.VT1%                    ' Do until all chars done
51034     I.VT0%=I.BUF%(I.VT2%) AND &HFF        ' Mask off any previous EAB
51036     IF I.VT0%>=&H20 THEN IF I.VT0%<=&H29 THEN 51048 ' 0-9 is Ok
51038       IF I.VT0%=&H31 THEN 51048           ' Minus Ok
51039       IF I.VT0%=&H32 THEN 51048           ' Period Ok
51040       IF I.VT0%=&H35 THEN 51048           ' Plus Ok
51042     I.VER%=6 : I.VT2%=9999                ' "Non-numeric" char
51048     I.VT2%=I.VT2%+1                       ' Next character
51050   WEND                                    ' Loop
51052 I.VT2%=0                                  ' Start from the beginning
51054 OUT I.RG0%,I.CWR%                         ' Set write command
51056 WHILE I.VT2%<=I.VFS%                      ' Until all characters written
51058   I.VT0%=I.VCB%+I.VT2%                    ' Compute address
51060   OUT I.RG1%,I.VT0% AND &HFF              ' Low address
51062   OUT I.RG2%,I.VT0%\&H100                 ' High address
51064   OUT I.RG3%,I.BUF%(I.VT2%) AND &HFF      ' Data w/o EAB
51066   GOSUB 58000                             ' Make slave do it.
51068   IF I.VER%<>0 THEN I.VT2%=9999           ' Force exit if slave DOA
51070   I.VT2%=I.VT2%+1                         ' Next location to write
51072 WEND                                      ' Do it again
51074 RETURN                                    ' All done!
51100 REM Get string from buffer                '*GSTR( I.VST$, I.VT1%
51105 I.VER%=0 : I.VT2%=0                       '       I.VT0%         )
51108 IF I.VOO%>1920 THEN I.VER%=12 : RETURN    ' Offset too large
51110 IF I.VOO%<0 THEN I.VER%=12 : RETURN       ' Offset negative
51112 I.VST$=""                                 ' Clear string
51114 WHILE (I.VOO%<=I.VFS%) AND (I.VT2%=0)     '
51116   I.VST$=I.VST$+CHR$(I.TAB%((I.BUF%(I.VOO%) AND &HFF)+&H100))
51118   I.VOO%=I.VOO%+1                         ' Point to next char
51120   IF LEN(I.VST$)=254 THEN I.VT2%=1        ' Overrun
51122 WEND
51126 RETURN
51200 REM Put string in buffer                  '*PSTR( I.VST$, I.VT1%
51202 I.VER%=0                                  '       I.VT0%         )
51204 IF I.VOO%+LEN(I.VST$)-1>I.VFS% THEN I.VER%=12 : RETURN ' Too long
51206 I.VT3%=LEN(I.VST$) : IF I.VT3%=0 THEN RETURN ' Zero strings easy!
51208 I.VT2%=0                                  ' Offset into buffer
51210 WHILE I.VT2%<I.VT3%                       ' While still characters
51212   I.BUF%(I.VOO%+I.VT2%)=I.TAB%(ASC(MID$(I.VST$,I.VT2%+1,1))+&H0)
51214   I.VT2%=I.VT2%+1                         ' Move pointer
51216 WEND
51218 I.VOO%=I.VOO%+I.VT2%                      ' Pointer for next
51220 RETURN                                    ' Transfer complete
51300 REM Read screen absolute                  '*ABSRD ( I.VER%, I.VST$,
51302 I.VER%=0                                  '         I.VS0$, I.VRO%,
51304 I.VT0%=I.VRO%*80+I.VCL%-1                 '         I.VCL%, I.VRR% )
51306 IF I.VT0%<0 THEN I.VER%=11 : RETURN       ' Invalid cursor address
51308 IF I.VT0%>=2000 THEN I.VER%=11 : RETURN   '
51310 IF I.VT0%+I.VRR%>2000 THEN I.VER%=12 : RETURN ' Can't read that much
51312 I.VT1%=0 : I.VST$="" : I.VS0$=""          ' Offset from start
51314 OUT I.RG0%,I.CRD% : I.VT2%=I.VT0%+I.VRR%  ' Set a read commnad
51316 WHILE I.VT0%<I.VT2%                       ' Until all characters read
51318   OUT I.RG1%,I.VT0% AND &HFF              ' Low order address
51320   OUT I.RG2%,I.VT0%\&H100                 ' High order address
51322   GOSUB 58000                             ' Execute read operation
51324   IF I.VER%<>0 THEN I.VT0%=9999           ' Force loop exit
51326   I.VST$=I.VST$+CHR$(I.TAB%(INP(I.RG3%)+&H100)) ' Get char & convert
51328   I.VS0$=I.VS0$+CHR$(INP(I.RG2%))         ' Unmodified EAB
51340   I.VT0%=I.VT0%+1                         ' Next character
51342 WEND
51344 RETURN
51400 REM Read 3278 cursor position             '*CPOS( I.VRO%, I.VCL%,
51402 I.VER%=0                                  '       I.VER%          )
51406 OUT I.RG0%,I.CAC%                         ' Status & cursor read
51408 GOSUB 58000                               ' Start the slave
51410 I.VT0%=(INP(I.RG2%)*&H100)+INP(I.RG1%)    ' Get absolute address
51411 IF I.VER%<>0 THEN RETURN                  ' Dead slave, quit action
51412 I.VRO%=I.VT0%\80                          ' Compute row
51414 I.VCL%=(I.VT0% MOD 80)+1                  ' And column
51416 RETURN
58000 REM Start & wait for slave		'!Start & wait for slave
58002 I.VS9$=TIME$ : I.VT9%=0                   ' A simulated stopwatch
58004 OUT I.RST%,0                              ' Start the slave
58006 I.VT8% = INP( I.RAF% ) AND I.MBS%         ' Get slave busy bit
58008 IF I.VT8% = 0 THEN RETURN                 ' Return with command complete
58010 IF I.VS9$=TIME$ THEN 58006                ' Loop until clock ticks
58012 I.VS9$=TIME$ : I.VT9%=I.VT9%+1            ' Three times
58014 IF I.VT9%<3 THEN 58006                    '
58016 I.VER%=1                                  ' Slave timeout
58018 RETURN                                    '
58100 REM Send key scan code from I.VT3%	'*Send key scan code
58102 I.VS9$=TIME$ : I.VT9%=0                   ' Make stopwatch
58104 IF (INP(I.RG0%) AND I.MKY%)>0 THEN 58114  ' Key buffer is ready
58106 IF I.VS9$=TIME$ THEN 58104                ' Loop until clock tick
58108 I.VT9%=I.VT9%+1 : IF I.VT9%<4 THEN 58104  ' Time has not run out
58110 I.VER%=9                                  ' Keystroke timeout
58112 RETURN
58114 IF I.VT3%=0 THEN I.VER%=15 : RETURN       ' Invalid scan code
58115 OUT I.RG0%,I.CKY%                         ' Keystroke command
58116 OUT I.RG3%,I.VT3%                         ' Scan code
58118 GOSUB 58000                               ' Fire up the slave
58120 RETURN                                    ' And we're done!
58200 REM - Verify Row and Column		'*Verify ROW/COL
58206 IF (I.VRO%<0) OR (I.VRO%>24) THEN I.VER%=2 : RETURN
58208 IF (I.VCL%<1) OR (I.VCL%>80) THEN I.VER%=3 : RETURN
58210 RETURN
